/*
 * Decompiled with CFR 0.152.
 */
package oracle.aurora.server.tools.shell;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.PrintStream;
import java.security.AccessController;
import oracle.aurora.server.tools.shell.ShellServer;
import oracle.aurora.util.RedirectIO;

public class ShellStoredProc {
    private static ShellStoredProc the_stored_proc;
    ByteArrayOutputStream command;
    byte[] reply;
    int reply_index;
    ShellServer shell = new ShellServer();

    private ShellStoredProc() {
    }

    private byte[] do_get_reply() {
        if (this.reply == null || this.reply_index > this.reply.length) {
            return null;
        }
        byte[] result = new byte[Math.min(4000, this.reply.length - this.reply_index)];
        System.arraycopy(this.reply, this.reply_index, result, 0, result.length);
        this.reply_index += 4000;
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void do_receive_command(byte[] bytes) {
        block10: {
            try {
                if (this.command == null) {
                    this.command = new ByteArrayOutputStream();
                }
                this.command.write(bytes);
                if (bytes.length >= 4000) break block10;
                ByteArrayOutputStream command_output = new ByteArrayOutputStream();
                PrintStream out = new PrintStream(command_output);
                PrintStream oldOut = System.out;
                PrintStream oldErr = System.err;
                try {
                    AccessController.doPrivileged(new RedirectIO(out, out));
                    try {
                        DataInputStream in = new DataInputStream(new ByteArrayInputStream(this.command.toByteArray()));
                        this.command = null;
                        String[] argv = new String[in.readShort()];
                        for (int i = 0; i < argv.length; ++i) {
                            argv[i] = in.readUTF();
                        }
                        this.shell.invoke_command(argv);
                    }
                    catch (Exception e) {
                        System.out.println("Error invoking command: " + e.toString());
                        e.printStackTrace(oldOut);
                    }
                }
                finally {
                    AccessController.doPrivileged(new RedirectIO(oldOut, oldErr));
                }
                out.flush();
                out.close();
                ByteArrayOutputStream reply_bytes = new ByteArrayOutputStream();
                DataOutputStream outStream = new DataOutputStream(reply_bytes);
                String comstr = command_output.toString();
                int comsize = comstr.length();
                int index = 0;
                int consz = 0;
                do {
                    consz = Math.min(comsize, 32768);
                    outStream.writeUTF(comstr.substring(index, index + consz));
                    index += consz;
                } while ((comsize -= consz) > 0);
                outStream.flush();
                outStream.close();
                this.reply = reply_bytes.toByteArray();
                this.reply_index = 0;
            }
            catch (IOException e) {
                System.out.println("Internal error in ShellStoredProc");
                e.printStackTrace();
            }
        }
    }

    public static byte[] get_reply() {
        ShellStoredProc.initialize();
        return the_stored_proc.do_get_reply();
    }

    static void initialize() {
        if (the_stored_proc == null) {
            try {
                the_stored_proc = new ShellStoredProc();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    public static void receive_command(byte[] bytes) {
        ShellStoredProc.initialize();
        the_stored_proc.do_receive_command(bytes);
    }
}

