/*
 * Decompiled with CFR 0.152.
 */
package oracle.aurora.server.tools.shell;

import java.util.Hashtable;
import oracle.aurora.rdbms.Schema;
import oracle.aurora.server.tools.shell.Java;
import oracle.aurora.server.tools.shell.Tool;
import oracle.aurora.server.tools.shell.ToolImpl;
import oracle.aurora.util.tools.ToolException;
import oracle.aurora.vm.EnvironmentSpecific;
import oracle.aurora.vm.OracleRuntime;

public class ShellServer
extends ToolImpl {
    private Hashtable tools = new Hashtable(10);

    public ShellServer() {
        this.initCommands();
    }

    public void invoke_command(String[] args) throws ToolException {
        if (args.length == 0) {
            OracleRuntime.exitSession(0);
        }
        String command = args[0];
        String[] cmdArgs = new String[args.length - 1];
        System.arraycopy(args, 1, cmdArgs, 0, args.length - 1);
        try {
            if (command.equals("exit")) {
                OracleRuntime.exitSession(0);
                return;
            }
            if (command.equals("help")) {
                try {
                    this.commandHelp(cmdArgs);
                    return;
                }
                catch (ToolException te) {
                    System.out.println(te.getMessage());
                    return;
                }
            }
            if (command.equals("version")) {
                this.version(cmdArgs);
                return;
            }
            if (command.equals("echo")) {
                for (int i = 1; i < args.length; ++i) {
                    System.out.print(args[i]);
                    System.out.print(' ');
                }
                System.out.println();
                return;
            }
            if (command.equals("whoami")) {
                System.out.println(Schema.currentSchema().toString());
                return;
            }
            Tool tool = this.get_tool(command);
            if (tool != null) {
                tool.invoke(cmdArgs);
            } else {
                System.out.println(args[0] + ": command not found");
            }
        }
        catch (Exception e) {
            System.out.println(e.getMessage());
        }
    }

    protected void initCommands() {
        this.tools.put("java", Java.class);
    }

    protected Tool get_tool(String command) throws ToolException {
        Object tool = this.tools.get(command);
        try {
            Class toolClass;
            if (tool == null) {
                return null;
            }
            if (tool instanceof String) {
                String toolName = (String)tool;
                int separatorIndex = toolName.indexOf(58);
                if (separatorIndex < 0) {
                    toolClass = Class.forName(toolName);
                } else {
                    String schemaName = toolName.substring(0, separatorIndex);
                    String className = toolName.substring(separatorIndex + 1);
                    toolClass = EnvironmentSpecific.classForNameAndSchema(className, schemaName);
                }
            } else {
                toolClass = (Class)tool;
            }
            return (Tool)toolClass.newInstance();
        }
        catch (InstantiationException e) {
            this.fail2("CANNOT_INSTANTIATE_TOOL", command, e.toString());
        }
        catch (ClassNotFoundException e) {
            this.fail1("CLASS_NOT_FOUND", (String)tool);
        }
        catch (IllegalAccessException e) {
            this.fail2("CANNOT_INSTANTIATE_TOOL", command, e.toString());
        }
        return null;
    }

    public void invoke() {
    }

    protected void parseArgs(String[] argv) throws ToolException {
    }

    public void commandHelp(String[] args) throws ToolException {
        if (args.length == 0 || args.length > 1) {
            System.out.println(this.msg("SHELL_COMMAND_HELP"));
        } else {
            this.invoke_command(new String[]{args[0], "-help"});
        }
    }

    public String description() throws ToolException {
        return this.msg("WELCOME_MESSAGE");
    }

    protected void description(String[] args) throws ToolException {
        if (args.length == 1) {
            System.out.println(this.description());
        } else {
            this.invoke_command(new String[]{args[1], "-description"});
        }
    }

    protected String getBundleName() {
        return "oracle.aurora.server.tools.shell.Message";
    }

    public String version() throws ToolException {
        return this.msg("oracle.aurora.server.tools.shell.ShellClient.version");
    }

    protected void version(String[] args) throws ToolException {
        if (args.length == 0) {
            System.out.println(this.version());
            return;
        }
        this.invoke_command(new String[]{args[0], "-version"});
    }
}

