/*
 * Decompiled with CFR 0.152.
 */
package oracle.aurora.server.tools.loadjava;

import java.io.OutputStream;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.sql.SQLException;
import java.text.DecimalFormat;
import oracle.aurora.server.tools.loadjava.ConnectionError;
import oracle.aurora.server.tools.loadjava.ToolsException;

class ToolLog {
    private PrintWriter writer;
    private boolean verbose;
    private boolean debug;
    private boolean addTime;
    private long startTime;
    private long lastTime;
    int errorCount;
    int warningCount;
    boolean connectionFailure;

    public ToolLog(PrintWriter out, boolean verbose, boolean debug) {
        this.writer = out;
        this.verbose = verbose;
        this.debug = debug;
    }

    public ToolLog(PrintStream out, boolean verbose, boolean debug) {
        this(new PrintWriter(out, true), verbose, debug);
    }

    public ToolLog(OutputStream out, boolean verbose, boolean debug) {
        this(new PrintWriter(out, true), verbose, debug);
    }

    public void setTime(boolean addTime) {
        this.addTime = addTime;
    }

    private void println(String msg) {
        if (this.addTime) {
            if (this.startTime == 0L) {
                this.startTime = System.currentTimeMillis();
            }
            long t = System.currentTimeMillis() - this.startTime;
            msg = "[" + (double)(t - this.lastTime) / 1000.0 + " sec, " + (double)t / 1000.0 + " sec] " + msg;
            this.lastTime = t;
        }
        this.writer.println(msg);
        this.writer.flush();
    }

    public void msg(String m) {
        if (this.verbose) {
            this.println(m);
        }
    }

    public void warn(String m) {
        this.println("Warning: " + m);
    }

    public void warn(Exception ex, String m) {
        this.err(ex, m, true);
    }

    public void err(String m) {
        if (this.checkCode(m, 29552)) {
            ++this.warningCount;
        } else {
            ++this.errorCount;
        }
        this.println(m);
    }

    public void err(Exception ex, String what) {
        this.err(ex, what, false);
    }

    public void err(Exception ex, String what, boolean warning) {
        if (ex instanceof SQLException) {
            SQLException sex = (SQLException)ex;
            if (this.checkCode(sex, 1013)) {
                throw new ConnectionError("interrupted by user");
            }
            if (this.checkCode(sex, 3113) || this.checkCode(sex, 3114) || sex.getErrorCode() == 0) {
                this.connectionFailure = true;
            } else if (this.checkCode(sex, 29552)) {
                warning = true;
            }
        }
        String tag = warning ? "Warning" : "Error";
        this.println(tag + " while " + what);
        if (ex instanceof SQLException && ((SQLException)ex).getErrorCode() != 0) {
            this.println("    " + ex.getMessage());
        } else {
            this.println("    Exception " + ex.toString());
        }
        if (this.debug) {
            Exception exForTrace = ex;
            if (ex instanceof ToolsException && ((ToolsException)ex).getChain() != null) {
                exForTrace = ((ToolsException)ex).getChain();
            }
            exForTrace.printStackTrace(this.writer);
        }
        if (!warning) {
            ++this.errorCount;
        } else {
            ++this.warningCount;
        }
        this.writer.flush();
    }

    public boolean checkCode(SQLException ex, int code) {
        int count;
        boolean result = false;
        boolean found = false;
        SQLException next = ex;
        for (count = 0; next != null && !found && count < 100; ++count) {
            found = ex.getErrorCode() == code || this.checkCode(ex.getMessage(), code);
            next = ex.getNextException();
        }
        if (count > 100) {
            System.out.println("loop in SQLException next chain");
            SQLException s = ex;
            for (int x = 0; x < 100 && s != null; s = s.getNextException(), ++x) {
                System.out.println("    " + s);
            }
        }
        return found;
    }

    public boolean checkCode(String msg, int code) {
        String pat = "ORA-" + new DecimalFormat("00000").format(code);
        boolean found = msg != null && msg.indexOf(pat) >= 0;
        return found;
    }

    public int getErrorCount() {
        return this.errorCount;
    }

    public int getWarningCount() {
        return this.warningCount;
    }

    public boolean getConnectionFailure() {
        return this.connectionFailure;
    }

    public void setConnectionFailure(boolean cf) {
        this.connectionFailure = cf;
    }
}

