/*
 * Decompiled with CFR 0.152.
 */
package oracle.aurora.server.tools.loadjava;

import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.UnsupportedEncodingException;
import java.util.Enumeration;
import oracle.aurora.sqljdecl.ParseException;
import oracle.aurora.sqljdecl.SqljDecl;
import oracle.aurora.sqljdecl.TokenMgrError;

class SourceFileReader {
    String fileName;
    Reader reader;
    SqljDecl scanner;

    SourceFileReader(String fileName, Reader reader) {
        this.fileName = fileName;
        this.reader = reader;
    }

    SourceFileReader(String fileName, InputStream in, String encoding) throws UnsupportedEncodingException {
        this(fileName, SourceFileReader.mkReader(in, encoding));
    }

    static Reader mkReader(InputStream in, String encoding) throws UnsupportedEncodingException {
        return encoding == null ? new InputStreamReader(in) : new InputStreamReader(in, encoding);
    }

    SqljDecl getScanner() throws ParseException, IOException {
        if (this.scanner == null) {
            String name = this.fileName;
            int x = name.indexOf(46);
            if (x > 0) {
                name = name.substring(0, x);
            }
            this.scanner = SqljDecl.run(name, this.reader);
        }
        return this.scanner;
    }

    String getFirstName() throws IOException, ParseException {
        try {
            SqljDecl scanner = this.getScanner();
            String name = scanner.getFirstName();
            return name;
        }
        catch (TokenMgrError ex) {
            throw new ParseException(ex.getMessage());
        }
    }

    Enumeration getNames() throws IOException, ParseException {
        try {
            SqljDecl scanner = this.getScanner();
            return scanner.getClassDecls();
        }
        catch (TokenMgrError ex) {
            throw new ParseException(ex.getMessage());
        }
    }

    public static void main(String[] argv) {
        try {
            String fileName = argv[0];
            SourceFileReader r = new SourceFileReader(fileName, new FileInputStream(fileName), null);
            System.out.println("getFirstName " + r.getFirstName());
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }
}

