/*
 * Decompiled with CFR 0.152.
 */
package oracle.aurora.server.tools.loadjava;

import java.io.IOException;
import java.io.InputStream;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Enumeration;
import oracle.aurora.server.tools.loadjava.ClientSchemaObject;
import oracle.aurora.server.tools.loadjava.ConnectionError;
import oracle.aurora.server.tools.loadjava.ErrorSchemaObject;
import oracle.aurora.server.tools.loadjava.JdbcOperations;
import oracle.aurora.server.tools.loadjava.LoadJavaConstants;
import oracle.aurora.server.tools.loadjava.LoadJavaLog;
import oracle.aurora.server.tools.loadjava.LoadJavaOptions;
import oracle.aurora.server.tools.loadjava.LoadJavaState;
import oracle.aurora.server.tools.loadjava.MkMsg;
import oracle.aurora.server.tools.loadjava.ServerSchemaObject;
import oracle.aurora.server.tools.loadjava.ToolsError;
import oracle.aurora.util.IOCopy;
import oracle.aurora.util.msg.Msg;
import oracle.sql.BLOB;

abstract class SchemaObject
implements LoadJavaConstants {
    private Msg mkMsg = MkMsg.mkMsg;
    private LoadJavaState state;
    private LoadJavaOptions originalOpts;
    private LoadJavaOptions privateOpts;
    private LoadJavaOptions opts;
    private String schemaName;
    protected int type;
    private byte[] bytes;
    private InputStream in;
    private static IOCopy ioCopy = new IOCopy();
    private String externalName;
    protected boolean createFailed;
    private boolean skippedCreate;
    private boolean would_replace = false;
    protected boolean known_not_missing = false;
    private static final String failureMsgInitializer = "unset";
    protected String failureMsg = "unset";
    protected String otherFailures;
    protected String jarname;
    protected String path;
    protected String fullJarname;
    protected boolean prependName;
    protected boolean nested;
    SchemaObject next;

    String getJarname() {
        return this.jarname;
    }

    SchemaObject(LoadJavaState state, LoadJavaOptions opts, int type, InputStream in, String externalName) {
        this.type = type;
        this.in = in;
        this.state = state;
        this.schemaName = opts.getLoadSchema();
        this.externalName = externalName;
        this.setOpts(opts);
    }

    abstract Enumeration allGrants();

    abstract boolean deleteMD5();

    abstract boolean updateMD5(boolean var1);

    abstract boolean create();

    abstract int status();

    abstract boolean useEbcdicShortening();

    abstract boolean resolve();

    abstract boolean drop();

    abstract boolean definer(boolean var1);

    abstract boolean resolver(String var1);

    abstract boolean revoke(String var1);

    abstract boolean grant(String var1);

    abstract boolean synonym();

    abstract boolean dropSynonym();

    abstract boolean invoke();

    abstract String getName();

    String getPerhapsJarQualifiedName() {
        String perhapsQualifiedName = this.getName();
        if (this.jarname != null) {
            perhapsQualifiedName = this.jarname + "///" + perhapsQualifiedName;
        }
        return perhapsQualifiedName;
    }

    boolean shortnameKnown() {
        return true;
    }

    void setShortname(String s) {
    }

    abstract String getShortname();

    abstract byte[] getOldMD5();

    abstract boolean genMissing();

    abstract boolean addPublish();

    abstract boolean isSysObj();

    boolean doCreate() {
        byte[] oldMD5;
        boolean result = true;
        if (!this.getOpts().getForce() && (oldMD5 = this.getOldMD5()) != null) {
            byte[] newMD5 = this.getNewMD5();
            if (newMD5 != null) {
                result = false;
                for (int i = 0; i < 16; ++i) {
                    if (newMD5[i] == oldMD5[i]) continue;
                    if (this.getOpts().getBoolean("-install") && this.isSysObj()) {
                        this.would_replace = true;
                        result = false;
                        break;
                    }
                    result = true;
                    break;
                }
            }
            if (!result) {
                this.known_not_missing = true;
            }
        }
        return result;
    }

    boolean process1() {
        boolean ok = false;
        try {
            if (this.type != 1002) {
                if (this.getOpts().getGenMissing()) {
                    this.genMissing();
                }
                if (this.getOpts().getString("-publish") != null) {
                    this.addPublish();
                }
                if (this.getOpts().getBoolean("-resolveonly")) {
                    if (this.getVerbose()) {
                        this.msg(this.mkMsg.m("skipping create: {0}", this.getName()));
                    }
                    this.skippedCreate = true;
                    ++this.getState().ld_skipped;
                } else if (this.doCreate()) {
                    String resolver = this.getOpts().getString("-resolver");
                    if (this.getVerbose()) {
                        if (resolver == null) {
                            this.msg(this.mkMsg.m("creating : {0}", this.toString()));
                        } else {
                            this.msg(this.mkMsg.m("creating : {0} with resolver {1}", this.toString(), resolver));
                        }
                    }
                    boolean bl = this.createFailed = !this.create();
                    if (!this.createFailed) {
                        ok = true;
                        this.known_not_missing = true;
                        switch (this.type) {
                            case 29: {
                                ++this.getState().ld_classes;
                                break;
                            }
                            case 28: {
                                ++this.getState().ld_sources;
                                break;
                            }
                            case 30: {
                                ++this.getState().ld_resources;
                            }
                        }
                    }
                    this.updateMD5(ok);
                    if (this.getOpts().getBoolean("-andresolve")) {
                        this.reportErrors();
                    }
                } else {
                    ok = true;
                    if (this.getVerbose() && !this.would_replace) {
                        this.msg(this.mkMsg.m("identical: {0}", this.getName()));
                    }
                    this.skippedCreate = true;
                    ++this.getState().ld_skipped;
                }
            } else {
                if (this.getVerbose()) {
                    this.msg(this.mkMsg.m("creating : {0}", this.toString()));
                }
                boolean bl = this.createFailed = !this.create();
                if (!this.createFailed) {
                    ok = true;
                    this.known_not_missing = true;
                    ++this.getState().ld_jar;
                }
            }
        }
        catch (SchemaObjectError nex) {
            this.err(nex, this.mkMsg.m("processing {0}", this.getExternalName()));
            this.createFailed = true;
            ++this.getState().errors;
        }
        catch (ConnectionError err) {
            ++this.getState().errors;
            throw err;
        }
        catch (RuntimeException rex) {
            ++this.getState().errors;
            this.err(rex, this.mkMsg.m("processing {0}", this.getExternalName()));
        }
        return ok;
    }

    void clearAllGrants() {
        Enumeration grantees = this.allGrants();
        if (grantees != null) {
            while (grantees.hasMoreElements()) {
                String grantee = (String)grantees.nextElement();
                this.revoke(grantee);
            }
        }
    }

    boolean process2() {
        if (this.type == 1002) {
            return true;
        }
        this.fixupOptionFile();
        String grantees = this.getOpts().getGrantees();
        boolean ok = true;
        try {
            if (!this.createFailed && !this.getOpts().getBoolean("-noaction")) {
                if (this.getOpts().getBoolean("-cleargrants")) {
                    this.clearAllGrants();
                }
                if (grantees != null) {
                    boolean grantOK;
                    if (this.getVerbose()) {
                        this.msg(this.mkMsg.m("granting : execute on {0} to {1}", this.toString(), grantees));
                    }
                    boolean bl = ok = (grantOK = this.grant(grantees)) && ok;
                    if (!grantOK) {
                        this.otherFailures = (this.otherFailures == null ? "" : this.otherFailures + ", ") + "grant";
                    }
                }
                if (this.getOpts().getBoolean("-resolve") || this.getOpts().getBoolean("-resolveonly")) {
                    int valid = this.status();
                    switch (valid) {
                        case 1: {
                            if (!this.getVerbose()) break;
                            this.msg(this.mkMsg.m("skipping : {0}", this.toString()));
                            break;
                        }
                        case 0: {
                            int errCount = 0;
                            this.getState().setVerifier(!this.getOpts().getBoolean("-noverify"));
                            if (!this.skippedCreate && !this.getOpts().getBoolean("-andresolve")) {
                                errCount = this.reportErrors();
                                boolean bl = ok = ok && errCount == 0;
                            }
                            if (ok) {
                                if (this.getVerbose()) {
                                    this.msg(this.mkMsg.m("resolving: {0}", this.toString()));
                                }
                                ok = this.resolve() && ok;
                                errCount = this.reportErrors();
                            }
                            if (errCount <= 0 || !this.getOpts().getBoolean("-stoponerror")) break;
                            this.reportAllErrors();
                            this.getState().setCancelled(this.mkMsg.m("errors resolving {0}", this.toString()));
                            ++this.getState().errors;
                        }
                    }
                }
                if (this.getOpts().getCreateSynonym() && !this.would_replace) {
                    boolean synOK = this.synonym();
                    boolean bl = ok = synOK && ok;
                    if (!synOK) {
                        this.otherFailures = (this.otherFailures == null ? "" : this.otherFailures + ", ") + "create synonym";
                        ++this.getState().errors;
                    }
                }
                if (this.getOpts().getBoolean("-invoke")) {
                    boolean invokeOK = this.invoke();
                    boolean bl = ok = invokeOK && ok;
                    if (!invokeOK) {
                        this.otherFailures = (this.otherFailures == null ? "" : this.otherFailures + ", ") + "invoke";
                    }
                }
            }
        }
        catch (ConnectionError cex) {
            ++this.getState().errors;
            throw cex;
        }
        catch (RuntimeException rex) {
            ++this.getState().errors;
            this.err(rex, this.mkMsg.m("processing {0}", this.toString()));
            ok = false;
        }
        return ok;
    }

    String getExternalName() {
        return this.externalName;
    }

    String getSchema() {
        return this.schemaName;
    }

    int getType() {
        return this.type;
    }

    final byte[] getBytes() {
        InputStream in;
        if (this.bytes == null && (in = this.getInputStream()) != null) {
            try {
                this.bytes = ioCopy.toBytes(in);
            }
            catch (IOException ioex) {
                this.getLog().err(ioex, this.mkMsg.m("processing {0}", this.getName()));
            }
        }
        return this.bytes;
    }

    final InputStream getInputStream() {
        InputStream iStream = this.in;
        if (iStream == null && this.bytes != null) {
            iStream = ioCopy.toInputStream(this.bytes, this.getExternalName());
        }
        this.in = null;
        return iStream;
    }

    InputStream getRepeatableInputStream() {
        InputStream result = null;
        byte[] bytes = this.getBytes();
        if (bytes != null) {
            result = ioCopy.toInputStream(bytes, this.getExternalName());
        }
        return result;
    }

    byte[] getNewMD5() {
        byte[] result;
        try {
            result = this.MD5OfStream(this.getRepeatableInputStream());
        }
        catch (IOException ioex) {
            this.err(ioex, this.mkMsg.m("computing MD5 of {0}", this.getName()));
            throw new ToolsError(ioex.toString());
        }
        return result;
    }

    void resetBytes() {
        if (this.type == 1002) {
            return;
        }
        this.bytes = null;
        if (this.in != null) {
            this.in = null;
        }
    }

    String getNameForMD5Table() {
        String name = this.getName();
        if (name.length() >= 700) {
            name = this.getShortname();
        }
        if (name == null) {
            throw new ToolsError("getNameForMD5 failed");
        }
        return name;
    }

    LoadJavaOptions getOptsForName(String name) {
        LoadJavaOptions opts = (LoadJavaOptions)this.originalOpts.getOptionsFor(name);
        if (this.privateOpts != null) {
            opts = (LoadJavaOptions)this.privateOpts.clone(opts);
        }
        return opts;
    }

    LoadJavaOptions getOpts() {
        if (this.opts == null) {
            this.opts = this.originalOpts;
            this.opts = (LoadJavaOptions)this.opts.getOptionsFor(this.getName());
        }
        return this.opts;
    }

    void setOpts(LoadJavaOptions newOpts) {
        this.originalOpts = newOpts;
        this.privateOpts = null;
        this.opts = null;
    }

    LoadJavaOptions getPrivateOpts() {
        if (this.privateOpts == null) {
            this.opts = this.privateOpts = new LoadJavaOptions(this.opts);
        }
        return this.opts;
    }

    void recalculateOpts() {
        LoadJavaOptions myOpts = (LoadJavaOptions)this.originalOpts.getOptionsFor(this.getName());
        this.opts = this.privateOpts != null ? (this.privateOpts = (LoadJavaOptions)this.privateOpts.clone(myOpts)) : myOpts;
    }

    void fixupOptionFile() {
        boolean doDefiner;
        LoadJavaOptions oldOpts = this.getOpts();
        this.recalculateOpts();
        LoadJavaOptions newOpts = this.getOpts();
        boolean resolveOnly = this.getOpts().getBoolean("-resolveonly");
        boolean oldDefiner = oldOpts.getDefiners();
        boolean newDefiner = newOpts.getDefiners();
        boolean bl = doDefiner = oldDefiner != newDefiner;
        if (doDefiner) {
            this.definer(newDefiner);
        }
        String oldResolver = oldOpts.getResolver();
        String newResolver = newOpts.getResolver();
        boolean doResolver = false;
        if (oldResolver != null && !oldResolver.equals(newResolver)) {
            doResolver = true;
        } else if (oldResolver == null && newResolver != null) {
            doResolver = true;
        }
        if (doResolver && newResolver != null) {
            this.resolver(newResolver);
        }
        boolean oldAndResolve = oldOpts.getBoolean("-andresolve");
        boolean newAndResolve = newOpts.getBoolean("-andresolve");
        if (newAndResolve && !oldAndResolve) {
            this.getPrivateOpts().set("-resolve", Boolean.TRUE);
            this.getPrivateOpts().set("-andresolve", Boolean.FALSE);
        }
        if (newOpts.getBoolean("-noaction")) {
            if (this.getVerbose()) {
                this.msg(this.mkMsg.m("dropping : {0} (it was created by mistake)", this.toString()));
            }
            this.drop();
        }
    }

    void set(String option) {
        this.getPrivateOpts().set(option);
    }

    void set(String option, Object value) {
        this.getOpts().set(option, value);
    }

    JdbcOperations getHelper() {
        return this.getJdbc();
    }

    boolean isWarnMessage(String msg) {
        return this.getLog().checkCode(msg, 29552);
    }

    boolean doUserErrorMessage(String msg) {
        return !this.getOpts().getBoolean("-nowarn") || !this.isWarnMessage(msg);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    int reportAllErrors() {
        String when = this.mkMsg.m("reporting all errors");
        this.err(this.mkMsg.m("all errors in error table:"));
        Connection conn = this.getConnection();
        int count = 0;
        Statement stmt = null;
        ResultSet rset = null;
        try {
            stmt = conn.createStatement();
            String schema = this.getSchema();
            String viewExpression = "user_errors";
            if (schema != null) {
                viewExpression = "all_errors where owner = '" + this.upperCaseUser(schema) + "'";
            }
            String prefix = "select nvl(longname, name), text from javasnm, ";
            rset = stmt.executeQuery("select nvl(longname, name), text from   (select name, text from " + viewExpression + "), javasnm" + "  where short(+)=name");
            while (rset.next()) {
                this.err("    " + rset.getString(1) + ": " + rset.getString(2));
                ++count;
            }
        }
        catch (SQLException e) {
            this.err(e, when);
        }
        finally {
            this.closeStatement(stmt, when);
        }
        return count;
    }

    int reportErrors() {
        Connection conn = this.getConnection();
        String name = this.getName();
        String when = this.mkMsg.m("retrieving errors for {0}", name);
        int count = 0;
        PreparedStatement stmt = null;
        ResultSet rset = null;
        try {
            boolean firstMsg;
            String schema = this.getSchema();
            if (schema == null) {
                stmt = this.getState().getReportErrorsStmt1();
            } else {
                stmt = this.getState().getReportErrorsStmt2();
                stmt.setString(2, this.upperCaseUser(schema));
            }
            stmt.setString(1, this.getShortname());
            rset = stmt.executeQuery();
            boolean bl = firstMsg = !this.getOpts().getBoolean("-compat817");
            while (rset.next()) {
                if (!this.doUserErrorMessage(rset.getString(1))) continue;
                if (firstMsg) {
                    firstMsg = false;
                    this.err(this.mkMsg.m("errors   : {0}", this.toString()));
                }
                this.err("    " + rset.getString(1));
                ++count;
            }
        }
        catch (SQLException e) {
            this.err(e, when);
        }
        return count;
    }

    String upperCaseUser(String username) {
        String r = username != null && username.length() > 0 && username.charAt(0) != '\"' ? username.toUpperCase() : username;
        return r;
    }

    Connection getConnection() {
        return this.state.getConnection();
    }

    LoadJavaLog getLog() {
        return this.state.getLog();
    }

    void msg(String msg) {
        this.getState().msg(msg);
    }

    void err(Exception ex, String when) {
        this.getState().err(ex, when);
    }

    void err(String msg) {
        this.getState().err(msg);
    }

    byte[] MD5OfStream(InputStream in) throws IOException {
        try {
            MessageDigest md = MessageDigest.getInstance("MD5");
            byte[] buf = new byte[4000];
            int count = in.read(buf);
            while (count > 0) {
                md.update(buf, 0, count);
                count = in.read(buf);
            }
            return md.digest();
        }
        catch (NoSuchAlgorithmException ex) {
            throw new IOException("got " + ex + " while attempting to compute MD5 ");
        }
    }

    String lobTable(String schema) {
        return this.getOpts().lobTable(schema);
    }

    String doubleQuote(String w) {
        return "\"" + w + "\"";
    }

    String singleQuote(String w) {
        return "'" + w + "'";
    }

    String usingClause() {
        return "using blob LOB from " + this.lobTable(this.getSchema()) + " where name ='" + this.state.NameForLobTable + "'";
    }

    boolean load() {
        String what = this.mkMsg.m("loading {0}", this.toString());
        boolean ok = false;
        try {
            this.msg("loading  : " + this);
            BLOB blob = this.state.getLoadLOB(this.getSchema());
            if (blob != null) {
                byte[] bytes = this.getBytes();
                if (bytes != null) {
                    if (this.type == 29 && bytes.length == 0) {
                        this.err("zero length class file");
                        return false;
                    }
                    blob.putBytes(1L, bytes, bytes.length);
                }
                this.getConnection().commit();
                ok = true;
            }
        }
        catch (SQLException e) {
            this.err(e, what);
        }
        return ok;
    }

    String failure() {
        if (this.failureMsg == failureMsgInitializer) {
            this.failureMsg = null;
            if (this.createFailed) {
                this.failureMsg = "creation (createFailed)";
            } else if ((this.getOpts().getBoolean("-resolve") || this.getOpts().getBoolean("-resolveonly") || this.getOpts().getBoolean("-andresolve")) && !this.getOpts().getBoolean("-unresolvedok")) {
                int s = this.status();
                if (s == 0) {
                    this.failureMsg = "resolution";
                } else if (s == 3 && !this.getOpts().getBoolean("-noaction")) {
                    this.failureMsg = "creation";
                }
            } else if (!this.known_not_missing && !this.getOpts().getBoolean("-noaction") && this.status() == 3) {
                this.failureMsg = "creation";
            }
            if (this.failureMsg == null) {
                this.failureMsg = this.otherFailures;
            }
        }
        return this.failureMsg;
    }

    boolean executeDDL(String ddl, String what) {
        return this.getJdbc().executeDDL(ddl, what);
    }

    void closeStatement(Statement stmt, String what) {
        this.getJdbc().closeStatement(stmt, what);
    }

    public void finalize() {
        this.resetBytes();
    }

    public static String typeToString(int type) {
        String kind;
        switch (type) {
            case 29: {
                kind = "class";
                break;
            }
            case 28: {
                kind = "source";
                break;
            }
            case 30: {
                kind = "resource";
                break;
            }
            case 1001: {
                kind = "deployment file";
                break;
            }
            case 1002: {
                kind = "jar";
                break;
            }
            default: {
                kind = "";
            }
        }
        return kind;
    }

    public String toString() {
        String name;
        String kind = SchemaObject.typeToString(this.getType());
        try {
            name = this.getName();
            if (this.getSchema() != null) {
                name = this.getSchema() + "." + this.getName();
            }
        }
        catch (NameError ex) {
            name = "contained in " + this.getExternalName();
        }
        return kind + " " + name;
    }

    abstract void endLoading();

    abstract void resumeLoading();

    void setPrepend(boolean prependValue) {
        this.prependName = prependValue;
    }

    void setNested(boolean nestedValue) {
        this.nested = nestedValue;
    }

    void setJarname(String jn, boolean prepend) {
        this.jarname = prepend ? jn : null;
    }

    void noteContainedObject(SchemaObject sObject) {
        sObject.setJarname(this.fullJarname, this.prependName);
    }

    void doneLoading() {
        this.endLoading();
        this.resetBytes();
    }

    protected boolean checkStartLoadingStatus(int status, String schema, String msg) {
        switch (status) {
            case 0: {
                return true;
            }
            case 2: {
                this.err(this.mkMsg.m("creating {0},\ninvalid schema {1}", this.toString(), schema));
                break;
            }
            case 4: {
                this.err(this.mkMsg.m("creating {0},\n{1}", this.toString(), msg));
                break;
            }
            case 3: {
                this.err(this.mkMsg.m("creating {0},\njar loading already in progress", this.toString()));
                break;
            }
            default: {
                this.err(this.mkMsg.m("creating {0},\nunknown status {1}", this.toString(), (long)status));
            }
        }
        return false;
    }

    protected void checkEndLoadingStatus(int status, String msg) {
        switch (status) {
            case 0: {
                break;
            }
            case 4: {
                this.err(this.mkMsg.m("creating {0},\n{1}", this.toString(), msg));
                break;
            }
            case 5: {
                this.err(this.mkMsg.m("creating {0},\njar loading not in progress", this.toString()));
                break;
            }
            default: {
                this.err(this.mkMsg.m("creating {0},\nunknown status {1}", this.toString(), (long)status));
            }
        }
    }

    protected void checkResumeLoadingStatus(int status, String schema, String msg) {
        switch (status) {
            case 0: {
                break;
            }
            case 2: {
                this.err(this.mkMsg.m("creating {0},\ninvalid schema {1}", this.toString(), schema));
                break;
            }
            case 4: {
                this.err(this.mkMsg.m("creating {0},\n{1}", this.toString(), msg));
                break;
            }
            case 6: {
                this.err(this.mkMsg.m("creating {0},\njar not found after recursion", this.toString()));
                break;
            }
            default: {
                this.err(this.mkMsg.m("creating {0},\nunknown status {1}", this.toString(), (long)status));
            }
        }
    }

    protected boolean checkDropStatus(int status, String msg) {
        switch (status) {
            case 0: {
                return true;
            }
            case 4: {
                this.err(this.mkMsg.m("dropping {0},\n{1}", this.toString(), msg));
                break;
            }
            case 6: {
                this.err(this.mkMsg.m("dropping {0},\nunknown jar", this.toString()));
                break;
            }
            default: {
                this.err(this.mkMsg.m("dropping {0},\nunknown status {1}", this.toString(), (long)status));
            }
        }
        return false;
    }

    protected int checkStatusStatus(int status, String msg) {
        switch (status) {
            case 0: {
                return 1;
            }
            case 4: {
                this.err(this.mkMsg.m("getting status of {0},\n{1}", this.toString(), msg));
                break;
            }
            case 6: {
                if (!this.getOpts().getBoolean("-jarasdbobjects")) break;
                this.err(this.mkMsg.m("getting status of {0},\nunknown jar", this.toString()));
                break;
            }
            default: {
                this.err(this.mkMsg.m("getting status of {0},\nunknown status {1}", this.toString(), (long)status));
            }
        }
        return 3;
    }

    LoadJavaState getState() {
        return this.state;
    }

    JdbcOperations getJdbc() {
        return this.state.getJdbc();
    }

    boolean getVerbose() {
        return this.state.getLog().getOpts().getVerbose();
    }

    protected static SchemaObject mkError(LoadJavaState state, LoadJavaOptions opts, String externalName, String msg) {
        return new ErrorSchemaObject(state, opts, externalName, msg);
    }

    protected static SchemaObject mkClass(LoadJavaState state, LoadJavaOptions opts, InputStream in, String externalName) {
        if (state.getLoc() == 0 || opts.getBoolean("-noserverside")) {
            return new ClientSchemaObject(state, opts, 29, in, externalName);
        }
        return new ServerSchemaObject(state, opts, 29, in, externalName);
    }

    protected static SchemaObject mkResource(LoadJavaState state, LoadJavaOptions opts, InputStream in, String externalName) {
        if (state.getLoc() == 0 || opts.getBoolean("-noserverside")) {
            return new ClientSchemaObject(state, opts, 30, in, externalName);
        }
        return new ServerSchemaObject(state, opts, 30, in, externalName);
    }

    protected static SchemaObject mkSource(LoadJavaState state, LoadJavaOptions opts, InputStream in, String externalName) {
        if (state.getLoc() == 0 || opts.getBoolean("-noserverside")) {
            return new ClientSchemaObject(state, opts, 28, in, externalName);
        }
        return new ServerSchemaObject(state, opts, 28, in, externalName);
    }

    protected static SchemaObject mkDeploy(LoadJavaState state, LoadJavaOptions opts, InputStream in, String externalName) {
        if (state.getLoc() == 0 || opts.getBoolean("-noserverside")) {
            return new ClientSchemaObject(state, opts, 1001, in, externalName);
        }
        return new ServerSchemaObject(state, opts, 1001, in, externalName);
    }

    protected static SchemaObject mkJar(LoadJavaState state, LoadJavaOptions opts, InputStream in, String externalName) {
        if (state.getLoc() == 0 || opts.getBoolean("-noserverside")) {
            return new ClientSchemaObject(state, opts, 1002, in, externalName);
        }
        return new ServerSchemaObject(state, opts, 1002, in, externalName);
    }

    protected static SchemaObject mk(int type, LoadJavaState state, LoadJavaOptions opts, InputStream in, String externalName) {
        switch (type) {
            case 29: {
                return SchemaObject.mkClass(state, opts, in, externalName);
            }
            case 30: {
                return SchemaObject.mkResource(state, opts, in, externalName);
            }
            case 28: {
                return SchemaObject.mkSource(state, opts, in, externalName);
            }
            case 1002: {
                return SchemaObject.mkJar(state, opts, in, externalName);
            }
            case 1001: {
                return SchemaObject.mkDeploy(state, opts, in, externalName);
            }
        }
        return null;
    }

    static class NameError
    extends SchemaObjectError {
        NameError(String msg, Exception ex, SchemaObject object) {
            super(msg, ex, object);
        }
    }

    static class SchemaObjectError
    extends RuntimeException {
        SchemaObject object;
        Exception ex;

        SchemaObjectError(String msg, Exception ex, SchemaObject object) {
            super(msg);
            this.ex = ex;
            this.object = object;
        }
    }
}

