/*
 * Decompiled with CFR 0.152.
 */
package oracle.aurora.server.tools.loadjava;

import java.io.IOException;
import java.io.InputStream;
import java.util.Enumeration;
import java.util.Vector;
import oracle.aurora.server.tools.loadjava.GenMissing;
import oracle.aurora.server.tools.loadjava.JdbcOperations;
import oracle.aurora.server.tools.loadjava.LoadJavaState;
import oracle.aurora.server.tools.loadjava.MkMsg;
import oracle.aurora.server.tools.loadjava.SchemaObject;
import oracle.aurora.server.tools.loadjava.SourceFileReader;
import oracle.aurora.sqljdecl.ParseException;
import oracle.aurora.util.msg.Msg;

class CommonSourceObject {
    private Msg mkMsg = MkMsg.mkMsg;
    private LoadJavaState state;
    Vector dependentNames;
    Vector dependentClasses;
    SchemaObject sourceObject;
    boolean noNameReported;

    CommonSourceObject(SchemaObject sourceObject) {
        this.state = sourceObject.getState();
        this.sourceObject = sourceObject;
    }

    String getSourceName(String externalName, InputStream in, String encoding) {
        String name = externalName;
        if (in != null) {
            try {
                SourceFileReader r = new SourceFileReader(externalName, in, encoding);
                if (r.getFirstName() != null) {
                    name = r.getFirstName();
                }
                this.dependentNames = new Vector();
                Enumeration dnames = r.getNames();
                while (dnames.hasMoreElements()) {
                    this.dependentNames.addElement(dnames.nextElement());
                }
            }
            catch (IOException ex) {
                String msg = this.mkMsg.m("parsing to determine name of {0}", externalName);
                throw new SchemaObject.NameError(msg, ex, this.sourceObject);
            }
            catch (ParseException ex) {
                if (this.sourceObject.getOpts().getBoolean("-compat817")) {
                    if (this.noNameReported) {
                        this.getState().err("Exception " + ex);
                    }
                    this.noNameReported = true;
                }
                String msg = this.mkMsg.m("parsing to determine name of {0}", externalName);
                throw new SchemaObject.NameError(msg, ex, this.sourceObject);
            }
        }
        return name;
    }

    public boolean synonym() {
        Vector dependents = this.getDependentClasses();
        Enumeration classes = dependents.elements();
        boolean ok = true;
        while (classes.hasMoreElements()) {
            SchemaObject classObject = (SchemaObject)classes.nextElement();
            if (classObject.synonym()) continue;
            ok = false;
        }
        return ok;
    }

    Vector getDependentNames() {
        this.sourceObject.getName();
        if (this.dependentNames == null) {
            this.dependentNames = new Vector();
        }
        return this.dependentNames;
    }

    Vector getDependentClasses() {
        if (this.dependentClasses == null) {
            String jarname = this.sourceObject.getJarname();
            this.dependentClasses = new Vector();
            Enumeration classNames = this.getDependentNames().elements();
            while (classNames.hasMoreElements()) {
                String className = (String)classNames.nextElement();
                SchemaObject classObject = SchemaObject.mk(29, this.sourceObject.getState(), this.sourceObject.getOpts(), null, className);
                if (jarname != null) {
                    classObject.setJarname(jarname, true);
                }
                this.dependentClasses.addElement(classObject);
            }
        }
        return this.dependentClasses;
    }

    boolean genMissing() {
        String msg = this.mkMsg.m("classes not generated for references from source");
        this.getState().warn(msg);
        GenMissing genMissing = this.getState().getGenMissing();
        Enumeration names = this.getDependentClasses().elements();
        while (names.hasMoreElements()) {
            String name = ((SchemaObject)names.nextElement()).getName();
            genMissing.noteExists(name);
        }
        return true;
    }

    boolean addPublish() {
        String msg = this.mkMsg.m("PL/SQL wrappers not generated for methods in source");
        this.getState().warn(msg);
        return true;
    }

    public boolean depend_revoke(String grantee) {
        boolean ok = true;
        Enumeration dependents = this.getDependentClasses().elements();
        while (dependents.hasMoreElements()) {
            SchemaObject dependent = (SchemaObject)dependents.nextElement();
            ok = dependent.revoke(grantee) && ok;
        }
        return ok;
    }

    LoadJavaState getState() {
        return this.state;
    }

    JdbcOperations getJdbc() {
        return this.state.getJdbc();
    }
}

