/*
 * Decompiled with CFR 0.152.
 */
package oracle.aurora.rdbms.security;

import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Iterator;
import java.util.NoSuchElementException;
import oracle.aurora.rdbms.security.PolicyTableQuery;
import oracle.aurora.rdbms.security.PolicyTableRow;

class PolicyTableRows
implements Iterator {
    PolicyTableQuery query;
    PreparedStatement statement;
    String statementString;
    ResultSet resultSet;
    boolean atRow;

    PolicyTableRows(PolicyTableQuery query, PreparedStatement statement, String statementString) {
        this.query = query;
        this.statement = statement;
        this.statementString = statementString;
        try {
            this.resultSet = Exec.query(statement);
        }
        catch (SQLException ex) {
            query.table.noteError(ex);
            throw new Error("policy table query failed", ex);
        }
        this.atRow = false;
    }

    public boolean hasNext() {
        try {
            if (!this.atRow && this.resultSet != null) {
                if (this.resultSet.next()) {
                    this.atRow = true;
                } else {
                    this.finalize();
                }
            }
        }
        catch (SQLException ex) {
            this.finalize();
            this.query.table.noteError(ex);
            throw new Error("resultSet next() failed", ex);
        }
        return this.resultSet != null;
    }

    PolicyTableRow nextRow() throws NoSuchElementException {
        if (!this.atRow) {
            throw new NoSuchElementException();
        }
        this.atRow = false;
        PolicyTableRow r = new PolicyTableRow(this.query.table, this.resultSet);
        return r;
    }

    public Object next() {
        return this.nextRow();
    }

    public void remove() {
        throw new UnsupportedOperationException();
    }

    void close() {
        this.finalize();
    }

    public void finalize() {
        if (this.resultSet != null) {
            try {
                this.resultSet.close();
                this.statement.close();
            }
            catch (SQLException ex) {
                // empty catch block
            }
            this.resultSet = null;
        }
        if (this.statement != null) {
            try {
                this.statement.close();
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
            this.statement = null;
        }
        this.atRow = false;
    }

    private static class Exec {
        private Exec() {
        }

        static ResultSet query(PreparedStatement statement) throws SQLException {
            return statement.executeQuery();
        }
    }
}

