/*
 * Decompiled with CFR 0.152.
 */
package oracle.aurora.rdbms;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.Writer;
import oracle.aurora.compiler.Destination;
import oracle.aurora.compiler.ExternalEntity;
import oracle.aurora.compiler.QName;
import sun.tools.java.ClassLocation;
import sun.tools.java.ClassLocationDestination;
import sun.tools.java.ClassLocator;
import sun.tools.java.ExternalLocation;
import sun.tools.java.LocatorInterface;
import sun.tools.java.OracleClassLocation;
import sun.tools.java.OracleClassLocator;
import sun.tools.java.Output;
import sun.tools.javac.OracleCompilerErrorOutput;

class OracleLocatorInterface
extends LocatorInterface {
    boolean ok = true;
    OracleCompilerErrorOutput errorOutput = new OracleCompilerErrorOutput();
    PrintWriter writer;
    OracleClassLocator locator;
    boolean closed = false;

    OracleLocatorInterface() {
        OutputStreamWriter w;
        try {
            w = new OutputStreamWriter((OutputStream)this.errorOutput, "UTF8");
        }
        catch (IOException ex) {
            w = new OutputStreamWriter((OutputStream)this.errorOutput);
        }
        this.writer = new PrintWriter((Writer)w, true);
        Output output = new Output(){

            public void output(String msg) {
                OracleLocatorInterface.this.writer.println(msg);
            }
        };
        this.locator = new OracleClassLocator(output);
        this.setLocator((ClassLocator)this.locator);
        this.setOut(this.writer);
    }

    public void setOk(boolean ok) {
        this.ok = ok;
    }

    public void close() {
        if (!this.closed) {
            super.close();
            this.errorOutput.terminate(this.ok);
        }
        this.closed = true;
    }

    private OracleClassLocation toOracleLocation(ExternalEntity e) {
        ClassLocation location = LocatorInterface.toLocation((ExternalEntity)e);
        if (location instanceof OracleClassLocation) {
            return (OracleClassLocation)location;
        }
        return null;
    }

    public Destination getDestination(ExternalEntity source, QName what, int kind) throws FileNotFoundException {
        ClassLocation destLocation;
        OracleClassLocation sourceLocation = this.toOracleLocation(source);
        Destination d = super.getDestination(source, what, kind);
        if (d instanceof ClassLocationDestination && (destLocation = ((ClassLocationDestination)d).getLocation()) instanceof OracleClassLocation) {
            OracleClassLocation oracleDestLocation = (OracleClassLocation)destLocation;
            oracleDestLocation.intern();
            oracleDestLocation.setSource(sourceLocation);
            if (sourceLocation == null) {
                throw new FileNotFoundException(source + "is not an OracleClassLocation");
            }
        }
        return d;
    }

    public ExternalEntity getTopLevelSource(String name) {
        ClassLocation location = this.locator.makeSourceClassLocation(name);
        ExternalLocation entity = new ExternalLocation(location, 0, new QName(name));
        return entity;
    }
}

