/*
 * Decompiled with CFR 0.152.
 */
package oracle.aurora.rdbms;

import java.lang.management.ManagementFactory;
import java.lang.management.ManagementPermission;
import java.security.AccessController;
import java.security.Permission;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import javax.management.InstanceAlreadyExistsException;
import javax.management.InstanceNotFoundException;
import javax.management.MBeanRegistrationException;
import javax.management.MBeanServer;
import javax.management.MalformedObjectNameException;
import javax.management.NotCompliantMBeanException;
import javax.management.ObjectInstance;
import javax.management.ObjectName;
import javax.management.RuntimeOperationsException;
import oracle.aurora.rdbms.OracleRuntimeMXBImpl;
import oracle.aurora.rdbms.OracleRuntimeMXBean;

class MXBeanFactory {
    private static OracleRuntimeMXBImpl oracleRuntimeMXBImpl = null;
    private static Permission monitorPermission = new ManagementPermission("monitor");
    private static Permission controlPermission = new ManagementPermission("control");

    private MXBeanFactory() {
    }

    public static synchronized OracleRuntimeMXBean getOracleRuntimeMXBean() {
        if (oracleRuntimeMXBImpl == null) {
            oracleRuntimeMXBImpl = new OracleRuntimeMXBImpl();
        }
        return oracleRuntimeMXBImpl;
    }

    static void checkAccess(Permission p) throws SecurityException {
        SecurityManager sm = System.getSecurityManager();
        if (sm != null) {
            sm.checkPermission(p);
        }
    }

    static void checkMonitorAccess() throws SecurityException {
        MXBeanFactory.checkAccess(monitorPermission);
    }

    static void checkControlAccess() throws SecurityException {
        MXBeanFactory.checkAccess(controlPermission);
    }

    private static void addMBean(MBeanServer mbs, Object mbean, String mbeanName) {
        MXBeanFactory.addMBean(mbs, mbean, mbeanName, false);
    }

    private static void addMBean(MBeanServer mbs, Object mbean, String mbeanName, boolean ignoreConflicts) {
        try {
            final ObjectName objName = new ObjectName(mbeanName);
            final MBeanServer mbs0 = mbs;
            final Object mbean0 = mbean;
            final boolean ignore = ignoreConflicts;
            AccessController.doPrivileged(new PrivilegedExceptionAction(){

                public Object run() throws InstanceAlreadyExistsException, MBeanRegistrationException, NotCompliantMBeanException {
                    try {
                        ObjectInstance o = mbs0.registerMBean(mbean0, objName);
                        return null;
                    }
                    catch (InstanceAlreadyExistsException e) {
                        if (!ignore) {
                            throw e;
                        }
                        return null;
                    }
                }
            });
        }
        catch (PrivilegedActionException e) {
            throw new Error("got error" + e);
        }
        catch (MalformedObjectNameException e) {
            throw new Error("got error" + e);
        }
    }

    public static MBeanServer createOracleMXBeans() {
        MBeanServer mbs = ManagementFactory.getPlatformMBeanServer();
        MXBeanFactory.addMBean(mbs, MXBeanFactory.getOracleRuntimeMXBean(), "oracle.jvm:type=OracleRuntime", true);
        return mbs;
    }

    private static void unregisterMBean(MBeanServer mbs, String mbeanName) {
        try {
            final ObjectName objName = new ObjectName(mbeanName);
            final MBeanServer mbs0 = mbs;
            AccessController.doPrivileged(new PrivilegedExceptionAction(){

                public Object run() throws MBeanRegistrationException, RuntimeOperationsException {
                    try {
                        mbs0.unregisterMBean(objName);
                    }
                    catch (InstanceNotFoundException instanceNotFoundException) {
                        // empty catch block
                    }
                    return null;
                }
            });
        }
        catch (PrivilegedActionException e) {
            throw new Error("got error" + e);
        }
        catch (MalformedObjectNameException e) {
            throw new Error("got error" + e);
        }
    }
}

