/*
 * Decompiled with CFR 0.152.
 */
package oracle.aurora.notinserver;

import java.io.File;
import oracle.aurora.compiler.ClassFinder;
import oracle.aurora.compiler.DontKnowException;
import oracle.aurora.compiler.ExternalEntity;
import oracle.aurora.compiler.FinderFactory;
import oracle.aurora.compiler.QName;
import oracle.aurora.notinserver.ExternalClassFile;
import sun.tools.java.ClassFile;
import sun.tools.java.ClassPath;

class FileFinder
implements FinderFactory,
ClassFinder {
    ClassPath classPath;

    FileFinder(ClassPath classPath) {
        this.classPath = classPath;
    }

    public ClassFinder finder(ExternalEntity source) {
        return this;
    }

    public ExternalEntity find(QName className) {
        ClassFile object;
        ClassFile source = null;
        if (!className.isInner()) {
            source = this.findClassFile(className, 0);
        }
        int use = (object = this.findClassFile(className, 1)) == null ? 0 : (source == null ? 1 : (source.lastModified() >= object.lastModified() ? 0 : 1));
        ExternalEntity result = null;
        if (use == 0 && source != null) {
            result = this.makeExternal(source, className, use);
        } else if (use == 1 && object != null) {
            result = this.makeExternal(object, className, use);
        }
        return result;
    }

    public ExternalEntity find(QName className, int kind) {
        ClassFile file = this.findClassFile(className, kind);
        return this.makeExternal(file, className, kind);
    }

    private ExternalEntity makeExternal(ClassFile file, QName name, int kind) {
        if (file == null) {
            return null;
        }
        return new ExternalClassFile(file, name, kind);
    }

    private ClassFile findClassFile(QName className, int kind) {
        ClassFile result = this.classPath.getFile(this.makeFileName(className, kind));
        return result;
    }

    private String makeFileName(QName className, int kind) {
        String packagePart = className.getPackagePart();
        String classPart = "";
        String suffix = "";
        if (kind == 0) {
            suffix = ".java";
            classPart = className.getOutermost();
        } else if (kind == 1) {
            suffix = ".class";
            classPart = className.getFlatName();
        }
        if (!packagePart.equals("")) {
            packagePart = packagePart.replace('.', File.separatorChar) + File.separatorChar;
        }
        String fileName = packagePart + classPart + suffix;
        return fileName;
    }

    public boolean packageExists(String packageName) throws DontKnowException {
        throw new DontKnowException("FileFinder.packageExists(" + packageName + ")");
    }

    public String[] getAllClasses(String packageName, int kind) throws DontKnowException {
        throw new DontKnowException("FileFinder.getAllClasses(" + packageName + ", " + kind + ")");
    }

    public String[] getAllPackages(String packageName) throws DontKnowException {
        throw new DontKnowException("FileFinder.getAllPackages(" + packageName + ")");
    }

    public void close() {
    }

    public String toString() {
        return this.classPath.toString();
    }

    public boolean isPotentialSource(ExternalEntity source, QName className) {
        return true;
    }
}

