/*
 * Decompiled with CFR 0.152.
 */
package oracle.aurora.compiler;

import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import oracle.aurora.compiler.ExternalEntityKinds;
import oracle.aurora.compiler.QName;

public abstract class ExternalEntity
implements ExternalEntityKinds {
    protected int kind;

    protected ExternalEntity(int kind) {
        this.kind = kind;
    }

    public boolean isKind(int category) {
        return this.kind == category;
    }

    public Reader getReader() throws IOException {
        InputStreamReader r = null;
        InputStream s = this.getStream();
        String encoding = this.getEncoding();
        if (s != null && encoding != null) {
            r = new InputStreamReader(s, encoding);
        } else if (s != null) {
            r = new InputStreamReader(s);
        }
        return r;
    }

    public abstract InputStream getStream() throws IOException;

    public String getEncoding() {
        return null;
    }

    public abstract QName getQualifiedName();

    public String getPath() {
        return this.getClass().toString() + " for " + this.getQualifiedName();
    }

    public String getNameForClassFile() {
        QName qname = this.getQualifiedName();
        return qname.getName().replace('.', '/');
    }

    public abstract boolean equals(Object var1);

    public abstract int hashCode();

    public void setPackage(String pkg) {
    }

    public Object getPackageDomain() {
        return null;
    }

    public static interface Kinds
    extends ExternalEntityKinds {
    }
}

