/*
 * Decompiled with CFR 0.152.
 */
package oracle.aurora.compiler;

import java.io.PrintWriter;
import java.util.Enumeration;
import java.util.Hashtable;
import oracle.aurora.compiler.Sorter;
import oracle.aurora.compiler.TreeWalker;

public class DbTimer
implements TreeWalker.TreeNode {
    DbTimer parent;
    Hashtable children;
    String category;
    String id;
    boolean active = false;
    DbTimer activeChild;
    long start = 0L;
    long tThisTimer;
    long tChildren;
    long tEnterThisTimer;
    long tEnterChildren;
    long tUnreported;
    int enterCount = 0;
    Enumeration emptyEnum = new TreeWalker(null);

    public DbTimer(String category) {
        this.category = category == null ? "top-level" : category;
        this.makeActive(null);
    }

    public DbTimer() {
        this("top-level");
    }

    private DbTimer(String category, DbTimer parent) {
        this.parent = parent;
        this.category = category;
        this.id = null;
    }

    public DbTimer getChild(String category) {
        DbTimer child;
        if (category == null) {
            category = "unknown";
        }
        if (this.children == null) {
            this.children = new Hashtable(11);
        }
        if ((child = (DbTimer)this.children.get(category)) == null) {
            child = new DbTimer(category, this);
            this.children.put(category, child);
        }
        return child;
    }

    public Enumeration getChildren() {
        if (this.children == null) {
            return this.emptyEnum;
        }
        return this.children.elements();
    }

    public Enumeration getAll() {
        return new TreeWalker(this);
    }

    public DbTimer getParent() {
        return this.parent == null ? this : this.parent;
    }

    public boolean isRoot() {
        return this.parent == null;
    }

    public DbTimer enter(String category, String id) {
        this.id = id;
        DbTimer child = this.getChild(category);
        this.stop();
        this.activeChild = child;
        this.activeChild.makeActive(id);
        return child;
    }

    private void makeActive(String id) {
        this.accumulate();
        this.id = id;
        this.tEnterThisTimer = this.tThisTimer;
        this.tEnterChildren = this.tChildren;
        this.activeChild = null;
        this.start();
        ++this.enterCount;
    }

    public String getId() {
        return this.id;
    }

    public String getCategory() {
        return this.category;
    }

    public long getTime() {
        this.accumulate();
        return this.tThisTimer + this.tChildren;
    }

    public long getChildrenTime() {
        this.accumulate();
        return this.tChildren;
    }

    public long getCurrentTime() {
        this.accumulate();
        return this.tThisTimer - this.tEnterThisTimer + (this.tChildren - this.tEnterChildren);
    }

    public long getCurrentChildrenTime() {
        this.accumulate();
        return this.tThisTimer - this.tEnterThisTimer + (this.tChildren - this.tEnterChildren);
    }

    public DbTimer leave() {
        this.stop();
        this.accumulate();
        this.report();
        this.activeChild = null;
        DbTimer next = this.parent;
        if (next == null) {
            next = this;
        }
        next.start();
        return next;
    }

    void accumulate() {
        if (this.active) {
            long now = System.currentTimeMillis();
            long current = now - this.start;
            this.tThisTimer += current;
            this.tUnreported += current;
            this.start = now;
        }
    }

    void stop() {
        this.accumulate();
        this.active = false;
    }

    void start() {
        if (!this.active) {
            this.start = System.currentTimeMillis();
            this.active = true;
        }
    }

    void report() {
        if (this.activeChild != null) {
            this.activeChild.report();
        }
        if (this.parent != null) {
            this.parent.tChildren += this.tUnreported;
            this.parent.tUnreported += this.tUnreported;
            this.tUnreported = 0L;
        }
    }

    void printLine(PrintWriter writer, int indent, String category, int count, long tThis, long tChildren) {
        for (int c = 0; c < indent; ++c) {
            writer.print("  ");
        }
        writer.print(category);
        writer.print(": ");
        writer.print(count);
        writer.print(" times, ");
        writer.print(tThis + tChildren);
        writer.print("/");
        writer.print(tThis);
        writer.print(" msec.");
        writer.println();
    }

    void printTree(PrintWriter writer, int indent) {
        this.report();
        this.accumulate();
        Enumeration c = this.getChildren();
        this.printLine(writer, indent, this.category, this.enterCount, this.tThisTimer, this.tChildren);
        while (c.hasMoreElements()) {
            ((DbTimer)c.nextElement()).printTree(writer, indent + 1);
        }
    }

    void printFlat(PrintWriter writer) {
        final Hashtable<String, Entry> flat = new Hashtable<String, Entry>(111);
        Enumeration timers = this.getAll();
        while (timers.hasMoreElements()) {
            DbTimer timer = (DbTimer)timers.nextElement();
            String category = timer.getCategory();
            Entry entry = (Entry)flat.get(category);
            if (entry == null) {
                entry = new Entry();
                flat.put(category, entry);
            }
            entry.tThis += timer.tThisTimer;
            entry.tChild += timer.tChildren;
            entry.count += timer.enterCount;
        }
        Sorter.Comparer comparer = new Sorter.Comparer(){

            public boolean lessThan(Object lhs, Object rhs) {
                Entry lhsEntry = (Entry)flat.get((String)lhs);
                Entry rhsEntry = (Entry)flat.get((String)rhs);
                boolean result = lhsEntry.tThis + lhsEntry.tChild > rhsEntry.tThis + rhsEntry.tChild;
                return result;
            }
        };
        Sorter sorter = new Sorter(comparer);
        Enumeration keys = sorter.sort(flat.keys());
        while (keys.hasMoreElements()) {
            String category = (String)keys.nextElement();
            Entry entry = (Entry)flat.get(category);
            this.printLine(writer, 0, category, entry.count, entry.tThis, entry.tChild);
        }
    }

    public void print(PrintWriter writer) {
        writer.println("Tree rooted at " + this.category);
        writer.println("Times are printed as (totat time)/(time not in descendants).");
        this.printTree(writer, 1);
        writer.println("---");
        writer.println("Time accumulated in each category at any node");
        this.printFlat(writer);
    }

    class Entry {
        long tThis = 0L;
        long tChild = 0L;
        int count = 0;

        Entry() {
        }
    }
}

