/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.compiler;

import java.awt.event.ActionEvent;
import java.awt.event.MouseListener;
import java.net.URL;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.MissingResourceException;
import java.util.UUID;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import javax.swing.Icon;
import oracle.ide.Context;
import oracle.ide.Ide;
import oracle.ide.adapters.AdapterFactory;
import oracle.ide.adapters.AdapterManager;
import oracle.ide.ceditor.LineNavigationPoint;
import oracle.ide.compiler.BuildLog;
import oracle.ide.compiler.BuildSystemListener2;
import oracle.ide.controller.IdeAction;
import oracle.ide.feedback.FeedbackManager;
import oracle.ide.log.LogOwner;
import oracle.ide.log.LogPage;
import oracle.ide.markers.ActionMarker;
import oracle.ide.markers.Markable;
import oracle.ide.markers.Marker;
import oracle.ide.markers.MarkerException;
import oracle.ide.markers.ProblemMarker;
import oracle.ide.model.Element;
import oracle.ide.model.Locatable;
import oracle.ide.model.Node;
import oracle.ide.model.NodeFactory;
import oracle.ide.model.Project;
import oracle.ide.model.TextNode;
import oracle.ide.model.Workspace;
import oracle.ide.navigation.NavigationPoint;
import oracle.ide.view.View;
import oracle.javatools.buffer.LineMap;
import oracle.javatools.buffer.TextBuffer;
import oracle.javatools.patterns.Operator;
import oracle.jdeveloper.compiler.CompilerActionMarker;
import oracle.jdeveloper.compiler.CompilerContext;
import oracle.jdeveloper.compiler.CompilerProblemMarker;
import oracle.jdeveloper.compiler.IdeLog;
import oracle.jdevimpl.resource.JdevBuildExtensionManifest;
import oracle.ojc.interfaces.Storage;

public class MarkerLog
implements LogPage,
BuildSystemListener2 {
    private static final Operator<Context, String> MAKE_NAMED_PROJECT_OPERATOR = new FormatStringWithSelectionNameOperator("MAKE_NAMED_PROJECT_AND_DEPENDENCIES");
    private static final Operator<Context, String> MAKE_NAMED_APP_OPERATOR = new FormatStringWithWorkspaceNameOperator("MAKE_NAMED_PROJECT_AND_DEPENDENCIES");
    private static final Operator<Context, String> MAKE_NAMED_PROJECT_ONLY_OPERATOR = new FormatStringWithProjectNameOperator("MAKE_NAMED_PROJECT_ONLY");
    private static final Operator<Context, String> REBUILD_NAMED_PROJECT_OPERATOR = new FormatStringWithSelectionNameOperator("REBUILD_NAMED_PROJECT_AND_DEPENDENCIES");
    private static final Operator<Context, String> REBUILD_NAMED_APP_OPERATOR = new FormatStringWithWorkspaceNameOperator("REBUILD_NAMED_PROJECT_AND_DEPENDENCIES");
    private static final Operator<Context, String> REBUILD_NAMED_PROJECT_ONLY_OPERATOR = new FormatStringWithProjectNameOperator("REBUILD_NAMED_PROJECT_ONLY");
    private static final Operator<Context, String> CLEAN_NAMED_PROJECT_OPERATOR = new FormatStringWithProjectNameOperator("CLEAN_NAMED_PROJECT");
    private static final Operator<Context, String> CLEAN_NAMED_APP_OPERATOR = new FormatStringWithWorkspaceNameOperator("CLEAN_APPLICATION");
    private static final Operator<Context, String> CLEAN_AND_REFRESH_NAMED_APP_OPERATOR = new FormatStringWithWorkspaceNameOperator("CLEAN_AND_REFRESH_APPLICATION");
    private static final Map<String, Operator<Context, String>> STRING_OPERATORS = new HashMap<String, Operator<Context, String>>();
    private static final int SEVERITIES;
    private static final String UNHANDLED_MSG_FMT = "Unhandled msg:\n\tkind = {0}\n\tmessage = {1}\n\tcode = {2}\n\tworkspace = {3}\n\tproject = {4}\n\tfile = {5}\n\tline = {6}\n\tcolumn = {7}";
    private AtomicInteger nerrors = new AtomicInteger(0);
    private AtomicInteger nwarnings = new AtomicInteger(0);
    private AtomicInteger ninfos = new AtomicInteger(0);
    private Map<Markable, AddMarkersTask> addMarkersTasksByMarkable = new HashMap<Markable, AddMarkersTask>();
    private ScheduledExecutorService scheduler = Executors.newScheduledThreadPool(1);
    private Marker.EventDescription event;
    private Context primaryContext;
    private Context activeContext;
    private List<CompilerProblemMarker> removedMarkers = new ArrayList<CompilerProblemMarker>();
    private boolean buildWasCanceled;
    private Map<Node, Map<CompilerProblemMarker, NavigationPoint>> markerToNavigationPoint = new HashMap<Node, Map<CompilerProblemMarker, NavigationPoint>>();

    public MarkerLog() {
        AdapterFactory<CompilerProblemMarker, NavigationPoint> factory = new AdapterFactory<CompilerProblemMarker, NavigationPoint>(){

            public NavigationPoint adapt(CompilerProblemMarker marker) {
                try {
                    for (Map map : MarkerLog.this.markerToNavigationPoint.values()) {
                        for (Map.Entry entry : map.entrySet()) {
                            if (entry.getKey() != marker) continue;
                            return (NavigationPoint)entry.getValue();
                        }
                    }
                    Node node = NodeFactory.findOrCreate((URL)marker.markable().getUrl());
                    if (node instanceof TextNode) {
                        Context markerContext = new Context(marker.context());
                        markerContext.setNode(node);
                        int line = marker.line();
                        line = line <= 0 ? 1 : line;
                        int column = marker.column();
                        column = column <= 0 ? 0 : column - 1;
                        return new LineNavigationPoint(markerContext, line, column, false);
                    }
                }
                catch (Exception ex) {
                    FeedbackManager.reportException((Throwable)ex);
                }
                return null;
            }
        };
        AdapterManager.Factory.getAdapterManager().registerFactory((AdapterFactory)factory);
    }

    private void error(Node node, int line, int col, int errNumber, String errMsg, NavigationPoint navigationPoint) {
        this.createMarker(node, line, col, errNumber, errMsg, ProblemMarker.Severity.ERROR.value, navigationPoint, this.nerrors);
    }

    private void warning(Node node, int line, int col, int errNumber, String errMsg, NavigationPoint navigationPoint) {
        this.createMarker(node, line, col, errNumber, errMsg, ProblemMarker.Severity.WARNING.value, navigationPoint, this.nwarnings);
    }

    private void info(Node node, int line, int col, int errNumber, String errMsg, NavigationPoint navigationPoint) {
        this.createMarker(node, line, col, errNumber, errMsg, ProblemMarker.Severity.INFO.value, navigationPoint, this.ninfos);
    }

    private void clear(Node node) {
        try {
            this.markerToNavigationPoint.remove(node);
            Markable markable = Markable.Adapter.adapt((Locatable)node);
            if (null == markable) {
                if (Ide.isQuitting()) {
                    return;
                }
                throw new IllegalStateException("Can't get Markable object for " + node.getLongLabel());
            }
            this.removedMarkers.addAll(markable.removeMarkers(CompilerProblemMarker.class, true));
        }
        catch (Exception e) {
            FeedbackManager.reportException((Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Context getActiveContext() {
        MarkerLog markerLog = this;
        synchronized (markerLog) {
            if (null != this.activeContext) {
                return this.activeContext;
            }
            if (null != this.primaryContext) {
                return this.primaryContext;
            }
        }
        return null;
    }

    private Node getNode(Storage storage) {
        if (null == storage) {
            return null;
        }
        return (Node)AdapterManager.Factory.getAdapterManager().adapt((Object)storage, Node.class);
    }

    private Node getNode(IdeLog.Message message) {
        if (null == message) {
            return null;
        }
        Node node = this.getNode(message.getFile());
        if (null != node) {
            return node;
        }
        node = message.getProject();
        if (null != node) {
            return node;
        }
        return message.getWorkspace();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void createMarker(Node node, int line, int col, int errNumber, String errMsg, int sev, NavigationPoint navigationPoint, AtomicInteger count) {
        try {
            this.createMarker(node, line, col, errNumber, errMsg, sev, navigationPoint);
        }
        catch (Exception e) {
            FeedbackManager.reportException((Throwable)e);
        }
        finally {
            count.getAndIncrement();
        }
    }

    private void createMarker(Node node, int line, int col, int errNumber, String errMsg, int sev, NavigationPoint navigationPoint) throws Exception {
        Markable markable = null;
        markable = null != node ? Markable.Adapter.adapt((Locatable)node) : Markable.Adapter.getSystemMarkable();
        if (null == markable) {
            if (Ide.isQuitting()) {
                return;
            }
            throw new Exception("Unable to access Markable object for " + node);
        }
        Context context = this.getActiveContext();
        if (null == context) {
            throw new IllegalStateException("No active context");
        }
        CompilerProblemMarker problem = this.findMarker(markable, line, col, errNumber, errMsg, sev);
        if (null == problem) {
            problem = (CompilerProblemMarker)Marker.Factory.newMarker(CompilerProblemMarker.class, (Context)context);
            problem.severity(sev);
            problem.line(line);
            problem.column(col);
            problem.description(errMsg);
            problem.code(String.valueOf(errNumber));
        }
        if (navigationPoint != null) {
            Map<CompilerProblemMarker, NavigationPoint> map = this.markerToNavigationPoint.get(node);
            if (map == null) {
                map = new HashMap<CompilerProblemMarker, NavigationPoint>();
                this.markerToNavigationPoint.put(node, map);
            }
            map.put(problem, navigationPoint);
        }
        if (null != this.event) {
            problem.addEvent(this.event);
        }
        if (node instanceof TextNode) {
            this.setOffsetAndLength((TextNode)node, problem);
        }
        this.addMarker(markable, (Marker)problem);
    }

    private CompilerProblemMarker findMarker(Markable markable, int line, int col, int errNum, String errMsg, int sev) {
        for (CompilerProblemMarker marker : this.removedMarkers) {
            try {
                if (marker.isDeleted() || !marker.markable().equals((Object)markable) || sev != marker.severity() || !String.valueOf(errNum).equals(marker.code()) || !errMsg.equals(marker.description()) || line != marker.line() || col != marker.column()) continue;
                return marker;
            }
            catch (MarkerException markerException) {
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setOffsetAndLength(TextNode node, CompilerProblemMarker problem) throws Exception {
        if (1 >= problem.line()) {
            problem.offset(problem.column());
            problem.length(0);
            return;
        }
        try {
            TextBuffer buffer = node.acquireTextBuffer();
            if (null != buffer) {
                LineMap lineMap = buffer.getLineMap();
                int line = problem.line() - 1;
                if (line >= lineMap.getLineCount()) {
                    line = lineMap.getLineCount() - 1;
                }
                int offset = lineMap.getLineStartOffset(line);
                problem.offset(offset += problem.column() <= 0 ? 1 : problem.column());
                problem.length(0);
            }
        }
        finally {
            node.releaseTextBuffer();
        }
    }

    private synchronized void addMarker(Markable markable, Marker marker) {
        AddMarkersTask task = this.addMarkersTasksByMarkable.get(markable);
        if (null == task) {
            task = new AddMarkersTask(markable, marker);
            this.addMarkersTasksByMarkable.put(markable, task);
            this.scheduler.schedule(task, 100L, TimeUnit.MILLISECONDS);
        } else {
            task.addMarkers(marker);
        }
    }

    public void log(Object obj) {
        if (!(obj instanceof IdeLog.Message)) {
            throw new IllegalArgumentException("Unrecognized log object: " + obj);
        }
        IdeLog.Message msg = (IdeLog.Message)obj;
        this.initActiveContext(msg);
        switch (msg.getKind()) {
            case 1: {
                this.error(this.getNode(msg), msg.getLine(), msg.getColumn(), msg.getCode(), msg.getMessage(), msg.getNavigationPoint());
                break;
            }
            case 2: {
                this.warning(this.getNode(msg), msg.getLine(), msg.getColumn(), msg.getCode(), msg.getMessage(), msg.getNavigationPoint());
                break;
            }
            case 0: 
            case 5: {
                this.info(this.getNode(msg), msg.getLine(), msg.getColumn(), msg.getCode(), msg.getMessage(), msg.getNavigationPoint());
                break;
            }
            case 3: {
                this.clear(this.getNode(msg));
                break;
            }
            case 6: {
                break;
            }
            case 4: {
                break;
            }
            default: {
                FeedbackManager.addFeedback((String)MessageFormat.format(UNHANDLED_MSG_FMT, msg.getKind(), msg.getMessage(), msg.getCode(), msg.getWorkspace(), msg.getProject(), msg.getFile(), msg.getLine(), msg.getColumn()));
            }
        }
    }

    public void clearAll() {
        HashSet<Node> nodes = new HashSet<Node>(this.markerToNavigationPoint.keySet());
        for (Node node : nodes) {
            this.clear(node);
        }
    }

    public String getTitleName() {
        return null;
    }

    public String getTabName() {
        return null;
    }

    public Icon getTabIcon() {
        return null;
    }

    public String getToolTip() {
        return null;
    }

    public void setOwner(LogOwner owner) {
    }

    public void addMouseListener(MouseListener listener) {
    }

    public void removeMouseListener(MouseListener listener) {
    }

    public View getLogPageView() {
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void buildWillStart(Context context) {
        MarkerLog markerLog = this;
        synchronized (markerLog) {
            this.primaryContext = context;
            this.buildWasCanceled = false;
            String eventId = null == this.event || true == Ide.getEnvironOptions().getClearCompilerLogBeforeCompile() ? this.newEventId() : this.event.getId();
            String eventDesc = this.newEventDescription(context);
            this.event = new Marker.EventDescription(eventId, eventDesc);
        }
        try {
            Markable markable = Markable.Adapter.getSystemMarkable();
            CompilerActionMarker action = (CompilerActionMarker)Marker.Factory.newMarker(CompilerActionMarker.class, (Context)context);
            action.addEvent(this.event);
            action.actionType(CompilerActionMarker.ActionType.BUILD.value);
            action.state(ActionMarker.State.BEGINNING.value);
            action.severities(SEVERITIES);
            this.addMarker(markable, (Marker)action);
        }
        catch (MarkerException e) {
            FeedbackManager.reportException((Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void buildFinished(int errorCount, int warningCount, int infoCount) {
        try {
            Markable markable = Markable.Adapter.getSystemMarkable();
            CompilerActionMarker action = (CompilerActionMarker)Marker.Factory.newMarker(CompilerActionMarker.class, (Context)this.primaryContext);
            action.addEvent(this.event);
            action.actionType(CompilerActionMarker.ActionType.BUILD.value);
            action.state(this.buildWasCanceled ? ActionMarker.State.CANCELED.value : ActionMarker.State.COMPLETED.value);
            action.errorCount(errorCount);
            action.warningCount(warningCount);
            action.infoCount(infoCount);
            action.severities(SEVERITIES);
            this.addMarker(markable, (Marker)action);
        }
        catch (MarkerException e) {
            FeedbackManager.reportException((Throwable)e);
        }
        MarkerLog markerLog = this;
        synchronized (markerLog) {
            this.primaryContext = null;
            this.removedMarkers.clear();
        }
        this.nerrors.set(0);
        this.nwarnings.set(0);
        this.ninfos.set(0);
    }

    public void cleanWillStart(Context context) {
    }

    public void cleanFinished(Context context) {
    }

    private String newEventId() {
        return UUID.randomUUID().toString();
    }

    private String newEventDescription(Context context) {
        String description = null;
        IdeAction action = CompilerContext.getCompileAction(context);
        if (null != action) {
            String c;
            String cmd = action.getCommand();
            if (null == cmd && null != (c = Ide.findCmdName((int)action.getCommandId()))) {
                if (STRING_OPERATORS.containsKey(c)) {
                    cmd = (String)STRING_OPERATORS.get(c).operate((Object)context);
                } else {
                    try {
                        cmd = JdevBuildExtensionManifest.get(c);
                    }
                    catch (MissingResourceException mre) {
                        cmd = c;
                    }
                }
            }
            if (null != cmd) {
                description = cmd;
            }
        } else {
            EventObject event = context.getEvent();
            if (event instanceof ActionEvent) {
                description = ((ActionEvent)event).getActionCommand();
            }
        }
        if (description == null) {
            description = JdevBuildExtensionManifest.get("BUILD_CATEGORY");
        }
        return description;
    }

    public void workspaceBuildWillStart(Workspace workspace) {
        Context context = new Context(this.primaryContext);
        context.setWorkspace(workspace);
        this.primaryContext = context;
    }

    public void workspaceBuildFinished(Workspace workspace) {
    }

    public void workspaceCleanWillStart(Workspace workspace) {
        Context context = new Context(this.primaryContext);
        context.setWorkspace(workspace);
        this.primaryContext = context;
    }

    public void workspaceCleanFinished(Workspace workspace) {
    }

    public synchronized void projectBuildWillStart(Workspace workspace, Project project) {
        Context context = new Context(this.primaryContext);
        context.setWorkspace(workspace);
        context.setProject(project);
        this.primaryContext = context;
    }

    public synchronized void projectBuildFinished(Workspace workspace, Project project) {
    }

    public void projectCleanWillStart(Workspace workspace, Project project) {
        Context context = new Context(this.primaryContext);
        context.setWorkspace(workspace);
        context.setProject(project);
        this.primaryContext = context;
    }

    public void projectCleanFinished(Workspace workspace, Project project) {
    }

    public void setBuildLog(BuildLog buildLog) {
    }

    public void buildCanceled(Context context) {
        this.buildWasCanceled = true;
    }

    private synchronized void initActiveContext(IdeLog.Message message) {
        if (null == message) {
            return;
        }
        Workspace workspace = message.getWorkspace();
        Project project = message.getProject();
        Node node = this.getNode(message);
        Context context = new Context(workspace, project);
        if (node != project && node != workspace) {
            context.setNode(node);
        }
        this.activeContext = context;
    }

    static {
        STRING_OPERATORS.put("MAKE_PROJECT_AND_DEPENDENCIES", MAKE_NAMED_PROJECT_OPERATOR);
        STRING_OPERATORS.put("MAKE_PROJECT_ONLY", MAKE_NAMED_PROJECT_ONLY_OPERATOR);
        STRING_OPERATORS.put("MAKE_APPLICATION", MAKE_NAMED_APP_OPERATOR);
        STRING_OPERATORS.put("MAKE_SELECTED", MAKE_NAMED_PROJECT_OPERATOR);
        STRING_OPERATORS.put("REBUILD_PROJECT_AND_DEPENDENCIES", REBUILD_NAMED_PROJECT_OPERATOR);
        STRING_OPERATORS.put("REBUILD_PROJECT_ONLY", REBUILD_NAMED_PROJECT_ONLY_OPERATOR);
        STRING_OPERATORS.put("REBUILD_APPLICATION", REBUILD_NAMED_APP_OPERATOR);
        STRING_OPERATORS.put("REBUILD_SELECTED", REBUILD_NAMED_PROJECT_OPERATOR);
        STRING_OPERATORS.put("CLEAN_PROJECT", CLEAN_NAMED_PROJECT_OPERATOR);
        STRING_OPERATORS.put("CLEAN_APPLICATION", CLEAN_NAMED_APP_OPERATOR);
        STRING_OPERATORS.put("CLEAN_AND_REFRESH_APPLICATION", CLEAN_AND_REFRESH_NAMED_APP_OPERATOR);
        STRING_OPERATORS.put("CLEAN_SELECTED", CLEAN_NAMED_PROJECT_OPERATOR);
        SEVERITIES = ProblemMarker.Severity.toBitmap((ProblemMarker.Severity[])new ProblemMarker.Severity[]{ProblemMarker.Severity.ERROR, ProblemMarker.Severity.WARNING, ProblemMarker.Severity.INFO});
    }

    private static class FormatStringWithSelectionNameOperator
    extends FormatStringWithContextPropertyOperator {
        public FormatStringWithSelectionNameOperator(String formatString) {
            super(formatString);
        }

        @Override
        protected String getLabel(Context ctx) {
            String label = null;
            Object prop = ctx.getProperty("buildsystem.elements.to.build");
            if (prop instanceof Element[]) {
                label = this.getLabel((Element[])prop);
            }
            if (null == label) {
                label = this.getLabel(ctx.getSelection());
            }
            return label;
        }

        private String getLabel(Element[] elements) {
            String label = null;
            if (null == elements) {
                return label;
            }
            switch (elements.length) {
                case 0: {
                    break;
                }
                case 1: {
                    label = elements[0].getShortLabel();
                    break;
                }
                default: {
                    Object[] labels = new String[elements.length];
                    for (int i = 0; i < elements.length; ++i) {
                        labels[i] = elements[i].getShortLabel();
                    }
                    label = Arrays.toString(labels);
                    label = label.replace("[", "");
                    label = label.replace("]", "");
                }
            }
            return label;
        }
    }

    private static class FormatStringWithWorkspaceNameOperator
    extends FormatStringWithContextPropertyOperator {
        public FormatStringWithWorkspaceNameOperator(String formatString) {
            super(formatString);
        }

        @Override
        protected String getLabel(Context obj) {
            Workspace ws = obj.getWorkspace();
            return null != ws ? ws.getShortLabel() : "";
        }
    }

    private static class FormatStringWithProjectNameOperator
    extends FormatStringWithContextPropertyOperator {
        public FormatStringWithProjectNameOperator(String formatString) {
            super(formatString);
        }

        @Override
        protected String getLabel(Context ctx) {
            Project proj = ctx.getProject();
            return null != proj ? proj.getShortLabel() : "";
        }
    }

    private static abstract class FormatStringWithContextPropertyOperator
    implements Operator<Context, String> {
        private final String formatString;

        public FormatStringWithContextPropertyOperator(String formatString) {
            if (null == formatString || formatString.isEmpty()) {
                throw new IllegalArgumentException("Format string must be provided");
            }
            this.formatString = JdevBuildExtensionManifest.get(formatString).replace("&", "");
        }

        public String operate(Context obj) {
            return MessageFormat.format(this.formatString, this.getLabel(obj));
        }

        protected abstract String getLabel(Context var1);
    }

    private class AddMarkersTask
    implements Runnable {
        private final Markable markable;
        private final List<Marker> markers = new ArrayList<Marker>();

        public AddMarkersTask(Markable markable, Marker ... markers) {
            this.markable = markable;
            this.addMarkers(markers);
        }

        public synchronized void addMarkers(Marker ... markers) {
            this.markers.addAll(Arrays.asList(markers));
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            MarkerLog markerLog = MarkerLog.this;
            synchronized (markerLog) {
                MarkerLog.this.addMarkersTasksByMarkable.remove(this.markable);
            }
            Marker[] markersToAdd = new Marker[]{};
            AddMarkersTask addMarkersTask = this;
            synchronized (addMarkersTask) {
                markersToAdd = this.markers.toArray(markersToAdd);
            }
            try {
                this.markable.addMarkers(markersToAdd);
            }
            catch (MarkerException e) {
                FeedbackManager.reportException((Throwable)e);
            }
        }
    }
}

