/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.compiler;

import oracle.ide.Context;
import oracle.ide.Ide;
import oracle.ide.controller.Controller;
import oracle.ide.controller.IdeAction;
import oracle.ide.controller.LabelUpdater;
import oracle.ide.model.WorkingSet;
import oracle.ide.model.Workspace;
import oracle.jdevimpl.compiler.JCompilerMenuItems;
import oracle.jdevimpl.resource.JdevBuildExtensionManifest;

public final class JCompilerMenuController
implements Controller {
    private static void setActionUpdater(String cmdName, LabelUpdater workingSetUpdater) {
        int cmdId = Ide.findOrCreateCmdID((String)cmdName);
        IdeAction action = IdeAction.get((int)cmdId);
        if (action != null) {
            action.setLabelUpdater(workingSetUpdater);
        }
    }

    public boolean handleEvent(IdeAction action, Context context) {
        return JCompilerMenuItems.getInstance().handleEvent(action, context);
    }

    public boolean update(IdeAction action, Context context) {
        return JCompilerMenuItems.getInstance().update(action, context);
    }

    static {
        LabelUpdater workingSetUpdater = new LabelUpdater(){

            public String labelWhenEnabled(Context context, IdeAction action, String originalLabel) {
                return this.getLabel(context, action, originalLabel);
            }

            public String labelWhenDisabled(Context context, IdeAction action, String originalLabel) {
                return this.getLabel(context, action, originalLabel);
            }

            private String getLabel(Context context, IdeAction action, String originalLabel) {
                if (action.getCommandId() == Ide.findOrCreateCmdID((String)"MAKE_WORKINGSET")) {
                    return JdevBuildExtensionManifest.format("MAKE_NAMED_WORKINGSET", this.getWorkingSetName(context));
                }
                if (action.getCommandId() == Ide.findOrCreateCmdID((String)"REBUILD_WORKINGSET")) {
                    return JdevBuildExtensionManifest.format("REBUILD_NAMED_WORKINGSET", this.getWorkingSetName(context));
                }
                return originalLabel;
            }

            private String getWorkingSetName(Context context) {
                WorkingSet workingSet;
                Workspace workspace;
                String workingSetName = null;
                Workspace workspace2 = workspace = context == null ? null : context.getWorkspace();
                if (workspace != null && (workingSet = JCompilerMenuItems.getWorkingSet(workspace)) != null) {
                    workingSetName = workingSet.getName();
                }
                if (workingSetName == null) {
                    workingSetName = "";
                }
                return workingSetName;
            }

            public void setEnabledFormat(String format) {
            }

            public void setDisabledFormat(String format) {
            }
        };
        JCompilerMenuController.setActionUpdater("MAKE_WORKINGSET", workingSetUpdater);
        JCompilerMenuController.setActionUpdater("REBUILD_WORKINGSET", workingSetUpdater);
    }
}

