/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.compiler;

import java.text.MessageFormat;
import oracle.ide.adapters.AdapterFactory;
import oracle.ide.markers.Marker;
import oracle.ide.markers.MarkerLabelProvider;
import oracle.ide.model.LabelProvider;
import oracle.javatools.util.Log;
import oracle.javatools.util.ModelUtil;
import oracle.jdeveloper.compiler.CompilerProblemMarker;

public class CompilerProblemMarkerLabelProvider
implements LabelProvider<CompilerProblemMarker>,
AdapterFactory<CompilerProblemMarker, LabelProvider> {
    private static final Log LOG = new Log("CompilerProblemMarkerLabelProvider");
    private static final String PROBLEM_LOC_REGEX = "\\(\\d+\\,\\s*\\d+\\)";
    private static final String PROBLEM_LOC_FORMAT = "{0}({1},{2}){3}";
    private final LabelProvider<Marker> base = new MarkerLabelProvider();

    public String labelFor(CompilerProblemMarker marker, String key) {
        if ("description".equalsIgnoreCase(key)) {
            String description = marker.description();
            if (!ModelUtil.hasLength((String)description)) {
                return description;
            }
            LOG.trace("Splitting the original description ({0}) with a regular expression ({1})", (Object)description, (Object)PROBLEM_LOC_REGEX);
            String[] strings = description.split(PROBLEM_LOC_REGEX, 2);
            switch (strings.length) {
                default: {
                    LOG.trace("Got {0} substring(s); returning original description", strings.length);
                    return description;
                }
                case 2: 
            }
            String label = MessageFormat.format(PROBLEM_LOC_FORMAT, strings[0], marker.line(), marker.column(), strings[1]);
            LOG.trace("Got 2 substrings; returning updated label: {0}", (Object)label);
            return label;
        }
        return this.base.labelFor((Object)marker, key);
    }

    public LabelProvider adapt(CompilerProblemMarker marker) {
        return this;
    }
}

