/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdeveloper.compiler;

import java.net.URL;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Vector;
import oracle.ide.compiler.Diagnostic;
import oracle.ide.log.LogPage;
import oracle.ide.model.Node;
import oracle.ide.model.NodeFactory;
import oracle.ide.model.Project;
import oracle.ide.model.Workspace;
import oracle.ide.navigation.NavigationPoint;
import oracle.ide.net.URLFactory;
import oracle.jdeveloper.compiler.CompArb;
import oracle.jdeveloper.compiler.CompilerPage;
import oracle.jdeveloper.compiler.ProblemsPage;
import oracle.jdeveloper.compiler.Translator;
import oracle.ojc.interfaces.Storage;

public class IdeLog
implements Translator.Log {
    private int errCnt = 0;
    private int wrnCnt = 0;
    private Workspace workspace = null;
    private Project project = null;
    private HashMap asyncLogPages = new HashMap();
    private Vector<Message> msgList = new Vector();
    private HashMap clearCache = new HashMap();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void reinit() {
        this.errCnt = 0;
        this.wrnCnt = 0;
        this.workspace = null;
        this.project = null;
        HashMap hashMap = this.asyncLogPages;
        synchronized (hashMap) {
            this.asyncLogPages.clear();
        }
        this.msgList.clear();
        this.clearCache.clear();
        this.starting();
    }

    public Project getProject() {
        return this.project;
    }

    public void setProject(Project project) {
        this.project = project;
    }

    public Workspace getWorkspace() {
        return this.workspace;
    }

    public void setWorkspace(Workspace wsp) {
        this.workspace = wsp;
    }

    @Deprecated
    public static int getPartialUsedStarImportCode() {
        return -1;
    }

    @Deprecated
    public static int getUnusedImportCode() {
        return -1;
    }

    @Deprecated
    public static boolean isPartiallyUsedImportWarning(Message msg) {
        return false;
    }

    @Deprecated
    public static boolean isUnusedImportWarning(Message msg) {
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void logMessages() {
        HashMap hashMap = this.asyncLogPages;
        synchronized (hashMap) {
            if (this.asyncLogPages.size() > 0) {
                Iterator it = this.asyncLogPages.keySet().iterator();
                Object[] messages = this.msgList.toArray();
                while (it.hasNext()) {
                    LogPage page = (LogPage)it.next();
                    for (int j = 0; j < messages.length; ++j) {
                        page.log(messages[j]);
                    }
                }
                this.msgList.clear();
            }
        }
    }

    private void printMsg(boolean warning, Storage source, int line, int col, int errNumber, String errMsg) {
        String newErrMsg = this.getPrefixedMessage(warning ? 2 : 1, line, col, errMsg);
        Message message = new Message(this.workspace, source == null ? null : this.project, source, newErrMsg, errNumber, line, col, warning ? 2 : 1);
        this.msgList.add(message);
        this.logMessages();
    }

    private void printMsg(Diagnostic diagnostic) {
        int kind;
        if (diagnostic == null) {
            return;
        }
        switch (diagnostic.getKind()) {
            case ERROR: {
                kind = 1;
                break;
            }
            case WARNING: {
                kind = 2;
                break;
            }
            default: {
                kind = 0;
            }
        }
        Message message = new Message(this.workspace, diagnostic.getStorage() == null ? null : this.project, diagnostic, kind);
        this.msgList.add(message);
        this.logMessages();
    }

    @Override
    public void error(Storage source, int line, int column, int number, String message) {
        this.printMsg(false, source, line, column, number, message);
        ++this.errCnt;
    }

    public void diagnostic(Diagnostic diagnostic) {
        if (diagnostic == null) {
            return;
        }
        int kind = 5;
        if (diagnostic.getKind() == Diagnostic.Kind.ERROR) {
            kind = 1;
        } else if (diagnostic.getKind() == Diagnostic.Kind.WARNING) {
            kind = 2;
        }
        String newMessage = this.getPrefixedMessage(kind, diagnostic.getLine(), diagnostic.getColumn(), diagnostic.getMessage());
        diagnostic.setMessage(newMessage);
        switch (diagnostic.getKind()) {
            case ERROR: {
                ++this.errCnt;
                break;
            }
            case WARNING: {
                ++this.wrnCnt;
            }
        }
        this.printMsg(diagnostic);
    }

    private String getPrefixedMessage(int kind, int line, int column, String message) {
        StringBuilder s = new StringBuilder();
        if (kind == 1) {
            s.append(CompArb.getString(38));
        } else if (kind == 2) {
            s.append(CompArb.getString(39));
        }
        if (line > 0) {
            s.append('(');
            s.append(line);
            if (column > 0) {
                s.append(',');
                s.append(column);
            }
            s.append(')');
        }
        if (s.length() > 0) {
            s.append(": ");
        }
        s.append(message);
        return s.toString();
    }

    @Override
    public void warning(Storage source, int line, int column, int number, String message) {
        this.printMsg(true, source, line, column, number, message);
        ++this.wrnCnt;
    }

    @Override
    public void clear(Storage source) {
        if (source != null) {
            if (this.clearCache.get(source.getPath()) != null) {
                return;
            }
            this.clearCache.put(source.getPath(), source.getPath());
        }
        Message message = new Message(this.workspace, this.project, source, null, -1, 0, 0, 3);
        this.msgList.add(message);
        this.logMessages();
    }

    private void starting() {
        Message message = new Message(this.workspace, this.project, null, null, -1, 0, 0, 6);
        this.msgList.add(message);
        this.logMessages();
    }

    public void completed() {
        Message message = new Message(this.workspace, this.project, null, null, -1, 0, 0, 4);
        this.msgList.add(message);
        this.logMessages();
    }

    @Override
    public int nerrors() {
        return this.errCnt;
    }

    @Override
    public int nwarnings() {
        return this.wrnCnt;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void registerAsynchronousLogPage(LogPage asyncLogPage) {
        HashMap hashMap = this.asyncLogPages;
        synchronized (hashMap) {
            Integer i = (Integer)this.asyncLogPages.get(asyncLogPage);
            if (i == null) {
                i = new Integer(1);
                if (asyncLogPage instanceof CompilerPage) {
                    ((CompilerPage)asyncLogPage).startAsynchronousLogging();
                } else if (asyncLogPage instanceof ProblemsPage) {
                    ((ProblemsPage)asyncLogPage).startAsynchronousLogging();
                }
            } else {
                i = new Integer(i + 1);
            }
            this.asyncLogPages.put(asyncLogPage, i);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unregisterAsynchronousLogPage(LogPage asyncLogPage) {
        HashMap hashMap = this.asyncLogPages;
        synchronized (hashMap) {
            this.logMessages();
            Integer i = (Integer)this.asyncLogPages.get(asyncLogPage);
            if (i != null) {
                if (i > 1) {
                    this.asyncLogPages.put(asyncLogPage, new Integer(i - 1));
                } else {
                    this.asyncLogPages.remove(asyncLogPage);
                    if (asyncLogPage instanceof CompilerPage) {
                        ((CompilerPage)asyncLogPage).finishAsynchronousLogging();
                    } else if (asyncLogPage instanceof ProblemsPage) {
                        ((ProblemsPage)asyncLogPage).finishAsynchronousLogging();
                    }
                }
            }
        }
    }

    public static class Message {
        public static final int Normal = 0;
        public static final int Error = 1;
        public static final int Warning = 2;
        public static final int Remove = 3;
        public static final int Completed = 4;
        public static final int NoDetails = 5;
        public static final int Starting = 6;
        public ActivateEvent activateEvent = null;
        public FixEvent fixEvent = null;
        public Object userData = null;
        Workspace workspace;
        Project project;
        Storage fname;
        String msg;
        int line;
        int col;
        int code;
        int kind;
        NavigationPoint navigationPoint;

        private Message() {
        }

        private void checkProject() {
            Node n;
            String parentProjectString;
            if (this.project != null && (parentProjectString = this.project.getProperty("realProject")) != null && (n = NodeFactory.find((URL)URLFactory.newFileURL((String)parentProjectString))) instanceof Project) {
                this.project = (Project)n;
            }
        }

        public Message(Workspace wsp, Project project, Storage fname, String msg, int code, int line, int col, int kind) {
            this.fname = fname;
            this.msg = msg;
            this.workspace = wsp;
            this.project = project;
            this.code = code;
            this.line = line;
            this.col = col;
            this.kind = kind;
            this.checkProject();
        }

        public Message(Workspace wsp, Project project, Storage fname, String msg, int code, int line, int col) {
            this(wsp, project, fname, msg, code, line, col, 0);
        }

        public Message(Workspace wsp, Project project, Diagnostic diagnostic, int kind) {
            this.fname = diagnostic.getStorage();
            this.msg = diagnostic.getMessage();
            this.workspace = wsp;
            this.project = project;
            this.code = diagnostic.getNumber();
            this.line = diagnostic.getLine();
            this.col = diagnostic.getColumn();
            this.navigationPoint = diagnostic.getNavigationPoint();
            this.kind = kind;
            this.checkProject();
        }

        public String toString() {
            return this.msg;
        }

        public boolean isWarning() {
            return this.kind == 2;
        }

        public boolean isError() {
            return this.kind == 1;
        }

        public boolean isRemove() {
            return this.kind == 3;
        }

        public boolean isStarting() {
            return this.kind == 6;
        }

        public boolean isCompleted() {
            return this.kind == 4;
        }

        public boolean isNoDetails() {
            return this.kind == 5;
        }

        public Project getProject() {
            return this.project;
        }

        public Workspace getWorkspace() {
            return this.workspace;
        }

        public String getMessage() {
            return this.msg;
        }

        public int getKind() {
            return this.kind;
        }

        public Storage getFile() {
            return this.fname;
        }

        public int getLine() {
            return this.line;
        }

        public int getColumn() {
            return this.col;
        }

        public int getCode() {
            return this.code;
        }

        public NavigationPoint getNavigationPoint() {
            return this.navigationPoint;
        }
    }

    public static interface FixEvent {
        public void fix(Message var1);

        public boolean canFix(Message var1);
    }

    public static interface ActivateEvent {
        public void activate(Message var1);
    }
}

