/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdeveloper.compiler;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import oracle.jdeveloper.compiler.BuildNode;
import oracle.jdevimpl.compiler.TranslatorDefinition;

class BuildGraph {
    ArrayList buildRoots = new ArrayList(5);
    HashMap buildNodes = new HashMap(19);
    private List<TranslatorDefinition> prePreProcessors = new ArrayList<TranslatorDefinition>(5);

    BuildGraph() {
    }

    private void walkAndInsertInOrderedList(BuildNode n, ArrayList<TranslatorDefinition> result) {
        if (n.marker == 0 && n.translator != null) {
            int j;
            for (BuildNode buildNode : n.children) {
                this.walkAndInsertInOrderedList(buildNode, result);
            }
            n.marker = 1;
            for (j = 0; j < result.size() && result.get(j) != n.translator; ++j) {
            }
            if (j >= result.size()) {
                result.add(0, n.translator);
                if (n.preProcessors != null) {
                    for (TranslatorDefinition t : n.preProcessors) {
                        if (result.contains((Object)t)) continue;
                        result.add(0, t);
                    }
                }
            }
        }
    }

    public ArrayList<TranslatorDefinition> getOrderedTranslatorList() {
        ArrayList<TranslatorDefinition> result = new ArrayList<TranslatorDefinition>();
        for (int i = 0; i < this.buildRoots.size(); ++i) {
            BuildNode n = (BuildNode)this.buildRoots.get(i);
            this.walkAndInsertInOrderedList(n, result);
        }
        Iterator e = this.buildNodes.values().iterator();
        while (e.hasNext()) {
            ((BuildNode)e.next()).marker = 0;
        }
        block2: for (TranslatorDefinition prePreProcessor : this.prePreProcessors) {
            for (int x = 0; x < result.size(); ++x) {
                TranslatorDefinition translator = result.get(x);
                for (String ext : prePreProcessor.getOutputExtensions()) {
                    if (!translator.getInputExtensions().contains(ext)) continue;
                    result.add(x, prePreProcessor);
                    continue block2;
                }
            }
            result.add(prePreProcessor);
        }
        return result;
    }

    private boolean walkChildren(BuildNode node, int marker) {
        if (node.marker == marker) {
            System.out.println("error: walkGraph: circularity detected with node");
            return false;
        }
        node.marker = marker;
        for (BuildNode buildNode : node.children) {
            if (this.walkChildren(buildNode, marker)) continue;
            return false;
        }
        if (node.children.size() != 0 ^ node.translator != null && node.translator != null && node.translator.getOutputExtensions().size() > 0 && !node.translator.isPreprocessor()) {
            System.out.println("internal error: walkGraph: node with children should have a translator && node without them shouldn't have one");
        }
        node.marker = -1;
        return true;
    }

    private boolean checkGraph() {
        boolean result = true;
        for (int i = 0; i < this.buildRoots.size(); ++i) {
            if (this.walkChildren((BuildNode)this.buildRoots.get(i), i + 1)) continue;
            result = false;
        }
        for (BuildNode node : this.buildNodes.values()) {
            if (node.marker == 0) {
                System.out.println("checkGraph: node is not reachable");
                result = false;
            }
            node.marker = 0;
        }
        return result;
    }

    boolean rebuild(Map<String, Set<TranslatorDefinition>> translators) {
        this.buildNodes.clear();
        this.buildRoots.clear();
        this.prePreProcessors.clear();
        for (String ext : translators.keySet()) {
            boolean noInputExtension = ext.length() == 0;
            Set<TranslatorDefinition> al = translators.get(ext);
            for (TranslatorDefinition t : al) {
                if (noInputExtension) {
                    if (t.getOutputExtensions().isEmpty()) continue;
                    this.prePreProcessors.add(t);
                    continue;
                }
                BuildNode node = (BuildNode)this.buildNodes.get(ext);
                if (node == null) {
                    node = new BuildNode(ext, t);
                    this.buildNodes.put(ext, node);
                    this.buildRoots.add(node);
                } else if (node != null && !node.containsTranslator(t)) {
                    node.addTranslator(t);
                }
                if (t.isPreprocessor()) continue;
                Set<String> children = t.getOutputExtensions();
                for (String childExt : children) {
                    int j;
                    BuildNode child = (BuildNode)this.buildNodes.get(childExt);
                    if (child == null) {
                        child = new BuildNode(childExt, translators.get(childExt));
                        this.buildNodes.put(childExt, child);
                    }
                    if (child == node) continue;
                    for (j = 0; j < child.parents.size() && child.parents.get(j) != node; ++j) {
                    }
                    if (j >= child.parents.size()) {
                        child.parents.add(node);
                    }
                    for (j = 0; j < node.children.size() && node.children.get(j) != child; ++j) {
                    }
                    if (j < node.children.size()) continue;
                    node.children.add(child);
                }
            }
        }
        int i = 0;
        while (i < this.buildRoots.size()) {
            BuildNode n = (BuildNode)this.buildRoots.get(i);
            if (n.parents.size() > 0) {
                this.buildRoots.remove(i);
                continue;
            }
            ++i;
        }
        return this.checkGraph() && this.buildRoots.size() > 0 == this.buildNodes.size() > 0;
    }
}

