/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.xml.esax.spi;

import java.io.IOException;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import oracle.javatools.xml.esax.ElementContext;
import oracle.javatools.xml.esax.ElementHandler;
import oracle.javatools.xml.esax.HandlerException;
import oracle.javatools.xml.esax.XMLLocator;
import oracle.javatools.xml.esax.spi.DefaultElementContext;
import org.xml.sax.Attributes;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.DefaultHandler;

public class ExtensibleSAXParser {
    private final DefaultElementContext _context = this.createInitialContext();
    private SAXParser _parser = null;
    private Handler _handler = null;
    private Locator _locator;

    protected DefaultElementContext createInitialContext() {
        return new DefaultElementContext();
    }

    public ElementContext getContext() {
        return this._context;
    }

    public void parse(XMLLocator locator) throws ParserConfigurationException, SAXException, IOException {
        if (this._parser == null) {
            this._handler = new Handler();
            SAXParserFactory factory = SAXParserFactory.newInstance();
            factory.setNamespaceAware(true);
            this._parser = factory.newSAXParser();
            XMLReader reader = this._parser.getXMLReader();
            reader.setContentHandler(this._handler);
            reader.setErrorHandler(this._handler);
        }
        this._context.setLocator(locator);
        this._parser.getXMLReader().parse(locator.createInputSource());
    }

    private ElementHandler lookupHandler() {
        ElementHandler scopedHandler = this._context.getScopedHandler();
        return scopedHandler;
    }

    private class Handler
    extends DefaultHandler {
        private Handler() {
        }

        @Override
        public void startElement(String uri, String name, String qName, Attributes attributes) throws SAXException {
            ExtensibleSAXParser.this._context.beginElement(uri, name, attributes);
            ElementHandler handler = ExtensibleSAXParser.this.lookupHandler();
            if (handler != null) {
                try {
                    this.recordPosition();
                    handler.handleStart(ExtensibleSAXParser.this._context);
                }
                catch (HandlerException he) {
                    throw new SAXException(he);
                }
            }
            ExtensibleSAXParser.this._context.postBeginElement();
        }

        @Override
        public void endElement(String uri, String name, String qName) throws SAXException {
            ExtensibleSAXParser.this._context.endElement(uri, name);
            ElementHandler handler = ExtensibleSAXParser.this.lookupHandler();
            if (handler != null) {
                try {
                    this.recordPosition();
                    handler.handleEnd(ExtensibleSAXParser.this._context);
                }
                catch (HandlerException he) {
                    throw new SAXException(he);
                }
            }
            ExtensibleSAXParser.this._context.postEndElement();
        }

        @Override
        public void characters(char[] ch, int start, int length) {
            ExtensibleSAXParser.this._context.appendCharacters(ch, start, length);
        }

        @Override
        public void setDocumentLocator(Locator locator) {
            ExtensibleSAXParser.this._locator = locator;
        }

        private void recordPosition() {
            ExtensibleSAXParser.this._context.getLocator().setLineNumber(ExtensibleSAXParser.this._locator.getLineNumber());
            ExtensibleSAXParser.this._context.getLocator().setColumnNumber(ExtensibleSAXParser.this._locator.getColumnNumber());
        }
    }
}

