/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.util;

import java.util.Collections;
import java.util.concurrent.CopyOnWriteArrayList;
import oracle.javatools.util.Filter;
import oracle.javatools.util.Filterable;

public class CompositeFilter<T>
implements Filterable<T>,
Filter<T> {
    private final CopyOnWriteArrayList<Filter<T>> ands = new CopyOnWriteArrayList();
    private final CopyOnWriteArrayList<Filter<T>> ors = new CopyOnWriteArrayList();
    private Filter<T> internalFilter;

    @Override
    public void addFilter(Filter<T> filter, Filterable.Mode mode) {
        switch (mode) {
            case AND: {
                this.ands.addIfAbsent(filter);
                break;
            }
            case OR: {
                this.ors.addIfAbsent(filter);
            }
        }
        this.regenerateFilter();
    }

    @Override
    public boolean removeFilter(Filter<T> filter) {
        if (this.ands.remove(filter) || this.ors.remove(filter)) {
            this.regenerateFilter();
            return true;
        }
        return false;
    }

    @Override
    public boolean matches(T value) {
        return null != this.internalFilter ? this.internalFilter.matches(value) : true;
    }

    private synchronized void regenerateFilter() {
        Filter any = Filter.Instances.acceptsAll();
        Filter and = this.ands.isEmpty() ? any : Filter.Instances.and(Collections.unmodifiableList(this.ands));
        Filter or = this.ors.isEmpty() ? any : Filter.Instances.or(Collections.unmodifiableList(this.ors));
        this.internalFilter = Filter.Instances.and(and, or);
    }

    @Override
    public void setFilter(Filter<T> filter) {
        this.internalFilter = filter;
        this.ands.clear();
        this.ors.clear();
    }

    @Override
    public Filter<T> getFilter() {
        return this.internalFilter;
    }

    public boolean isEmpty() {
        return this.ands.isEmpty() && this.ors.isEmpty();
    }
}

