/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.history;

import java.awt.EventQueue;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import oracle.javatools.history.HistoryModel;
import oracle.javatools.history.HistoryModelEvent;
import oracle.javatools.history.HistoryModelListener;

public abstract class AbstractHistoryModel
implements HistoryModel {
    private List _listenerList;
    private boolean _isComplete = true;
    private List<String> _patterns = new ArrayList<String>();

    protected void fireEntriesInserted(final int start, final int end) {
        if (EventQueue.isDispatchThread()) {
            this.fireEntriesInsertedImpl(start, end);
        } else {
            EventQueue.invokeLater(new Runnable(){

                @Override
                public void run() {
                    AbstractHistoryModel.this.fireEntriesInsertedImpl(start, end);
                }
            });
        }
    }

    private void fireEntriesInsertedImpl(int start, int end) {
        if (this._listenerList != null && !this._listenerList.isEmpty()) {
            ArrayList listCopy = new ArrayList(this._listenerList);
            HistoryModelEvent vhe = new HistoryModelEvent(this, start, end);
            Iterator i = listCopy.iterator();
            while (i.hasNext()) {
                ((HistoryModelListener)i.next()).entriesInserted(vhe);
            }
        }
    }

    protected void fireEntriesRemoved(final int start, final int end) {
        if (EventQueue.isDispatchThread()) {
            this.fireEntriesRemovedImpl(start, end);
        } else {
            EventQueue.invokeLater(new Runnable(){

                @Override
                public void run() {
                    AbstractHistoryModel.this.fireEntriesRemovedImpl(start, end);
                }
            });
        }
    }

    private void fireEntriesRemovedImpl(int start, int end) {
        if (this._listenerList != null && !this._listenerList.isEmpty()) {
            ArrayList listCopy = new ArrayList(this._listenerList);
            HistoryModelEvent vhe = new HistoryModelEvent(this, start, end);
            Iterator i = listCopy.iterator();
            while (i.hasNext()) {
                ((HistoryModelListener)i.next()).entriesRemoved(vhe);
            }
        }
    }

    protected void fireEntriesChanged(final int start, final int end) {
        if (EventQueue.isDispatchThread()) {
            this.fireEntriesChangedImpl(start, end);
        } else {
            EventQueue.invokeLater(new Runnable(){

                @Override
                public void run() {
                    AbstractHistoryModel.this.fireEntriesChangedImpl(start, end);
                }
            });
        }
    }

    private void fireEntriesChangedImpl(int start, int end) {
        if (this._listenerList != null && !this._listenerList.isEmpty()) {
            ArrayList listCopy = new ArrayList(this._listenerList);
            HistoryModelEvent vhe = new HistoryModelEvent(this, start, end);
            Iterator i = listCopy.iterator();
            while (i.hasNext()) {
                ((HistoryModelListener)i.next()).entriesChanged(vhe);
            }
        }
    }

    protected void fireCompletenessChanged() {
        if (EventQueue.isDispatchThread()) {
            this.fireCompletenessChangedImpl();
        } else {
            EventQueue.invokeLater(new Runnable(){

                @Override
                public void run() {
                    AbstractHistoryModel.this.fireCompletenessChangedImpl();
                }
            });
        }
    }

    private void fireCompletenessChangedImpl() {
        if (this._listenerList != null && !this._listenerList.isEmpty()) {
            ArrayList listCopy = new ArrayList(this._listenerList);
            HistoryModelEvent vhe = new HistoryModelEvent(this);
            Iterator i = listCopy.iterator();
            while (i.hasNext()) {
                ((HistoryModelListener)i.next()).completenessChanged(vhe);
            }
        }
    }

    public void setPatterns(String[] patterns) {
        if (patterns.length == 0) {
            return;
        }
        this._patterns.clear();
        this._patterns.addAll(Arrays.asList(patterns));
    }

    @Override
    public void addHistoryModelListener(HistoryModelListener vhl) {
        if (this._listenerList == null) {
            this._listenerList = new ArrayList(1);
        }
        this._listenerList.add(vhl);
    }

    @Override
    public void removeHistoryModelListener(HistoryModelListener vhl) {
        if (this._listenerList != null) {
            this._listenerList.remove(vhl);
            if (this._listenerList.isEmpty()) {
                this._listenerList = null;
            }
        }
    }

    public final synchronized void setComplete(boolean complete) {
        this._isComplete = complete;
        this.fireCompletenessChanged();
    }

    @Override
    public final synchronized boolean isComplete() {
        return this._isComplete;
    }

    public List<String> getPatterns() {
        return this._patterns;
    }
}

