/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.editor.plugins;

import java.awt.Color;
import java.beans.PropertyChangeEvent;
import oracle.javatools.buffer.GuardedTextBuffer;
import oracle.javatools.buffer.GuardedTextBufferListener;
import oracle.javatools.buffer.OffsetRegion;
import oracle.javatools.editor.BasicDocument;
import oracle.javatools.editor.BasicEditorPane;
import oracle.javatools.editor.EditorProperties;
import oracle.javatools.editor.highlight.HighlightLayer;
import oracle.javatools.editor.highlight.HighlightRegistry;
import oracle.javatools.editor.highlight.HighlightStyle;
import oracle.javatools.editor.plugins.EditorPlugin;
import oracle.javatools.resource.BundleHelper;

public final class GuardedHighlightPlugin
implements EditorPlugin {
    public static final String GUARDED_HIGHLIGHT_NAME = "guarded-highlight";
    public static final int DEFAULT_GUARDED_PRIORITY = 90;
    private static HighlightStyle highlightStyle;
    private GuardedTextBuffer guardedBuffer;
    private final Listener listener = new Listener();
    private HighlightLayer highlightLayer;

    @Override
    public void install(BasicEditorPane editor) {
        BasicDocument doc = (BasicDocument)editor.getDocument();
        if (doc.getTextBuffer() instanceof GuardedTextBuffer) {
            this.guardedBuffer = (GuardedTextBuffer)doc.getTextBuffer();
            this.guardedBuffer.addGuardedTextBufferListener((GuardedTextBufferListener)this.listener);
            this.highlightLayer = editor.createHighlightLayer();
            this.updateHighlights();
        }
    }

    @Override
    public void deinstall(BasicEditorPane editor) {
        if (this.guardedBuffer != null) {
            this.guardedBuffer.removeGuardedTextBufferListener((GuardedTextBufferListener)this.listener);
            editor.destroyHighlightLayer(this.highlightLayer);
            this.guardedBuffer = null;
        }
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
    }

    private void updateHighlights() {
        this.highlightLayer.removeAllHighlights();
        for (OffsetRegion region : this.guardedBuffer.getRegions()) {
            int end = region.getEndOffset() + 1;
            int line = this.guardedBuffer.getLineMap().getLineFromOffset(end);
            int lineEnd = this.guardedBuffer.getLineMap().getLineEndOffset(line);
            this.highlightLayer.addHighlight(highlightStyle, region.getStartOffset(), end);
        }
    }

    public static void registerHighlights() {
        EditorProperties properties = EditorProperties.getProperties();
        HighlightRegistry registry = properties.getHighlightRegistry();
        BundleHelper resources = EditorProperties.getEditorBundle();
        String name = resources.getString("GUARDED_HIGHLIGHT");
        highlightStyle = registry.createStyle(GUARDED_HIGHLIGHT_NAME, name, true, 90, null, new Color(230, 230, 230));
    }

    static {
        GuardedHighlightPlugin.registerHighlights();
    }

    private class Listener
    implements GuardedTextBufferListener {
        private Listener() {
        }

        public void guarded(int offset, int length) {
            GuardedHighlightPlugin.this.updateHighlights();
        }

        public void unguarded(int offset, int length) {
            GuardedHighlightPlugin.this.updateHighlights();
        }
    }
}

