/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.editor.language.properties;

import oracle.javatools.editor.EditorProperties;
import oracle.javatools.editor.language.BaseStyle;
import oracle.javatools.editor.language.BuiltInStyles;
import oracle.javatools.editor.language.StyleRegistry;
import oracle.javatools.resource.BundleHelper;

public final class PropertiesStyles {
    public static final String PROPERTIES_COMMENT_STYLE = "properties-comment-style";
    public static final String PROPERTIES_NAME_STYLE = "properties-name-style";
    public static final String PROPERTIES_VALUE_STYLE = "properties-value-style";
    public static final String[] STYLE_NAMES = new String[]{"properties-comment-style", "properties-name-style", "properties-value-style"};
    protected static BaseStyle propertiesPlainStyle;
    protected static BaseStyle propertiesCommentStyle;
    protected static BaseStyle propertiesNameStyle;
    protected static BaseStyle propertiesValueStyle;

    public PropertiesStyles(StyleRegistry styleRegistry) {
        this.reloadStyles(styleRegistry);
    }

    public void reloadStyles(StyleRegistry styleRegistry) {
        String name;
        BundleHelper resources = EditorProperties.getEditorBundle();
        BuiltInStyles builtInStyles = new BuiltInStyles(styleRegistry);
        propertiesPlainStyle = builtInStyles.plainStyle;
        propertiesCommentStyle = styleRegistry.lookupStyle(PROPERTIES_COMMENT_STYLE);
        if (propertiesCommentStyle == null) {
            name = resources.getString("PROPERTIES_COMMENT_STYLE");
            propertiesCommentStyle = styleRegistry.createStyle(PROPERTIES_COMMENT_STYLE, name, "base-comment-style");
        }
        if ((propertiesNameStyle = styleRegistry.lookupStyle(PROPERTIES_NAME_STYLE)) == null) {
            name = resources.getString("PROPERTIES_NAME_STYLE");
            propertiesNameStyle = styleRegistry.createStyle(PROPERTIES_NAME_STYLE, name, "base-attribute-name-style");
        }
        if ((propertiesValueStyle = styleRegistry.lookupStyle(PROPERTIES_VALUE_STYLE)) == null) {
            name = resources.getString("PROPERTIES_VALUE_STYLE");
            propertiesValueStyle = styleRegistry.createStyle(PROPERTIES_VALUE_STYLE, name, "base-attribute-value-style");
        }
    }
}

