/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.editor.language.html;

import oracle.javatools.buffer.TextBuffer;
import oracle.javatools.editor.EditorProperties;
import oracle.javatools.editor.language.BlockRenderer;
import oracle.javatools.editor.language.LanguageModule;
import oracle.javatools.editor.language.LanguageSupport;
import oracle.javatools.editor.language.StyleRegistry;
import oracle.javatools.editor.language.html.HTMLBlockRenderer;
import oracle.javatools.editor.language.html.HTMLLanguageSupport;
import oracle.javatools.editor.language.html.HTMLStyles;
import oracle.javatools.resource.BundleHelper;

public final class HTMLLanguageModule
extends LanguageModule {
    private static final String[] supportedFileTypes = new String[]{"html", "htm", "xml", "dtd", "xsl"};

    @Override
    public String getPresentationName() {
        BundleHelper resources = EditorProperties.getEditorBundle();
        return resources.getString("HTML_MODULE_NAME");
    }

    @Override
    public String[] getStyleNames() {
        return HTMLStyles.STYLE_NAMES;
    }

    @Override
    public String getContentSample() {
        StringBuffer buffer = new StringBuffer();
        buffer.append("<html>\n");
        buffer.append("  <head>\n");
        buffer.append("    <meta HTTP-EQUIV=\"Content-Type\" ");
        buffer.append("CONTENT=\"text/html; charset=WINDOWS-1252\">\n");
        buffer.append("    <title>Oracle JDeveloper 9i</title>\n");
        buffer.append("  </head>\n");
        buffer.append("  <body>\n");
        buffer.append("    <h4>Oracle JDeveloper 9i</h4><p>\n");
        buffer.append("    New features in JDev 9i: <p>\n");
        buffer.append("    <ul type=circle>\n");
        buffer.append("      <li>100% Java IDE </li>\n");
        buffer.append("      <li>Innovative J2EE development and ");
        buffer.append("deployment support </li>\n");
        buffer.append("      <li>Integrated support for Oracle9iAS ");
        buffer.append("Containers for J2EE (OC4J) </li>\n");
        buffer.append("      <li>Integrated UML Class modeler and ");
        buffer.append("Activity modeler </li>\n");
        buffer.append("      <li>Integrated Software Configuration ");
        buffer.append("Management (SCM) </li>\n");
        buffer.append("      <li>Innovative Profiler Tools</li>\n");
        buffer.append("      <li>Enhanced Business Components for ");
        buffer.append("Java (BC4J) </li>\n");
        buffer.append("      <li>Improved JSP support </li>\n");
        buffer.append("      <li>Improved Java clients for BC4J </li>\n");
        buffer.append("      <li>Enhanced database integration ");
        buffer.append("features </li>\n");
        buffer.append("      <li>Enhanced debugging support </li>\n");
        buffer.append("      <li>Powerful code editor and tools </li>\n");
        buffer.append("      <li>Java Addin API for customizing ");
        buffer.append("JDeveloper </li>\n");
        buffer.append("      <li>Enhanced XML support </li>\n");
        buffer.append("    </ul>\n");
        buffer.append("  </body>\n");
        buffer.append("</html>\n");
        return buffer.toString();
    }

    @Override
    public String[] getSupportedFileTypes() {
        return supportedFileTypes;
    }

    @Override
    public void registerStyles(StyleRegistry registry) {
        new HTMLStyles(registry);
    }

    @Override
    public LanguageSupport createLanguageSupport() {
        return new HTMLLanguageSupport();
    }

    @Override
    public BlockRenderer createBlockRenderer(TextBuffer buffer) {
        return new HTMLBlockRenderer(buffer);
    }
}

