/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.editor.language.html;

import java.lang.ref.SoftReference;
import java.util.ArrayList;
import java.util.List;
import oracle.javatools.buffer.ReadTextBuffer;
import oracle.javatools.buffer.TextBuffer;
import oracle.javatools.editor.BasicDocument;
import oracle.javatools.editor.language.AbstractBraceProvider;
import oracle.javatools.editor.language.LanguageSupport;
import oracle.javatools.editor.language.NumberRange;
import oracle.javatools.editor.language.html.HTMLNoEndTagMatcher;
import oracle.javatools.editor.language.html.HTMLNoEndTagMatcherFactory;
import oracle.javatools.parser.Lexer;
import oracle.javatools.parser.LexerToken;
import oracle.javatools.parser.generic.BraceHelper;
import oracle.javatools.parser.html.HTMLLexer;
import oracle.javatools.parser.html.TagLexer;

public class HTMLBraceProvider
extends AbstractBraceProvider {
    private BasicDocument _document;
    private TextBuffer _textBuffer;
    protected HTMLLexer _lexer;
    protected List<BraceArray> _htmlBraceArray;
    private SoftReference<List<BraceArray>> _htmlBraceArrayRef;
    private int _bufferChangeId;
    private boolean _isEndTag;
    private int _tagNameEndOffset;
    private HTMLNoEndTagMatcher _matcher;
    private static HTMLNoEndTagMatcherFactory _factory;
    protected static final int START_TAG = 0;
    protected static final int END_TAG = 1;
    protected static final int SELF_END_TAG = 2;

    public HTMLBraceProvider(LanguageSupport support) {
        this._document = support.getDocument();
        this._textBuffer = this._document.getTextBuffer();
        this._lexer = new HTMLLexer();
        this._lexer.setTextBuffer((ReadTextBuffer)this._textBuffer);
        this._lexer.setPosition(0);
        this._lexer.setSkipComments(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized int isPartOfBrace(int offset, NumberRange braceLocation) {
        if (offset >= this._textBuffer.getLength()) {
            return -1;
        }
        try {
            braceLocation.start = 0;
            braceLocation.end = 0;
            this.buildBraceArray();
            int entry = this.findEntryForOffset(offset);
            if (entry >= 0) {
                int tagType = this._htmlBraceArray.get(entry).getBraceType();
                braceLocation.start = this._htmlBraceArray.get(entry).getStartOffset();
                if (tagType == 0 || tagType == 2) {
                    if (this._htmlBraceArray.get(entry).getTagName() != null) {
                        int tagNameLength = this._htmlBraceArray.get(entry).getTagName().length();
                        int tagLength = this._htmlBraceArray.get(entry).getEndOffset() - braceLocation.start;
                        braceLocation.end = tagLength - tagNameLength <= 2 && tagType == 0 ? braceLocation.start + tagNameLength + 2 : braceLocation.start + tagNameLength + 1;
                    }
                } else if (tagType == 1) {
                    braceLocation.end = this._htmlBraceArray.get(entry).getEndOffset();
                }
                int n = tagType;
                return n;
            }
        }
        finally {
            this._htmlBraceArray = null;
        }
        return -1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized int findMatchingBrace(int braceType, NumberRange braceLocation, NumberRange matchingLocation) {
        int braceOffset = braceLocation.start + (braceLocation.end - braceLocation.start >> 1);
        if (braceOffset < 0 || braceOffset > this._textBuffer.getLength()) {
            throw new IllegalStateException("brace not in buffer");
        }
        try {
            matchingLocation.start = 0;
            matchingLocation.end = 0;
            this.buildBraceArray();
            int startEntry = this.findEntryForOffset(braceOffset);
            if (startEntry < 0) {
                int n = 3;
                return n;
            }
            String tagName = this._htmlBraceArray.get(startEntry).getTagName();
            if (tagName == null) {
                int n = 3;
                return n;
            }
            if (this._htmlBraceArray.get(startEntry).getBraceType() == 2) {
                if (this._htmlBraceArray.get(startEntry).getBraceType() == 1) {
                    int n = 3;
                    return n;
                }
                matchingLocation.start = this._htmlBraceArray.get(startEntry).getEndOffset() - 1;
                matchingLocation.end = this._htmlBraceArray.get(startEntry).getEndOffset();
                int n = 1;
                return n;
            }
            int i = -1;
            int toMatch = 1;
            if (braceType == 0) {
                for (i = startEntry + 1; i < this._htmlBraceArray.size(); ++i) {
                    if (!tagName.equalsIgnoreCase(this._htmlBraceArray.get(i).getTagName())) continue;
                    if (this._htmlBraceArray.get(i).getBraceType() == 0) {
                        ++toMatch;
                        continue;
                    }
                    if (--toMatch != 0) {
                        continue;
                    }
                    break;
                }
            } else if (braceType == 1) {
                for (i = startEntry - 1; i >= 0; --i) {
                    if (!tagName.equalsIgnoreCase(this._htmlBraceArray.get(i).getTagName())) continue;
                    if (this._htmlBraceArray.get(i).getBraceType() == 1) {
                        ++toMatch;
                        continue;
                    }
                    if (--toMatch != 0) {
                        continue;
                    }
                    break;
                }
            }
            if (this._matcher != null && (i == -1 || i == this._htmlBraceArray.size())) {
                int isEndTagRequired = this._matcher.isEndTagRequired(tagName);
                if (braceType == 0 && (isEndTagRequired == 2 || isEndTagRequired == 3) || braceType == 1 && !this._matcher.isStartTagRequired(tagName)) {
                    matchingLocation.start = this._htmlBraceArray.get(startEntry).getEndOffset() - 1;
                    matchingLocation.end = this._htmlBraceArray.get(startEntry).getEndOffset();
                    int n = 1;
                    return n;
                }
                int n = 3;
                return n;
            }
            if (toMatch == 0) {
                if (this._htmlBraceArray.get(i).getBraceType() == 2) {
                    int isEndTagRequired = 3;
                    return isEndTagRequired;
                }
                matchingLocation.start = this._htmlBraceArray.get(i).getStartOffset();
                if (braceType == 0) {
                    matchingLocation.end = this._htmlBraceArray.get(i).getEndOffset();
                } else if (braceType == 1) {
                    int tagLength = this._htmlBraceArray.get(i).getEndOffset() - matchingLocation.start;
                    matchingLocation.end = tagLength - tagName.length() <= 2 ? matchingLocation.start + tagName.length() + 2 : matchingLocation.start + tagName.length() + 1;
                }
                int n = 1;
                return n;
            }
        }
        finally {
            this._htmlBraceArray = null;
        }
        return 3;
    }

    public static synchronized void registerHTMLNoEndTagMatcherFactory(HTMLNoEndTagMatcherFactory noEndTagMatcherFactory) {
        _factory = noEndTagMatcherFactory;
    }

    protected void parseToken(LexerToken htmlToken, int token) {
        switch (token) {
            case 11: {
                String tagName = this.scanTagBlock(htmlToken.getStartOffset());
                if (tagName != null && tagName.length() > 0 && tagName.charAt(tagName.length() - 1) == '/') {
                    String temp = tagName;
                    tagName = temp.substring(0, temp.length() - 1);
                }
                int braceType = this._isEndTag ? 1 : (htmlToken.getEndOffset() - 2 >= 0 && this._textBuffer.getChar(htmlToken.getEndOffset() - 2) == '/' ? 2 : 0);
                this._htmlBraceArray.add(new BraceArray(htmlToken.getStartOffset(), htmlToken.getEndOffset(), this.getTagNameEndOffset(), braceType, tagName));
            }
        }
    }

    @Override
    protected TextBuffer getTextBuffer() {
        return this._textBuffer;
    }

    @Override
    protected BraceHelper getBraceHelper() {
        return null;
    }

    @Override
    protected Lexer getLexer() {
        return this._lexer;
    }

    @Override
    protected boolean isBraceToken(int token) {
        return false;
    }

    @Override
    protected String getBraceCharacters() {
        return null;
    }

    protected int getTagNameEndOffset() {
        return this._tagNameEndOffset;
    }

    protected int getBufferChangeId() {
        return this._bufferChangeId;
    }

    protected int findEntryForOffset(int offset) {
        if (this._htmlBraceArray == null || this._htmlBraceArray.size() == 0) {
            return -1;
        }
        return this.binarySearch(offset);
    }

    private int binarySearch(int offset) {
        int low = 0;
        int high = this._htmlBraceArray.size() - 1;
        while (low <= high) {
            int mid = low + high >> 1;
            int start = this._htmlBraceArray.get(mid).getStartOffset();
            int end = this._htmlBraceArray.get(mid).getEndOffset();
            if (offset >= start && offset < end) {
                return mid;
            }
            if (offset < start) {
                high = mid - 1;
                continue;
            }
            if (offset < end) continue;
            low = mid + 1;
        }
        return -1;
    }

    protected void buildBraceArray() {
        this._initEndTagMatcher();
        if (this._htmlBraceArrayRef != null) {
            this._htmlBraceArray = this._htmlBraceArrayRef.get();
        }
        if (this._htmlBraceArray == null || this._bufferChangeId != this._textBuffer.getChangeId()) {
            this._htmlBraceArray = new ArrayList<BraceArray>();
            this._bufferChangeId = this._textBuffer.getChangeId();
            this._lexer.setPosition(0);
            LexerToken htmlToken = this._lexer.createLexerToken();
            int token = this._lexer.lex(htmlToken);
            while (token != 0) {
                this.parseToken(htmlToken, token);
                token = this._lexer.lex(htmlToken);
            }
            this._htmlBraceArrayRef = new SoftReference<List<BraceArray>>(this._htmlBraceArray);
        }
    }

    protected String scanTagBlock(int startOffset) {
        String tagName = null;
        TagLexer tagLexer = new TagLexer();
        tagLexer.setTextBuffer((ReadTextBuffer)this._textBuffer);
        tagLexer.setPosition(startOffset);
        tagLexer.setSkipSymbols(true);
        tagLexer.setRecognizeJSP(true);
        tagLexer.setRecognizeEmbeddedTags(true);
        LexerToken tagToken = tagLexer.createLexerToken();
        int token = tagLexer.lex(tagToken);
        while (token != 0) {
            if (token == 11) {
                int startOff = tagToken.getStartOffset();
                int length = tagToken.getEndOffset() - startOff;
                if (this._textBuffer.getChar(startOff) != '/') {
                    tagName = this._textBuffer.getString(startOff, length);
                    this._isEndTag = false;
                } else {
                    tagName = this._textBuffer.getString(startOff + 1, length - 1);
                    this._isEndTag = true;
                }
                this._tagNameEndOffset = tagToken.getEndOffset();
                break;
            }
            token = tagLexer.lex(tagToken);
        }
        return tagName;
    }

    private void _initEndTagMatcher() {
        if (_factory != null && this._matcher == null) {
            this._matcher = _factory.getHTMLNoEndTagMatcher(this._document);
        }
    }

    protected static class BraceArray {
        private final int startOffset;
        private final int endOffset;
        private final int tagNameEndOffset;
        private final int braceType;
        private final String tagName;

        public BraceArray(int startOffset, int endOffset, int tagNameEndOffset, int braceType, String tagName) {
            this.startOffset = startOffset;
            this.endOffset = endOffset;
            this.tagNameEndOffset = tagNameEndOffset;
            this.braceType = braceType;
            this.tagName = tagName;
        }

        public int getStartOffset() {
            return this.startOffset;
        }

        public int getEndOffset() {
            return this.endOffset;
        }

        public int getBraceType() {
            return this.braceType;
        }

        public String getTagName() {
            return this.tagName;
        }

        public int getTagNameEndOffset() {
            return this.tagNameEndOffset;
        }
    }
}

