/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.editor.language.css;

import java.util.List;
import oracle.javatools.buffer.TextBuffer;
import oracle.javatools.editor.language.LexerBlockRenderer;
import oracle.javatools.editor.language.StyledFragmentsList;
import oracle.javatools.parser.css.CSSRuleTokens;

public abstract class CSSBaseRenderer
extends LexerBlockRenderer
implements CSSRuleTokens {
    private List<int[]> _commentOffsetList;

    public CSSBaseRenderer(TextBuffer textBuffer) {
        super(textBuffer);
    }

    @Override
    protected void renderToken(StyledFragmentsList fragmentsList, int token, int tokenStart, int tokenEnd, int clipStart, int clipEnd) {
        if (token == 18 && tokenEnd > clipEnd) {
            this.addToCommentOffsets(tokenStart, tokenEnd);
        }
        tokenStart = Math.max(clipStart, tokenStart);
        tokenEnd = Math.min(clipEnd, tokenEnd);
        String tokenStyleName = null;
        tokenStyleName = this.isInsideComment(tokenStart, tokenEnd) ? this.mapTokenToStyleName(18) : this.mapTokenToStyleName(token);
        if (tokenStart < tokenEnd) {
            fragmentsList.add(tokenStyleName, tokenStart, tokenEnd);
        }
    }

    protected void setCommentOffsetList(List<int[]> list) {
        this._commentOffsetList = list;
    }

    protected List<int[]> getCommentOffsetList() {
        return this._commentOffsetList;
    }

    private void addToCommentOffsets(int start, int end) {
        if (this._commentOffsetList == null) {
            return;
        }
        for (int[] offset : this._commentOffsetList) {
            if (offset[0] != start || offset[1] != end) continue;
            return;
        }
        this._commentOffsetList.add(new int[]{start, end});
    }

    private boolean isInsideComment(int start, int end) {
        if (this._commentOffsetList == null || this._commentOffsetList.isEmpty()) {
            return false;
        }
        for (int[] offset : this._commentOffsetList) {
            if (offset[0] > start || start >= offset[1] || offset[1] < end || end <= offset[0]) continue;
            return true;
        }
        return false;
    }
}

