/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.editor.language;

import oracle.javatools.buffer.TextBuffer;
import oracle.javatools.editor.BasicDocument;
import oracle.javatools.editor.BasicEditorPane;
import oracle.javatools.editor.language.LanguageSupport;

public abstract class SmartIndentProvider {
    protected LanguageSupport support;

    protected SmartIndentProvider(LanguageSupport support) {
        this.support = support;
    }

    protected final TextBuffer getTextBuffer() {
        BasicDocument document = this.getDocument();
        TextBuffer textBuffer = document.getTextBuffer();
        return textBuffer;
    }

    protected final BasicDocument getDocument() {
        BasicDocument document = this.support.getDocument();
        return document;
    }

    protected final String getUseSmartIndentPropertyName() {
        return "use-smart-indent";
    }

    public final boolean isSmartIndentEnabled(BasicEditorPane editor) {
        String name = this.getUseSmartIndentPropertyName();
        Object value = editor.getProperty(name);
        if (value != null && value instanceof Boolean) {
            return (Boolean)value;
        }
        return false;
    }

    public boolean shouldAutoReindentOldLine() {
        return false;
    }

    public boolean shouldAutoIndentNewLine() {
        return true;
    }

    public abstract boolean isAutoReindentTriggerChar(char var1);

    public abstract int getIndentForLine(int var1, int var2);
}

