/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.editor.find;

import java.awt.Component;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.SwingUtilities;
import javax.swing.event.AncestorEvent;
import javax.swing.event.AncestorListener;
import javax.swing.text.BadLocationException;
import oracle.bali.ewt.button.ButtonBar;
import oracle.bali.share.nls.StringUtils;
import oracle.javatools.editor.BasicEditorPane;
import oracle.javatools.editor.find.Find;
import oracle.javatools.editor.find.FindBundle;
import oracle.javatools.ui.ghost.GhostPalette;
import oracle.javatools.ui.ghost.GhostPointingPalette;
import oracle.javatools.ui.ghost.UIConstants;

final class ReplacePrompt {
    private final GhostPalette gp;
    private final Find find;
    private final Listener listener = new Listener();
    private JButton btnAll;
    private JButton btnNo;
    private JButton btnYes;
    private JLabel feedbackLabel = new JLabel(FindBundle.format("FEEDBACK_REPLACE_PROMPT", 100, 100, 100));
    private CopyOnWriteArrayList<ActionListener> actionListeners;
    static final String CHOICE_YES = "YES";
    static final String CHOICE_NO = "NO";
    static final String CHOICE_ALL = "GLOBAL";
    static final String CHOICE_CANCEL = "CANCEL";

    public ReplacePrompt(BasicEditorPane editor, Find find, int offsetAdjustment) {
        this.feedbackLabel.setFont(this.feedbackLabel.getFont().deriveFont(9.0f));
        this.feedbackLabel.setHorizontalAlignment(11);
        this.feedbackLabel.setBorder(BorderFactory.createEmptyBorder(2, 0, 0, 0));
        this.actionListeners = new CopyOnWriteArrayList();
        this.find = find;
        editor.select(find.getStartOffset() + offsetAdjustment, find.getEndOffset() + offsetAdjustment);
        editor.ensureCaretVisible();
        String text = FindBundle.get("FD_BUTTON_YES");
        this.btnYes = new JButton(StringUtils.stripMnemonic((String)text));
        this.btnYes.setActionCommand(CHOICE_YES);
        this.btnYes.setMnemonic(StringUtils.getMnemonicKeyCode((String)text));
        text = FindBundle.get("FD_BUTTON_NO");
        this.btnNo = new JButton(StringUtils.stripMnemonic((String)text));
        this.btnNo.setActionCommand(CHOICE_NO);
        this.btnNo.setMnemonic(StringUtils.getMnemonicKeyCode((String)text));
        text = FindBundle.get("FD_BUTTON_GLOBAL");
        this.btnAll = new JButton(StringUtils.stripMnemonic((String)text));
        this.btnAll.setActionCommand(CHOICE_ALL);
        this.btnAll.setMnemonic(StringUtils.getMnemonicKeyCode((String)text));
        this.btnAll.setMargin(new Insets(0, 2, 0, 2));
        ButtonBar bb = new ButtonBar();
        bb.add((Component)this.btnYes);
        bb.add((Component)this.btnNo);
        bb.add((Component)this.btnAll);
        bb.putClientProperty((Object)UIConstants.VETO_HIERARCHY_CONVERSION, (Object)true);
        this.gp = new GhostPointingPalette();
        this.gp.setTitle(FindBundle.get("FD_REPLACE_DIALOG_TITLE"));
        this.gp.add((Component)bb, (Object)"Center");
        this.gp.add((Component)this.feedbackLabel, (Object)"South");
        this.gp.setCloseVisible(true);
        this.gp.setResizable(false);
        this.gp.setLook(UIConstants.Look.DARK);
        this.gp.setOwningComponent((JComponent)editor);
        this.gp.allowTemporaryHide();
        this.btnYes.addActionListener(this.listener);
        this.btnNo.addActionListener(this.listener);
        this.btnAll.addActionListener(this.listener);
        this.gp.addAncestorListener((AncestorListener)this.listener);
        try {
            int s = editor.getSelectionStart();
            int e = editor.getSelectionEnd();
            Rectangle sRectangle = editor.modelToView(s);
            Rectangle eRectangle = editor.modelToView(e - 1);
            sRectangle.add(eRectangle);
            Window w = SwingUtilities.windowForComponent(editor);
            Rectangle r = SwingUtilities.convertRectangle(editor, sRectangle, w);
            ((GhostPointingPalette)this.gp).setPointing((JComponent)editor, sRectangle);
            this.gp.pack();
            int x = r.x + r.width / 2 - this.gp.getWidth() / 2;
            int y = r.y + r.height + 15;
            this.gp.setLocation(x, y);
            this.gp.setHideOnLoseFocus(true);
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    ReplacePrompt.this.gp.show(false, false);
                }
            });
        }
        catch (BadLocationException e) {
            Logger.getLogger("global").log(Level.SEVERE, e.getLocalizedMessage());
        }
    }

    Find getFind() {
        return this.find;
    }

    void addActionListener(ActionListener listener) {
        this.actionListeners.add(listener);
    }

    void removeActionListener(ActionListener listener) {
        this.actionListeners.remove(listener);
    }

    void setFeedback(String text) {
        this.feedbackLabel.setText(text);
        this.gp.pack();
    }

    private class Listener
    implements ActionListener,
    AncestorListener {
        private Listener() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            this.stopListening();
            ReplacePrompt.this.gp.hidePanel();
            ActionEvent actionEvent = new ActionEvent(ReplacePrompt.this, 1001, e.getActionCommand());
            this.fireActionPerformed(actionEvent);
        }

        private void fireActionPerformed(ActionEvent actionEvent) {
            for (ActionListener l : ReplacePrompt.this.actionListeners) {
                l.actionPerformed(actionEvent);
            }
        }

        private void stopListening() {
            ReplacePrompt.this.gp.removeAncestorListener((AncestorListener)this);
            ReplacePrompt.this.btnAll.removeActionListener(this);
            ReplacePrompt.this.btnNo.removeActionListener(this);
            ReplacePrompt.this.btnYes.removeActionListener(this);
        }

        @Override
        public void ancestorAdded(AncestorEvent event) {
        }

        @Override
        public void ancestorRemoved(AncestorEvent event) {
            this.stopListening();
            ActionEvent actionEvent = new ActionEvent(ReplacePrompt.this, 1001, ReplacePrompt.CHOICE_CANCEL);
            this.fireActionPerformed(actionEvent);
        }

        @Override
        public void ancestorMoved(AncestorEvent event) {
        }
    }
}

