/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.editor.find;

import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.List;
import oracle.javatools.buffer.OffsetMark;
import oracle.javatools.buffer.TextBuffer;

public final class Find {
    private final WeakReference<TextBuffer> textBufferRef;
    private final OffsetMark startOffset;
    private final OffsetMark endOffset;
    private boolean disposed = false;
    private List<Group> groups;

    Find(TextBuffer textBuffer, int startOffset, int endOffset) {
        this.textBufferRef = new WeakReference<TextBuffer>(textBuffer);
        this.startOffset = textBuffer.addOffsetMark(startOffset, false);
        this.endOffset = textBuffer.addOffsetMark(endOffset, true);
    }

    void dispose() {
        TextBuffer textBuffer = (TextBuffer)this.textBufferRef.get();
        if (textBuffer != null) {
            textBuffer.removeOffsetMark(this.startOffset);
            textBuffer.removeOffsetMark(this.endOffset);
        }
        this.disposed = true;
    }

    protected void finalize() throws Throwable {
        assert (this.disposed);
        super.finalize();
    }

    public int getStartOffset() {
        return this.startOffset.getOffset();
    }

    public int getEndOffset() {
        return this.endOffset.getOffset();
    }

    final void addGroup(String text, int start, int end) {
        if (this.groups == null) {
            this.groups = new ArrayList<Group>();
        }
        Group group = new Group(text, start, end);
        this.groups.add(group);
    }

    final List<Group> getGroups() {
        return this.groups;
    }

    public String toString() {
        TextBuffer tb = (TextBuffer)this.textBufferRef.get();
        if (tb != null) {
            return "" + this.getStartOffset() + ":" + this.getEndOffset();
        }
        return "" + this.getStartOffset() + ":" + this.getEndOffset() + "\"" + tb.getString(this.getStartOffset(), this.getEndOffset() - this.getStartOffset()) + "\"";
    }

    static class Group {
        final String text;
        final int start;
        final int end;

        Group(String text, int start, int end) {
            this.text = text;
            this.start = start;
            this.end = end;
        }
    }
}

