/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.editor;

public class Selection
implements Comparable<Selection> {
    private final int dot;
    private final int mark;

    public Selection(int dot, int mark) {
        this.dot = dot;
        this.mark = mark;
    }

    public int getDot() {
        return this.dot;
    }

    public int getMark() {
        return this.mark;
    }

    public int getStart() {
        return Math.min(this.getDot(), this.getMark());
    }

    public int getEnd() {
        return Math.max(this.getDot(), this.getMark());
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof Selection)) {
            return false;
        }
        Selection that = (Selection)obj;
        return this.dot == that.dot && this.mark == that.mark;
    }

    public String toString() {
        return "" + this.getDot() + "," + this.getMark();
    }

    @Override
    public int compareTo(Selection o) {
        if (this.getStart() < o.getStart()) {
            return -1;
        }
        if (this.getStart() > o.getStart()) {
            return 1;
        }
        if (this.getEnd() < o.getEnd()) {
            return -1;
        }
        if (this.getEnd() > o.getEnd()) {
            return 1;
        }
        return 0;
    }
}

