/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.editor;

import java.util.Arrays;
import java.util.Comparator;
import javax.swing.event.DocumentEvent;
import oracle.javatools.editor.folding.CodeFoldingModel;

class FoldedCollapsedBlocks {
    protected int[] _blockStarts;
    protected int[] _blockEnds;
    protected String[] _blockTexts;
    protected Object[] _blocks;
    protected int _numBlocks;
    protected CodeFoldingModel _model;
    protected final int[] TEMP_OFFSETS = new int[2];

    protected FoldedCollapsedBlocks(CodeFoldingModel model) {
        this._model = model;
        if (model != null) {
            this.buildList(model);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void buildList(CodeFoldingModel model) {
        model.readLock();
        try {
            B[] collapsedBlocks = model.getCollapsedBlocks();
            Arrays.sort(collapsedBlocks, new BlockSorter(model));
            int count = collapsedBlocks.length;
            this.initializeCapacity(count);
            for (int i = 0; i < count; ++i) {
                Object block = collapsedBlocks[i];
                this.addBlock(model, block);
            }
        }
        finally {
            model.readUnlock();
        }
    }

    protected void initializeCapacity(int capacity) {
        this._blockStarts = new int[capacity];
        this._blockEnds = new int[capacity];
        this._blockTexts = new String[capacity];
        this._blocks = new Object[capacity];
    }

    protected void ensureCapacity() {
        int neededCapacity = this._numBlocks + 1;
        int currentCapacity = this._blocks != null ? this._blocks.length : 0;
        if (neededCapacity > currentCapacity) {
            int increment = (int)((float)neededCapacity * 0.1f);
            increment = Math.min(500, increment);
            increment = Math.max(25, increment);
            int newCapacity = increment + neededCapacity;
            int[] newStarts = new int[newCapacity];
            int[] newEnds = new int[newCapacity];
            String[] newTexts = new String[newCapacity];
            Object[] newBlocks = new Object[newCapacity];
            if (this._numBlocks > 0) {
                System.arraycopy(this._blockStarts, 0, newStarts, 0, this._numBlocks);
                System.arraycopy(this._blockEnds, 0, newEnds, 0, this._numBlocks);
                System.arraycopy(this._blockTexts, 0, newTexts, 0, this._numBlocks);
                System.arraycopy(this._blocks, 0, newBlocks, 0, this._numBlocks);
            }
            this._blockStarts = newStarts;
            this._blockEnds = newEnds;
            this._blockTexts = newTexts;
            this._blocks = newBlocks;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean insertUpdate(DocumentEvent event) {
        if (this._model == null) {
            return false;
        }
        int offset = event.getOffset();
        int length = event.getLength();
        this._model.readLock();
        try {
            for (int i = 0; i < this._numBlocks; ++i) {
                if (offset <= this._blockStarts[i]) {
                    int n = i;
                    this._blockStarts[n] = this._blockStarts[n] + length;
                }
                if (offset < this._blockEnds[i]) {
                    int n = i;
                    this._blockEnds[n] = this._blockEnds[n] + length;
                }
                Object originalBlock = this._blocks[i];
                boolean isExpanded = this._model.isExpanded(originalBlock);
                this._model.getTextOffsets(originalBlock, this.TEMP_OFFSETS);
                int startOffset = this.TEMP_OFFSETS[0];
                int endOffset = this.TEMP_OFFSETS[1];
                if (!isExpanded && startOffset == this._blockStarts[i] && endOffset == this._blockEnds[i]) continue;
                boolean bl = false;
                return bl;
            }
        }
        finally {
            this._model.readUnlock();
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean removeUpdate(DocumentEvent event) {
        if (this._model == null) {
            return false;
        }
        int offset = event.getOffset();
        int length = event.getLength();
        int removeEnd = offset + length;
        this._model.readLock();
        try {
            for (int i = 0; i < this._numBlocks; ++i) {
                if (this._blockStarts[i] >= removeEnd) {
                    int n = i;
                    this._blockStarts[n] = this._blockStarts[n] - length;
                } else if (this._blockStarts[i] > offset) {
                    this._blockStarts[i] = offset;
                }
                if (this._blockEnds[i] >= removeEnd) {
                    int n = i;
                    this._blockEnds[n] = this._blockEnds[n] - length;
                } else if (this._blockEnds[i] > offset) {
                    this._blockEnds[i] = offset;
                }
                Object originalBlock = this._blocks[i];
                boolean isExpanded = this._model.isExpanded(originalBlock);
                this._model.getTextOffsets(originalBlock, this.TEMP_OFFSETS);
                int startOffset = this.TEMP_OFFSETS[0];
                int endOffset = this.TEMP_OFFSETS[1];
                if (!isExpanded && startOffset == this._blockStarts[i] && endOffset == this._blockEnds[i]) continue;
                boolean bl = false;
                return bl;
            }
        }
        finally {
            this._model.readUnlock();
        }
        return true;
    }

    protected void addBlock(CodeFoldingModel model, Object collapsedBlock) {
        this._model.getTextOffsets(collapsedBlock, this.TEMP_OFFSETS);
        int startOffset = this.TEMP_OFFSETS[0];
        int endOffset = this.TEMP_OFFSETS[1];
        if (startOffset == endOffset) {
            return;
        }
        this.ensureCapacity();
        this._blocks[this._numBlocks] = collapsedBlock;
        this._blockStarts[this._numBlocks] = startOffset;
        this._blockEnds[this._numBlocks] = endOffset;
        this._blockTexts[this._numBlocks] = model.getAbbreviatedText(collapsedBlock);
        ++this._numBlocks;
    }

    public boolean equals(Object object) {
        if (object instanceof FoldedCollapsedBlocks) {
            FoldedCollapsedBlocks blocks1 = this;
            int count1 = blocks1._numBlocks;
            FoldedCollapsedBlocks blocks2 = (FoldedCollapsedBlocks)object;
            int count2 = blocks2._numBlocks;
            if (count1 == count2 && this.equals(blocks1._blockStarts, blocks2._blockStarts, count1) && this.equals(blocks1._blockEnds, blocks2._blockEnds, count1) && this.equals(blocks1._blockTexts, blocks2._blockTexts, count1)) {
                return true;
            }
        }
        return false;
    }

    protected boolean equals(int[] a1, int[] a2, int count) {
        for (int i = count - 1; i >= 0; --i) {
            if (a1[i] == a2[i]) continue;
            return false;
        }
        return true;
    }

    protected boolean equals(String[] s1, String[] s2, int count) {
        for (int i = count - 1; i >= 0; --i) {
            if (s1[i].equals(s2[i])) continue;
            return false;
        }
        return true;
    }

    protected static class BlockSorter
    implements Comparator {
        protected final int[] TEMP_SORT_OFFSETS = new int[2];
        private CodeFoldingModel _model;

        protected BlockSorter(CodeFoldingModel model) {
            this._model = model;
        }

        public int compare(Object obj1, Object obj2) {
            this._model.getTextOffsets(obj1, this.TEMP_SORT_OFFSETS);
            int start1 = this.TEMP_SORT_OFFSETS[0];
            int end1 = this.TEMP_SORT_OFFSETS[1];
            this._model.getTextOffsets(obj2, this.TEMP_SORT_OFFSETS);
            int start2 = this.TEMP_SORT_OFFSETS[0];
            int end2 = this.TEMP_SORT_OFFSETS[1];
            if (start1 <= start2 && start2 < end1 || start1 < end2 && end2 <= end1 || start2 <= start1 && start1 < end2 || start2 < end1 && end1 <= end2) {
                throw new IllegalStateException("nested or overlapping blocks,  s1 = " + start1 + " e1 = " + end1 + " s2 = " + start2 + " e2 = " + end2);
            }
            return start1 - start2;
        }

        @Override
        public boolean equals(Object obj) {
            return obj instanceof BlockSorter && this._model == ((BlockSorter)obj)._model;
        }
    }
}

