/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.editor;

import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.Shape;
import java.awt.Toolkit;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.swing.SwingUtilities;
import javax.swing.event.DocumentEvent;
import javax.swing.text.BadLocationException;
import javax.swing.text.Element;
import javax.swing.text.Position;
import javax.swing.text.Segment;
import javax.swing.text.View;
import javax.swing.text.ViewFactory;
import oracle.javatools.buffer.ExpiredTextBufferException;
import oracle.javatools.buffer.LineMap;
import oracle.javatools.buffer.TextBuffer;
import oracle.javatools.editor.BasicDocument;
import oracle.javatools.editor.BasicEditorPane;
import oracle.javatools.editor.FoldedRowMap;
import oracle.javatools.editor.FontHelper;
import oracle.javatools.editor.folding.CodeExpansionEvent;
import oracle.javatools.editor.folding.CodeFoldingMargin;
import oracle.javatools.editor.folding.CodeFoldingModel;
import oracle.javatools.editor.folding.CodeFoldingModelEvent;
import oracle.javatools.editor.folding.CodeFoldingModelListener;
import oracle.javatools.editor.folding.CompoundCodeExpansionListener;
import oracle.javatools.editor.highlight.HighlightFragment;
import oracle.javatools.editor.highlight.HighlightFragmentsList;
import oracle.javatools.editor.highlight.HighlightLayer;
import oracle.javatools.editor.highlight.HighlightRegistry;
import oracle.javatools.editor.highlight.HighlightStyle;
import oracle.javatools.editor.highlight.UnderlinePainter;
import oracle.javatools.editor.language.BaseStyle;
import oracle.javatools.editor.language.DocumentRenderer;
import oracle.javatools.editor.language.DocumentRenderer2;
import oracle.javatools.editor.language.NumberRange;
import oracle.javatools.editor.language.StyleRegistry;
import oracle.javatools.editor.language.StyledFragmentsList;
import oracle.javatools.util.Log;

public final class BasicView
extends View
implements PropertyChangeListener {
    private BasicEditorPane _editor = null;
    private BasicDocument _document;
    private TextBuffer _textBuffer;
    private LineMap _lineMap;
    private Segment _lineBuffer;
    private CodeFoldingModel _foldingModel;
    private CodeFoldingMargin _foldingMargin;
    private NumberRange _lineRange;
    private Color _editorBackgroundColor;
    private FontHelper _fontHelper = null;
    private StyleRegistry _styleRegistry = null;
    private HighlightRegistry _highlightRegistry = null;
    private Font _font;
    private FontMetrics _metrics;
    private int _fontHeight;
    private int _fontAscent;
    private int _fontDescent;
    private int _fontWidth;
    private int _numberRows;
    private int _tabSize;
    private int _composedStart = -1;
    private int _composedEnd = -1;
    private FoldedRowMap _rowMap = null;
    private boolean _useAA = false;
    private Map _renderingHints;
    private boolean _showWhitespace = false;
    private Color _whitespaceColor = Color.lightGray;
    private Map<Object, Integer> foldedBlockUnderlines = new HashMap<Object, Integer>();
    private static final int LONG_ROW_LENGTH = 5000;
    private static final int[] PAINTER_TYPE_ORDER = new int[]{0, 1, 2};
    private int[] blockOffsets = new int[2];
    private FoldingListener _foldingListener = new FoldingListener();
    private Damage damage;
    private static final Log LOG = new Log("compound-edit");
    private static final int HIGHLIGHT_ARRAY_SIZE = 5;
    private static HighlightFragmentsList[] sharedHighlightArray = new HighlightFragmentsList[5];
    private static char WHITESPACE_CR_REPLACEMENT = (char)171;
    private static char[] WHITESPACE_CR_REPLACEMENT_ARRAY = new char[]{WHITESPACE_CR_REPLACEMENT};
    private static char WHITESPACE_LF_REPLACEMENT = (char)182;
    private static char[] WHITESPACE_LF_REPLACEMENT_ARRAY = new char[]{WHITESPACE_LF_REPLACEMENT};
    private static char WHITESPACE_TAB_REPLACEMENT = (char)187;
    private static char[] WHITESPACE_TAB_REPLACEMENT_ARRAY = new char[]{WHITESPACE_TAB_REPLACEMENT};
    private static char WHITESPACE_SPACE_REPLACEMENT = (char)183;
    private static char[] WHITESPACE_SPACE_REPLACEMENT_ARRAY = new char[]{WHITESPACE_SPACE_REPLACEMENT};
    private static char WHITESPACE_NBSP_REPLACEMENT = (char)160;
    private static char[] WHITESPACE_NBSP_REPLACEMENT_ARRAY = new char[]{WHITESPACE_NBSP_REPLACEMENT};

    public BasicView(Element elem) {
        super(elem);
        this._document = (BasicDocument)this.getDocument();
        this._textBuffer = this._document.getTextBuffer();
        this._lineMap = this._document.getLineMap();
        this._lineBuffer = new Segment();
        this._lineRange = new NumberRange(0, 0);
        this.updateRenderingHints();
    }

    DocumentRenderer getDocumentRenderer() {
        return this._document.getDocumentRenderer();
    }

    @Override
    public void paint(Graphics graphics, Shape viewShape) {
        try {
            graphics = graphics.create();
            this.updateMetrics();
            Rectangle originalViewRect = (Rectangle)viewShape;
            graphics.translate(originalViewRect.x, originalViewRect.y);
            int viewWidth = originalViewRect.width;
            int viewHeight = originalViewRect.height;
            Rectangle viewRect = new Rectangle(0, 0, viewWidth, viewHeight);
            this.attachToRegistries();
            NumberRange composedRange = this._document.getComposedTextRange();
            if (composedRange != null) {
                this._composedStart = composedRange.start;
                this._composedEnd = composedRange.end;
            } else {
                this._composedStart = -1;
                this._composedEnd = -1;
            }
            boolean paintText = true;
            Rectangle clipRect = graphics.getClipBounds();
            if (!clipRect.intersects(viewRect)) {
                paintText = false;
            }
            clipRect = clipRect.intersection(viewRect);
            int clipYTop = clipRect.y;
            int clipYBottom = clipRect.height + clipRect.y;
            int lastRow = this._numberRows - 1;
            int fontHeight = this._fontHeight == 0 ? 1 : this._fontHeight;
            int rowStart = clipYTop / fontHeight;
            int rowEnd = clipYBottom / fontHeight;
            rowStart = Math.min(rowStart, lastRow);
            rowEnd = Math.min(rowEnd, lastRow);
            int lastRowEdge = this._numberRows * this._fontHeight;
            if (lastRowEdge <= clipRect.y) {
                paintText = false;
            }
            if (paintText) {
                int longestRow = this.getLongestRow(rowStart, rowEnd);
                if (longestRow < 5000) {
                    this.paintOffsetsByLine(graphics, clipRect, rowStart, rowEnd);
                } else {
                    this.paintOffsetsByRow(graphics, clipRect, rowStart, rowEnd);
                }
            }
            this.paintRightMargin(graphics, clipRect);
            graphics.translate(-originalViewRect.x, -originalViewRect.y);
        }
        catch (ExpiredTextBufferException expiredTextBufferException) {
            // empty catch block
        }
    }

    private void paintOffsetsByLine(Graphics graphics, Rectangle clipRect, int rowStart, int rowEnd) {
        DocumentRenderer documentRenderer = this.getDocumentRenderer();
        int paintStartOffset = this._rowMap.getRowStartOffset(rowStart);
        int paintEndOffset = this._rowMap.getRowEndOffset(rowEnd);
        int paintStartLine = this._lineMap.getLineFromOffset(paintStartOffset);
        int paintEndLine = this._lineMap.getLineFromOffset(paintEndOffset);
        StyledFragmentsList fragmentsList = documentRenderer.renderLines(paintStartLine, paintEndLine);
        HighlightFragmentsList textHighlightFragmentsList = this.renderTextHighlights(paintStartOffset, paintEndOffset);
        RenderFragmentGenerator generator = this._rowMap.createRenderFragmentGenerator(fragmentsList, textHighlightFragmentsList);
        Graphics2D graphics2d = (Graphics2D)graphics;
        if (this._useAA) {
            graphics2d.setRenderingHints(this._renderingHints);
        }
        for (int row = rowStart; row <= rowEnd; ++row) {
            this.paintRow(graphics, clipRect, row, generator, textHighlightFragmentsList.getSentinelBackground());
        }
        this.paintUnderlines(graphics, clipRect, fragmentsList, rowStart, rowEnd + 1);
        if (fragmentsList != null) {
            documentRenderer.recycleFragmentsList(fragmentsList);
        }
        BasicView.freeHighlightFragmentsList(textHighlightFragmentsList);
    }

    private void paintOffsetsByRow(Graphics graphics, Rectangle clipRect, int rowStart, int rowEnd) {
        DocumentRenderer documentRenderer = this.getDocumentRenderer();
        for (int row = rowStart; row <= rowEnd; ++row) {
            int paintStartOffset = this._rowMap.getRowStartOffset(row);
            int paintEndOffset = this._rowMap.getRowEndOffset(row);
            int firstVisibleRowOffset = this.getOffsetForXCoordinate(row, clipRect.x);
            int lastVisibleRowOffset = this.getOffsetForXCoordinate(row, clipRect.x + clipRect.width) + 1;
            paintStartOffset = Math.max(paintStartOffset, firstVisibleRowOffset);
            paintEndOffset = Math.min(paintEndOffset, lastVisibleRowOffset);
            int paintStartLine = this._lineMap.getLineFromOffset(paintStartOffset);
            int paintEndLine = this._lineMap.getLineFromOffset(paintEndOffset);
            StyledFragmentsList fragmentsList = documentRenderer instanceof DocumentRenderer2 ? ((DocumentRenderer2)documentRenderer).renderOffets(paintStartOffset, paintEndOffset) : documentRenderer.renderLines(paintStartLine, paintEndLine);
            HighlightFragmentsList textHighlightFragmentsList = this.renderTextHighlights(paintStartOffset, paintEndOffset);
            RenderFragmentGenerator generator = this._rowMap.createRenderFragmentGenerator(fragmentsList, textHighlightFragmentsList);
            Graphics2D graphics2d = (Graphics2D)graphics;
            if (this._useAA) {
                graphics2d.setRenderingHints(this._renderingHints);
            }
            this.paintRow(graphics, clipRect, row, generator, textHighlightFragmentsList.getSentinelBackground());
            this.paintUnderlineOffsets(graphics, clipRect, fragmentsList, paintStartOffset, paintEndOffset);
            if (fragmentsList != null) {
                documentRenderer.recycleFragmentsList(fragmentsList);
            }
            BasicView.freeHighlightFragmentsList(textHighlightFragmentsList);
        }
    }

    private void updateRenderingHints() {
        Toolkit tk = Toolkit.getDefaultToolkit();
        Map map = (Map)tk.getDesktopProperty("awt.font.desktophints");
        if (map != null) {
            Object aaValue = map.get(RenderingHints.KEY_TEXT_ANTIALIASING);
            if (!RenderingHints.VALUE_ANTIALIAS_OFF.equals(aaValue)) {
                this._renderingHints = map;
            }
        } else {
            this._renderingHints = new RenderingHints(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
        }
    }

    protected void paintUnderlines(Graphics graphics, Rectangle clipRect, StyledFragmentsList styledList, int startRow, int endRow) {
        int paintStartOffset = this._rowMap.getRowStartOffset(startRow);
        int paintEndOffset = this._rowMap.getRowEndOffset(endRow - 1);
        this.paintUnderlineOffsets(graphics, clipRect, styledList, paintStartOffset, paintEndOffset);
    }

    private void paintUnderlineOffsets(Graphics graphics, Rectangle clipRect, StyledFragmentsList styledList, int paintStartOffset, int paintEndOffset) {
        this.paintLineUnderlines(graphics, clipRect, paintStartOffset, paintEndOffset);
        if (styledList == null) {
            return;
        }
        HighlightFragmentsList fontHighlightList = this.renderFontHighlights(paintStartOffset, paintEndOffset);
        this.paintRangeUnderlines(graphics, clipRect, styledList, fontHighlightList, paintStartOffset, paintEndOffset);
    }

    protected void paintLineUnderlines(Graphics graphics, Rectangle clipRect, int startOffset, int endOffset) {
        int clipXEnd = clipRect.x + clipRect.width;
        int lastLine = this._lineMap.getLineCount() - 1;
        for (int underlineType : PAINTER_TYPE_ORDER) {
            HighlightFragmentsList underlineList = this.renderUnderlineHighlights(underlineType, true, startOffset, endOffset);
            int numUnderlines = underlineList.size();
            for (int i = 0; i < numUnderlines; ++i) {
                int line;
                HighlightFragment fragment = underlineList.get(i);
                HighlightStyle highlightStyle = fragment.underlineStyle;
                if (highlightStyle == null) continue;
                UnderlinePainter underlinePainter = highlightStyle.getUnderlinePainter();
                Color underlineColor = highlightStyle.getUnderlineColor();
                if (underlinePainter == null || underlineColor == null || this._rowMap.isLineCollapsed(line = this._lineMap.getLineFromOffset(fragment.startOffset))) continue;
                int lineEnd = this._lineMap.getLineEndOffset(line);
                if (line != lastLine) {
                    --lineEnd;
                }
                int row = this._rowMap.getRowFromOffset(lineEnd);
                int yPos = this._fontHeight * row;
                int yBaseLine = yPos + this._fontAscent;
                underlinePainter.paintUnderline(graphics, underlineColor, 0, clipXEnd, yPos, yBaseLine, this._fontDescent);
            }
            HighlightStyle trailingUnderlineStyle = underlineList.getSentinelUnderline();
            if (trailingUnderlineStyle != null && trailingUnderlineStyle.getUseUnderline()) {
                UnderlinePainter underlinePainter = trailingUnderlineStyle.getUnderlinePainter();
                Color underlineColor = trailingUnderlineStyle.getUnderlineColor();
                int lastRow = this._numberRows - 1;
                int yPos = this._fontHeight * lastRow;
                int yBaseLine = yPos + this._fontAscent;
                underlinePainter.paintUnderline(graphics, underlineColor, 0, clipXEnd, yPos, yBaseLine, this._fontDescent);
            }
            BasicView.freeHighlightFragmentsList(underlineList);
        }
    }

    protected void paintRangeUnderlines(Graphics graphics, Rectangle clipRect, StyledFragmentsList styledList, HighlightFragmentsList fontHighlightList, int startOffset, int endOffset) {
        for (int underlineType : PAINTER_TYPE_ORDER) {
            HighlightFragmentsList underlineList = this.renderUnderlineHighlights(underlineType, false, startOffset, endOffset);
            int numUnderlines = underlineList.size();
            this.foldedBlockUnderlines.clear();
            for (int i = 0; i < numUnderlines; ++i) {
                HighlightFragment fragment = underlineList.get(i);
                PaintResult paintResult = this.paintUnderlineSegment(graphics, clipRect, styledList, fontHighlightList, underlineList, i, startOffset, endOffset);
            }
            for (Object block : this.foldedBlockUnderlines.keySet()) {
                Integer index = this.foldedBlockUnderlines.get(block);
                HighlightFragment fragment = underlineList.get(index);
                this._foldingModel.getTextOffsets(block, this.blockOffsets);
                fragment.startOffset = this.blockOffsets[0];
                fragment.endOffset = this.blockOffsets[1];
                this.paintUnderlineSegment(graphics, clipRect, styledList, fontHighlightList, fragment, this.blockOffsets[0], this.blockOffsets[1]);
            }
            this.foldedBlockUnderlines.clear();
            BasicView.freeHighlightFragmentsList(underlineList);
        }
    }

    protected PaintResult paintUnderlineSegment(Graphics graphics, Rectangle clipRect, StyledFragmentsList styledList, HighlightFragmentsList fontHighlightList, HighlightFragmentsList underlineHighlightList, int underlineFragmentIndex, int startOffset, int endOffset) {
        int underlineEnd;
        HighlightFragment fragment = underlineHighlightList.get(underlineFragmentIndex);
        HighlightStyle highlightStyle = fragment.underlineStyle;
        if (highlightStyle == null) {
            return PaintResult.FAIL_NO_STYLE;
        }
        UnderlinePainter underlinePainter = highlightStyle.getUnderlinePainter();
        Color underlineColor = highlightStyle.getUnderlineColor();
        if (underlinePainter == null || underlineColor == null) {
            return PaintResult.FAIL_NO_PAINTER;
        }
        int underlineStart = Math.max(startOffset, fragment.startOffset);
        if (underlineStart > (underlineEnd = Math.min(endOffset, fragment.endOffset))) {
            return PaintResult.FAIL_NO_RANGE;
        }
        if (this.processFoldedBlockUnderline(underlineHighlightList, underlineFragmentIndex)) {
            return PaintResult.FAIL_FOLDED;
        }
        return this.paintUnderlineSegment(graphics, clipRect, styledList, fontHighlightList, fragment, startOffset, endOffset);
    }

    protected PaintResult paintUnderlineSegment(Graphics graphics, Rectangle clipRect, StyledFragmentsList styledList, HighlightFragmentsList fontHighlightList, HighlightFragment underlineFragment, int startOffset, int endOffset) {
        int underlineEnd;
        HighlightStyle highlightStyle = underlineFragment.underlineStyle;
        if (highlightStyle == null) {
            return PaintResult.FAIL_NO_STYLE;
        }
        UnderlinePainter underlinePainter = highlightStyle.getUnderlinePainter();
        Color underlineColor = highlightStyle.getUnderlineColor();
        if (underlinePainter == null || underlineColor == null) {
            return PaintResult.FAIL_NO_PAINTER;
        }
        int underlineStart = Math.max(startOffset, underlineFragment.startOffset);
        if (underlineStart > (underlineEnd = Math.min(endOffset, underlineFragment.endOffset))) {
            return PaintResult.FAIL_NO_RANGE;
        }
        int startRow = this._rowMap.getRowFromOffset(underlineStart);
        int endRow = this._rowMap.getRowFromOffset(underlineEnd);
        int lastRow = this._numberRows - 1;
        for (int row = startRow; row <= endRow; ++row) {
            int width;
            int paintEndOffset;
            int rowStartOffset = this._rowMap.getRowStartOffset(row);
            int rowEndOffset = this._rowMap.getRowEndOffset(row);
            int paintStartOffset = Math.max(rowStartOffset, underlineStart);
            if (paintStartOffset > (paintEndOffset = Math.min(rowEndOffset, underlineEnd))) continue;
            int xStart = this.getXCoordinateForOffset(styledList, fontHighlightList, rowStartOffset, paintStartOffset);
            int xEnd = this.getXCoordinateForOffset(styledList, fontHighlightList, rowStartOffset, paintEndOffset);
            if (row != lastRow && underlineFragment.endOffset >= rowEndOffset && this._rowMap.rowEndIsLineEnd(row)) {
                xEnd += this._fontWidth;
            }
            if (!this.isXRegionInClip(clipRect, xStart, width = xEnd - xStart)) continue;
            int yPos = this._fontHeight * row;
            int yBaseLine = yPos + this._fontAscent;
            underlinePainter.paintUnderline(graphics, underlineColor, xStart, width, yPos, yBaseLine, this._fontDescent);
        }
        return PaintResult.SUCCESS;
    }

    protected void paintRightMargin(Graphics graphics, Rectangle clipRect) {
        boolean displayRightMargin;
        if (this._editor != null && (displayRightMargin = this._editor.getBooleanProperty("right-margin-visible"))) {
            int rightMarginColumn = this._editor.getIntegerProperty("right-margin-column");
            Color marginColor = (Color)this._editor.getProperty("right-margin-color");
            int xColumn = this._fontWidth * rightMarginColumn;
            if (clipRect.x <= xColumn && xColumn <= clipRect.x + clipRect.width) {
                graphics.setColor(marginColor);
                graphics.drawLine(xColumn, clipRect.y, xColumn, clipRect.y + clipRect.height);
            }
        }
    }

    protected void paintRow(Graphics graphics, Rectangle clipRect, int row, RenderFragmentGenerator generator, HighlightStyle sentinelStyle) {
        int rowStart = this._rowMap.getRowStartOffset(row);
        int rowEnd = this._rowMap.getRowEndOffset(row);
        int lastRow = this._numberRows - 1;
        int y = this._fontHeight * row;
        int x = 0;
        RenderFragment renderFragment = generator.current();
        while (renderFragment != null && renderFragment.endOffset <= rowStart) {
            renderFragment = generator.next();
        }
        if (renderFragment != null) {
            int lastPaintOffset = rowStart;
            while (renderFragment != null && renderFragment.startOffset < rowEnd) {
                int paintStart = lastPaintOffset;
                int paintEnd = Math.min(renderFragment.endOffset, rowEnd);
                x = this.paintSegment(graphics, clipRect, renderFragment, paintStart, paintEnd, x, y);
                lastPaintOffset = paintEnd;
                if (paintEnd == rowEnd) break;
                renderFragment = generator.next();
            }
        }
        HighlightStyle trailingBackgroundStyle = null;
        if (row == lastRow) {
            trailingBackgroundStyle = sentinelStyle;
        } else if (renderFragment != null && renderFragment.startOffset < rowEnd && renderFragment.endOffset >= rowEnd) {
            trailingBackgroundStyle = renderFragment.backgroundHighlight;
        }
        if (trailingBackgroundStyle != null && trailingBackgroundStyle.getUseBackgroundColor()) {
            Color bgColor = this._editor.isEnabled() ? trailingBackgroundStyle.getBackgroundColor() : this._editor.getDisabledBackgroundColor();
            graphics.setColor(bgColor);
            int highlightWidth = clipRect.x + clipRect.width - x;
            if (highlightWidth > 0) {
                graphics.fillRect(x, y, highlightWidth, this._fontHeight);
            }
        }
    }

    protected int paintSegment(Graphics graphics, Rectangle clipRect, RenderFragment renderFragment, int startOffset, int endOffset, int x, int y) {
        int underlineEnd;
        int underlineStart;
        int endX;
        boolean isFolded;
        if (startOffset == endOffset) {
            return x;
        }
        Color bgColor = this._editor.isEnabled() ? renderFragment.getBackgroundColor() : this._editor.getDisabledBackgroundColor();
        Color fgColor = this._editor.isEnabled() ? renderFragment.getForegroundColor() : this._editor.getDisabledTextColor();
        int fontStyle = renderFragment.getFontStyle();
        Font styleFont = this._fontHelper.getFont(fontStyle);
        FontMetrics paintMetrics = this._fontHelper.getFontMetrics(styleFont, (Component)this._editor);
        graphics.setFont(styleFont);
        String foldedText = renderFragment.textToUse;
        boolean bl = isFolded = foldedText != null;
        if (!this._editorBackgroundColor.equals(bgColor)) {
            int segmentWidth = isFolded ? this.getFoldedTextWidth(paintMetrics, foldedText) : this.getTabbedTextWidth(paintMetrics, startOffset, endOffset, x);
            graphics.setColor(bgColor);
            graphics.fillRect(x, y, segmentWidth, this._fontHeight);
        }
        graphics.setColor(fgColor);
        int n = endX = isFolded ? this.drawFoldedText(graphics, clipRect, paintMetrics, foldedText, x, y) : this.drawTabbedText(graphics, clipRect, paintMetrics, startOffset, endOffset, x, y += this._fontAscent);
        if (!isFolded && this._composedStart != -1 && (underlineStart = Math.max(this._composedStart, startOffset)) < (underlineEnd = Math.min(this._composedEnd, endOffset))) {
            int paintStart = x;
            if (underlineStart > startOffset) {
                paintStart += this.getTabbedTextWidth(paintMetrics, startOffset, underlineStart, x);
            }
            int paintWidth = this.getTabbedTextWidth(paintMetrics, underlineStart, underlineEnd, paintStart);
            graphics.drawLine(paintStart, y += paintMetrics.getDescent() / 2, paintStart + paintWidth, y);
        }
        return endX;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean processFoldedBlockUnderline(HighlightFragmentsList underlineFragmentList, int underlineFragmentIndex) {
        if (this._foldingModel != null) {
            this._foldingModel.readLock();
            try {
                HighlightFragment fragment = underlineFragmentList.get(underlineFragmentIndex);
                for (Object block : this._foldingModel.getCollapsedBlocks()) {
                    this.blockOffsets = this._foldingModel.getTextOffsets(block, this.blockOffsets);
                    if (this.blockOffsets[0] <= fragment.startOffset && this.blockOffsets[1] >= fragment.endOffset) {
                        int priority = fragment.underlineStyle.getPriority();
                        Integer prevFragmentIndex = this.foldedBlockUnderlines.get(block);
                        if (prevFragmentIndex == null || priority > underlineFragmentList.get((int)prevFragmentIndex.intValue()).underlineStyle.getPriority()) {
                            this.foldedBlockUnderlines.put(block, underlineFragmentIndex);
                        }
                        underlineFragmentList.get(underlineFragmentIndex);
                        boolean bl = true;
                        return bl;
                    }
                    if (fragment.endOffset >= this.blockOffsets[0]) continue;
                    boolean bl = false;
                    return bl;
                }
            }
            finally {
                this._foldingModel.readUnlock();
            }
        }
        return false;
    }

    private void updateMetrics() {
        try {
            Font currentFont;
            if (this._editor == null) {
                this._editor = (BasicEditorPane)this.getContainer();
                this._editor.addPropertyChangeListener(this);
                this._useAA = this._editor.getBooleanProperty("editor-antialiasing");
                this._showWhitespace = this._editor.getBooleanProperty("show-whitespace-chars");
                this._tabSize = this.calculateTabSize();
                this.updateFolding();
            }
            if ((currentFont = this._editor.getFont()) != this._font) {
                this._font = currentFont;
                this._metrics = this._editor.getFontMetrics(this._font);
                this._fontHeight = this._metrics.getHeight();
                this._fontAscent = this._metrics.getAscent();
                this._fontDescent = this._metrics.getDescent();
                this._fontWidth = this._metrics.charWidth('W');
                this._fontHelper = null;
            }
            if (this._fontHelper == null) {
                this._fontHelper = this._editor.getFontHelper();
            }
            this._editorBackgroundColor = this._editor.getBackground();
            if (this._rowMap == null) {
                this._rowMap = new FoldedRowMap(this);
                this._rowMap.rebuildFoldedMap();
            }
            this._numberRows = this._rowMap.getRowCount();
            this.attachToRegistries();
        }
        catch (ExpiredTextBufferException expiredTextBufferException) {
            // empty catch block
        }
    }

    private void updateFolding() {
        CodeFoldingMargin newMargin;
        CodeFoldingModel newModel;
        CodeFoldingModel oldModel = this._foldingModel;
        CodeFoldingMargin oldMargin = this._foldingMargin;
        boolean visibleMargin = this._editor.getBooleanProperty("code-folding-margin-visible");
        if (visibleMargin) {
            newModel = (CodeFoldingModel)this._editor.getProperty("code-folding-model");
            newMargin = (CodeFoldingMargin)this._editor.getProperty("code-folding-margin");
        } else {
            newModel = null;
            newMargin = null;
        }
        this._foldingModel = newModel;
        this._foldingMargin = newMargin;
        if (oldModel != newModel) {
            if (oldModel != null) {
                oldModel.removeCodeFoldingModelListener(this._foldingListener);
            }
            if (newModel != null) {
                newModel.addCodeFoldingModelListener(this._foldingListener);
            }
        }
        if (newMargin != oldMargin) {
            if (oldMargin != null) {
                oldMargin.removeCodeExpansionListener(this._foldingListener);
            }
            if (newMargin != null) {
                newMargin.addCodeExpansionListener(this._foldingListener);
            }
        }
    }

    private int getLongestRow(int startRow, int endRow) {
        int longestRow = 0;
        for (int row = startRow; row <= endRow; ++row) {
            int rowLength = this._rowMap.getRowEndOffset(row) - this._rowMap.getRowStartOffset(row);
            longestRow = Math.max(longestRow, rowLength);
        }
        return longestRow;
    }

    private void rebuildRowMap() {
        this._textBuffer.readLock();
        try {
            this._rowMap.rebuildRowMap();
            this._rowMap.rebuildFoldedMap();
        }
        catch (ExpiredTextBufferException e) {
            return;
        }
        finally {
            this._textBuffer.readUnlock();
        }
        this.preferenceChanged(null, true, true);
        this._editor.repaint();
    }

    private void revalidateRowMap() {
        boolean heightChanged;
        int oldRowCount = this._numberRows;
        int oldMaxWidth = this._rowMap.getMaxRowWidth();
        this._rowMap.revalidateRowMap();
        int newRowCount = this._numberRows = this._rowMap.getRowCount();
        int newMaxWidth = this._rowMap.getMaxRowWidth();
        boolean widthChanged = oldMaxWidth != newMaxWidth;
        boolean bl = heightChanged = oldRowCount != newRowCount;
        if (widthChanged || heightChanged) {
            this.preferenceChanged(null, widthChanged, heightChanged);
        }
        this._editor.repaint();
    }

    private void rebuildFoldedBlocks() {
        boolean heightChanged;
        if (this._rowMap == null) {
            return;
        }
        int oldRowCount = this._numberRows;
        int oldMaxWidth = this._rowMap.getMaxRowWidth();
        this._rowMap.rebuildFoldedMap();
        int newRowCount = this._numberRows = this._rowMap.getRowCount();
        int newMaxWidth = this._rowMap.getMaxRowWidth();
        LOG.trace("BasicView. rebuild folded blocks, old height {0}, new height {1}", oldRowCount, newRowCount);
        boolean widthChanged = oldMaxWidth != newMaxWidth;
        boolean bl = heightChanged = oldRowCount != newRowCount;
        if (widthChanged || heightChanged) {
            this.preferenceChanged(null, widthChanged, heightChanged);
        }
        this._editor.repaint();
    }

    BaseStyle lookupStyle(String styleName) {
        BaseStyle style;
        if (this._styleRegistry == null) {
            this.attachToRegistries();
        }
        if ((style = this._styleRegistry.lookupStyle(styleName)) == null) {
            throw new IllegalStateException("style not found: " + styleName);
        }
        return style;
    }

    private void attachToRegistries() {
        if (this._styleRegistry == null) {
            if (this._editor == null) {
                this.updateMetrics();
            }
            this._styleRegistry = this._editor.getStyleRegistry();
            BaseStyle unusedStyle = this._styleRegistry.lookupStyle("audit-unused");
            if (unusedStyle != null) {
                this._whitespaceColor = unusedStyle.getForegroundColor();
            }
            this._styleRegistry.addPropertyChangeListener(this);
        }
        if (this._highlightRegistry == null) {
            this._highlightRegistry = this._editor.getHighlightRegistry();
            this._highlightRegistry.addPropertyChangeListener(this);
        }
    }

    private void detachFromStyleRegistry() {
        this._styleRegistry.removePropertyChangeListener(this);
        this._styleRegistry = null;
    }

    private void detachFromHighlightRegistry() {
        this._highlightRegistry.removePropertyChangeListener(this);
        this._highlightRegistry = null;
    }

    private Rectangle rowToRect(Shape viewShape, int row) {
        if (this._metrics == null) {
            this.updateMetrics();
        }
        Rectangle viewRect = viewShape.getBounds();
        Rectangle rowRect = new Rectangle(viewRect.x, viewRect.y + row * this._fontHeight, viewRect.width, this._fontHeight);
        return rowRect;
    }

    @Override
    public Shape modelToView(int offset, Shape viewShape, Position.Bias bias) throws BadLocationException {
        if (this._rowMap == null) {
            this.updateMetrics();
        }
        int bufferLength = this._textBuffer.getLength();
        if (offset < 0 || offset > bufferLength) {
            throw new BadLocationException("m2v(), bad offset", offset);
        }
        int row = this._rowMap.getRowFromOffset(offset);
        Rectangle rowRect = this.rowToRect(viewShape, row);
        rowRect.x += this.getXCoordinateForOffset(row, offset);
        if (offset == this._textBuffer.getLength()) {
            rowRect.width = 0;
        } else {
            char c = this._textBuffer.getChar(offset);
            rowRect.width = this._metrics.charWidth(c);
        }
        rowRect.height = this._fontHeight;
        return rowRect;
    }

    @Override
    public Shape modelToView(int startOffset, Position.Bias startBias, int endOffset, Position.Bias endBias, Shape viewShape) throws BadLocationException {
        if (this._rowMap == null) {
            this.updateMetrics();
        }
        int bufferLength = this._textBuffer.getLength();
        if (startOffset < 0 || startOffset > bufferLength) {
            throw new BadLocationException("m2v2(), bad offset", startOffset);
        }
        if (endOffset < 0 || endOffset > bufferLength) {
            throw new BadLocationException("m2v2(), bad offset", endOffset);
        }
        int row1 = this._rowMap.getRowFromOffset(startOffset);
        int row2 = this._rowMap.getRowFromOffset(endOffset);
        Rectangle rowRect1 = this.rowToRect(viewShape, row1);
        Rectangle rowRect2 = this.rowToRect(viewShape, row2);
        rowRect1.add(rowRect2);
        return rowRect1;
    }

    @Override
    public int viewToModel(float fx, float fy, Shape viewShape, Position.Bias[] biasReturn) {
        if (this._rowMap == null) {
            this.updateMetrics();
        }
        biasReturn[0] = Position.Bias.Forward;
        Rectangle viewRect = viewShape.getBounds();
        int x = (int)fx;
        int y = (int)fy;
        int viewX = x - viewRect.x;
        int viewY = y - viewRect.y;
        if (viewY < 0) {
            return this.getStartOffset();
        }
        if (viewY > viewRect.height) {
            return this.getEndOffset();
        }
        int row = viewY / this._fontHeight;
        if ((row = Math.max(row, 0)) >= this._numberRows) {
            return this.getEndOffset();
        }
        return this.getOffsetForXCoordinate(row, viewX);
    }

    private void compoundBeginEdit() {
        this.damage = new Damage();
    }

    private void compoundEndEdit() {
        if (this.damage != null) {
            this.damageEnd(this.damage);
        }
        this.damage = null;
    }

    protected void updateDamage(DocumentEvent changes, Shape viewShape) {
        if (this.damage == null) {
            Damage damage = new Damage();
            this.damageBegin(damage);
            this.damageUpdate(damage, changes, viewShape);
            this.damageEnd(damage);
        } else {
            this.damageBegin(this.damage);
            this.damageUpdate(this.damage, changes, viewShape);
        }
    }

    private void damageBegin(Damage damage) {
        if (damage.editCount == 0) {
            if (this._rowMap == null) {
                this.updateMetrics();
            }
            damage.oldRowCount = this._numberRows;
            damage.oldMaxWidth = this._rowMap.getMaxRowWidth();
        }
    }

    private void damageUpdate(Damage damage, DocumentEvent event, Shape shape) {
        this._rowMap.documentChanged(event);
        int eventOffset = event.getOffset();
        int eventLength = event.getLength();
        if (damage.editCount == 0) {
            damage.offset = eventOffset;
            damage.endOffset = eventOffset + Math.max(0, eventLength);
            damage.shape = shape;
            damage.event = event;
        } else if (eventOffset <= damage.offset) {
            if (event.getType().equals(DocumentEvent.EventType.INSERT)) {
                damage.offset = eventOffset;
                Damage damage2 = damage;
                damage2.endOffset = damage2.endOffset + eventLength;
            } else {
                damage.offset = eventOffset;
                damage.endOffset = Math.max(eventOffset, damage.endOffset - eventLength);
            }
        } else if (eventOffset < damage.endOffset) {
            if (event.getType().equals(DocumentEvent.EventType.INSERT)) {
                Damage damage3 = damage;
                damage3.endOffset = damage3.endOffset + eventLength;
            } else {
                damage.endOffset = Math.max(eventOffset, damage.endOffset - eventLength);
            }
        } else if (event.getType().equals(DocumentEvent.EventType.INSERT)) {
            Damage damage4 = damage;
            damage4.endOffset = damage4.endOffset + (eventOffset + eventLength);
        } else {
            damage.endOffset = eventOffset;
        }
        if (shape != null) {
            if (damage.bounds == null) {
                damage.bounds = shape.getBounds();
            } else {
                damage.bounds = shape.getBounds().union(damage.bounds);
            }
        }
        damage.editCount++;
    }

    private void damageEnd(Damage damage) {
        boolean heightChanged;
        if (damage.shape == null) {
            return;
        }
        int newRowCount = this._numberRows = this._rowMap.getRowCount();
        int newMaxWidth = this._rowMap.getMaxRowWidth();
        boolean widthChanged = damage.oldMaxWidth != newMaxWidth;
        boolean bl = heightChanged = damage.oldRowCount != newRowCount;
        if (widthChanged || heightChanged) {
            this.preferenceChanged(null, widthChanged, heightChanged);
        }
        if (damage.editCount > 1 || heightChanged) {
            final Rectangle visibleRect = this._editor.getVisibleRect();
            if (visibleRect != null) {
                float rowPos = (float)visibleRect.y / (float)this._fontHeight;
                int changeOffset = damage.offset;
                int changeRow = this._rowMap.getRowFromOffset(changeOffset);
                if ((float)changeRow < rowPos) {
                    int rowsChanged = newRowCount - damage.oldRowCount;
                    visibleRect.y += rowsChanged * this._fontHeight;
                    visibleRect.y = Math.max(0, visibleRect.y);
                    if (SwingUtilities.isEventDispatchThread()) {
                        this._editor.scrollRectToVisible(visibleRect);
                    } else {
                        SwingUtilities.invokeLater(new Runnable(){

                            @Override
                            public void run() {
                                BasicView.this._editor.scrollRectToVisible(visibleRect);
                            }
                        });
                    }
                }
            }
            if (SwingUtilities.isEventDispatchThread()) {
                this._editor.repaint();
            } else {
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        BasicView.this._editor.repaint();
                    }
                });
            }
        } else {
            DocumentRenderer documentRenderer = this.getDocumentRenderer();
            documentRenderer.calculateDamage(damage.event, this._lineRange);
            int startLine = this._lineRange.start;
            int endLine = this._lineRange.end;
            int lastLine = this._lineMap.getLineCount() - 1;
            int startOffset = this._lineMap.getLineStartOffset(startLine);
            int endOffset = this._lineMap.getLineEndOffset(endLine);
            if (endLine != lastLine) {
                --endOffset;
            }
            int startRow = this._rowMap.getRowFromOffset(startOffset);
            int endRow = this._rowMap.getRowFromOffset(endOffset);
            int numRows = endRow - startRow + 1;
            final Rectangle rowArea = new Rectangle(((Damage)damage).bounds.x, ((Damage)damage).bounds.y + startRow * this._fontHeight, ((Damage)damage).bounds.width, numRows * this._fontHeight);
            if (SwingUtilities.isEventDispatchThread()) {
                this._editor.repaint(rowArea.x, rowArea.y, rowArea.width, rowArea.height);
            } else {
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        BasicView.this._editor.repaint(rowArea.x, rowArea.y, rowArea.width, rowArea.height);
                    }
                });
            }
        }
    }

    @Override
    public void insertUpdate(DocumentEvent e, Shape a, ViewFactory f) {
        this.updateDamage(e, a);
    }

    @Override
    public void removeUpdate(DocumentEvent e, Shape a, ViewFactory f) {
        this.updateDamage(e, a);
    }

    @Override
    public void changedUpdate(DocumentEvent e, Shape a, ViewFactory f) {
        this.updateDamage(e, a);
    }

    @Override
    public float getPreferredSpan(int axis) {
        this.updateMetrics();
        switch (axis) {
            case 0: {
                int blankColumns = this._editor.getIntegerProperty("trailing-blank-columns");
                int blankWidth = blankColumns * this._fontWidth;
                return this._rowMap.getMaxRowWidth() + blankWidth;
            }
            case 1: {
                int blankLines = this._editor.getIntegerProperty("trailing-blank-rows");
                return (this._numberRows + blankLines) * this._fontHeight;
            }
        }
        throw new IllegalArgumentException("Illegal axis: " + axis);
    }

    @Override
    public float getMinimumSpan(int axis) {
        return this.getPreferredSpan(axis);
    }

    @Override
    public float getMaximumSpan(int axis) {
        return this.getPreferredSpan(axis);
    }

    @Override
    public int getBreakWeight(int axis, float pos, float len) {
        return 0;
    }

    public int getRowForLine(int line) {
        if (this._rowMap == null) {
            return line;
        }
        return this._rowMap.getRowForLine(line);
    }

    public int getLineForRow(int row) {
        if (this._rowMap == null) {
            return row;
        }
        return this._rowMap.getLineForRow(row);
    }

    LineMap getLineMap() {
        return this._lineMap;
    }

    FontHelper getFontHelper() {
        return this._fontHelper;
    }

    BasicEditorPane getEditor() {
        return this._editor;
    }

    CodeFoldingModel getFoldingModel() {
        return this._foldingModel;
    }

    private boolean isXRegionInClip(Rectangle clipRect, int x, int width) {
        return x + width >= clipRect.x && clipRect.x + clipRect.width >= x;
    }

    public boolean isLineCollapsed(int line) {
        return this._rowMap.isLineCollapsed(line);
    }

    private int drawFoldedText(Graphics graphics, Rectangle clipRect, FontMetrics paintMetrics, String textToDraw, int xPos, int yPos) {
        int textWidth = this.getFoldedTextWidth(paintMetrics, textToDraw);
        if (textToDraw.length() > 0) {
            if (this.isXRegionInClip(clipRect, xPos, textWidth)) {
                graphics.drawString(textToDraw, xPos, yPos);
            }
            xPos += textWidth;
        }
        return xPos;
    }

    private int drawTabbedText(Graphics graphics, Rectangle clipRect, FontMetrics paintMetrics, int startOffset, int endOffset, int xPos, int yPos) {
        int length = endOffset - startOffset;
        this._textBuffer.getText(startOffset, length, this._lineBuffer);
        char[] buffer = this._lineBuffer.array;
        int bufferStart = this._lineBuffer.offset;
        int bufferEnd = this._lineBuffer.offset + length;
        this._lineBuffer.array = null;
        int lastPaintOffset = bufferStart;
        int charsToPaint = 0;
        int charsWidth = 0;
        boolean spaceSegment = true;
        Color color = graphics.getColor();
        block5: for (int currentOffset = bufferStart; currentOffset < bufferEnd; ++currentOffset) {
            char c = buffer[currentOffset];
            switch (c) {
                case '\t': {
                    if (charsToPaint > 0) {
                        if (!spaceSegment && this.isXRegionInClip(clipRect, xPos, charsWidth)) {
                            graphics.drawChars(buffer, lastPaintOffset, charsToPaint, xPos, yPos);
                        }
                        xPos += charsWidth;
                        charsToPaint = 0;
                        charsWidth = 0;
                        spaceSegment = true;
                    }
                    if (this._showWhitespace) {
                        charsWidth += paintMetrics.charWidth(c);
                        graphics.setColor(this._whitespaceColor);
                        graphics.drawChars(WHITESPACE_TAB_REPLACEMENT_ARRAY, 0, 1, xPos, yPos);
                        graphics.setColor(color);
                    }
                    lastPaintOffset = currentOffset + 1;
                    xPos = this.getNextTabStop(xPos);
                    continue block5;
                }
                case '\n': 
                case '\r': {
                    if (!this._showWhitespace) break block5;
                    if (this.isXRegionInClip(clipRect, xPos, charsWidth)) {
                        graphics.drawChars(buffer, lastPaintOffset, charsToPaint, xPos, yPos);
                    }
                    xPos += charsWidth;
                    charsToPaint = 0;
                    charsWidth = 0;
                    spaceSegment = true;
                    graphics.setColor(this._whitespaceColor);
                    if (this._textBuffer.getEOLType().equals("\r")) {
                        graphics.drawChars(WHITESPACE_CR_REPLACEMENT_ARRAY, 0, 1, xPos, yPos);
                        xPos += paintMetrics.charWidth(WHITESPACE_CR_REPLACEMENT);
                    } else if (this._textBuffer.getEOLType().equals("\n")) {
                        graphics.drawChars(WHITESPACE_LF_REPLACEMENT_ARRAY, 0, 1, xPos, yPos);
                        xPos += paintMetrics.charWidth(WHITESPACE_LF_REPLACEMENT);
                    } else if (this._textBuffer.getEOLType().equals("\r\n")) {
                        graphics.drawChars(WHITESPACE_CR_REPLACEMENT_ARRAY, 0, 1, xPos, yPos);
                        graphics.drawChars(WHITESPACE_LF_REPLACEMENT_ARRAY, 0, 1, xPos += paintMetrics.charWidth(WHITESPACE_CR_REPLACEMENT), yPos);
                        xPos += paintMetrics.charWidth(WHITESPACE_LF_REPLACEMENT);
                    }
                    graphics.setColor(color);
                    continue block5;
                }
                default: {
                    spaceSegment = false;
                    ++charsToPaint;
                    charsWidth += paintMetrics.charWidth(c);
                    continue block5;
                }
                case ' ': 
                case '\u00a0': {
                    if (this._showWhitespace) {
                        if (charsToPaint > 0) {
                            if (!spaceSegment && this.isXRegionInClip(clipRect, xPos, charsWidth)) {
                                graphics.drawChars(buffer, lastPaintOffset, charsToPaint, xPos, yPos);
                            }
                            xPos += charsWidth;
                            charsToPaint = 0;
                            charsWidth = 0;
                            spaceSegment = true;
                        }
                        char[] replacement = WHITESPACE_SPACE_REPLACEMENT_ARRAY;
                        if (c == '\u00a0') {
                            replacement = WHITESPACE_NBSP_REPLACEMENT_ARRAY;
                        }
                        graphics.setColor(this._whitespaceColor);
                        graphics.drawChars(replacement, 0, 1, xPos, yPos);
                        graphics.setColor(color);
                        lastPaintOffset = currentOffset + 1;
                        xPos += paintMetrics.charWidth(replacement[0]);
                        continue block5;
                    }
                    ++charsToPaint;
                    charsWidth += paintMetrics.charWidth(c);
                }
            }
        }
        if (charsToPaint > 0) {
            if (!spaceSegment && this.isXRegionInClip(clipRect, xPos, charsWidth)) {
                graphics.drawChars(buffer, lastPaintOffset, charsToPaint, xPos, yPos);
            }
            xPos += charsWidth;
        }
        return xPos;
    }

    private int getFoldedTextWidth(FontMetrics paintMetrics, String foldedText) {
        return paintMetrics.stringWidth(foldedText);
    }

    int getTabbedTextWidth(FontMetrics paintMetrics, int startOffset, int endOffset, int xPos) {
        int endX = xPos;
        block4: for (int currentOffset = startOffset; currentOffset < endOffset; ++currentOffset) {
            char c = this._textBuffer.getChar(currentOffset);
            switch (c) {
                case '\t': {
                    endX = this.getNextTabStop(endX);
                    continue block4;
                }
                case '\n': 
                case '\r': {
                    if (!this._showWhitespace) break block4;
                    if (this._textBuffer.getEOLType().equals("\r")) {
                        endX += paintMetrics.charWidth('\u00ab');
                        break block4;
                    }
                    if (this._textBuffer.getEOLType().equals("\n")) {
                        endX += paintMetrics.charWidth('\u00b6');
                        break block4;
                    }
                    if (!this._textBuffer.getEOLType().equals("\r\n")) break block4;
                    endX += paintMetrics.charWidth('\u00ab');
                    endX += paintMetrics.charWidth('\u00b6');
                    break block4;
                }
                default: {
                    endX += paintMetrics.charWidth(c);
                }
            }
        }
        int textWidth = endX - xPos;
        return textWidth;
    }

    private int getTabbedTextOffset(FontMetrics paintMetrics, int startOffset, int endOffset, int startX, int xPos, boolean roundAdjustment) {
        int currentOffset;
        int afterX = startX;
        block4: for (currentOffset = startOffset; currentOffset < endOffset; ++currentOffset) {
            int beforeX = afterX;
            char c = this._textBuffer.getChar(currentOffset);
            switch (c) {
                case '\t': {
                    afterX = this.getNextTabStop(beforeX);
                    break;
                }
                case '\n': 
                case '\r': {
                    break block4;
                }
                default: {
                    afterX = beforeX + paintMetrics.charWidth(c);
                }
            }
            if (beforeX > xPos || xPos >= afterX) continue;
            if (!roundAdjustment || afterX - xPos >= xPos - beforeX) break;
            ++currentOffset;
            break;
        }
        return currentOffset;
    }

    int getXCoordinateForOffset(int row, int offset) {
        int rowStart = this._rowMap.getRowStartOffset(row);
        int rowEnd = this._rowMap.getRowEndOffset(row);
        if (offset == rowStart) {
            return 0;
        }
        int renderStartLine = this._lineMap.getLineFromOffset(rowStart);
        int renderEndLine = this._lineMap.getLineFromOffset(rowEnd);
        DocumentRenderer documentRenderer = this.getDocumentRenderer();
        StyledFragmentsList fragmentsList = documentRenderer.renderLines(renderStartLine, renderEndLine);
        HighlightFragmentsList fontHighlightList = this.renderFontHighlights(rowStart, rowEnd);
        int xPos = this.getXCoordinateForOffset(fragmentsList, fontHighlightList, rowStart, offset);
        if (fragmentsList != null) {
            fragmentsList.clear();
            documentRenderer.recycleFragmentsList(fragmentsList);
        }
        BasicView.freeHighlightFragmentsList(fontHighlightList);
        return xPos;
    }

    private int getXCoordinateForOffset(StyledFragmentsList fragmentsList, HighlightFragmentsList fontHighlightList, int rowStart, int offset) {
        RenderFragmentGenerator generator = this._rowMap.createRenderFragmentGenerator(fragmentsList, fontHighlightList);
        return this.getXCoordinateForOffset(generator, rowStart, offset);
    }

    int getXCoordinateForOffset(RenderFragmentGenerator generator, int rowStart, int offset) {
        int xPos = 0;
        if (rowStart == offset) {
            return xPos;
        }
        RenderFragment renderFragment = generator.current();
        while (renderFragment != null && renderFragment.endOffset <= rowStart) {
            renderFragment = generator.next();
        }
        while (renderFragment != null && renderFragment.startOffset < offset) {
            int fontStyle = renderFragment.getFontStyle();
            FontMetrics paintMetrics = this._fontHelper.getFontMetrics(fontStyle, (Component)this._editor);
            int processStart = Math.max(rowStart, renderFragment.startOffset);
            int processEnd = Math.min(offset, renderFragment.endOffset);
            String foldedText = renderFragment.textToUse;
            int fragmentWidth = foldedText != null ? this.getFoldedTextWidth(paintMetrics, renderFragment.textToUse) : this.getTabbedTextWidth(paintMetrics, processStart, processEnd, xPos);
            xPos += fragmentWidth;
            if (processEnd == offset) break;
            renderFragment = generator.next();
        }
        return xPos;
    }

    private int getOffsetForXCoordinate(int row, int xPos) {
        int rowStart = this._rowMap.getRowStartOffset(row);
        int rowEnd = this._rowMap.getRowEndOffset(row);
        if (xPos <= 0) {
            return rowStart;
        }
        int renderStartLine = this._lineMap.getLineFromOffset(rowStart);
        int renderEndLine = this._lineMap.getLineFromOffset(rowEnd);
        DocumentRenderer documentRenderer = this.getDocumentRenderer();
        StyledFragmentsList fragmentsList = documentRenderer.renderLines(renderStartLine, renderEndLine);
        HighlightFragmentsList fontHighlightList = this.renderFontHighlights(rowStart, rowEnd);
        int lastRow = this._numberRows - 1;
        if (row < lastRow && this._rowMap.rowEndIsLineEnd(row)) {
            --rowEnd;
        }
        int returnOffset = this.getOffsetForXCoordinate(fragmentsList, fontHighlightList, rowStart, rowEnd, xPos);
        if (fragmentsList != null) {
            fragmentsList.clear();
            documentRenderer.recycleFragmentsList(fragmentsList);
        }
        BasicView.freeHighlightFragmentsList(fontHighlightList);
        return returnOffset;
    }

    private int getOffsetForXCoordinate(StyledFragmentsList fragmentsList, HighlightFragmentsList fontHighlightList, int rowStart, int rowEnd, int xPos) {
        int beforeX;
        if (rowStart == rowEnd) {
            return rowStart;
        }
        RenderFragmentGenerator generator = this._rowMap.createRenderFragmentGenerator(fragmentsList, fontHighlightList);
        RenderFragment renderFragment = generator.current();
        while (renderFragment.endOffset <= rowStart) {
            renderFragment = generator.next();
        }
        int afterX = 0;
        int currentOffset = rowStart;
        while (renderFragment.startOffset < rowEnd && xPos > (beforeX = afterX) && currentOffset < rowEnd) {
            int processStart = Math.max(renderFragment.startOffset, currentOffset);
            int processEnd = Math.min(renderFragment.endOffset, rowEnd);
            int fontStyle = renderFragment.getFontStyle();
            FontMetrics paintMetrics = this._fontHelper.getFontMetrics(fontStyle, (Component)this._editor);
            String foldedText = renderFragment.textToUse;
            int fragmentWidth = foldedText != null ? this.getFoldedTextWidth(paintMetrics, foldedText) : this.getTabbedTextWidth(paintMetrics, processStart, processEnd, beforeX);
            afterX = beforeX + fragmentWidth;
            if (beforeX <= xPos && xPos <= afterX) {
                currentOffset = foldedText != null ? renderFragment.endOffset : this.getTabbedTextOffset(paintMetrics, processStart, processEnd, beforeX, xPos, false);
                break;
            }
            currentOffset = processEnd;
            if (currentOffset >= rowEnd) break;
            renderFragment = generator.next();
        }
        return currentOffset;
    }

    private int getNextTabStop(int xPos) {
        int spaceSize = this._metrics.charWidth(' ');
        int tabPixels = this._tabSize * spaceSize;
        int numTabs = xPos / tabPixels;
        int nextStop = tabPixels * (numTabs + 1);
        return nextStop;
    }

    private int calculateTabSize() {
        int size = this._editor.getIntegerProperty("tab-size");
        return Math.max(1, size);
    }

    @Override
    public void propertyChange(PropertyChangeEvent event) {
        String propertyName = event.getPropertyName();
        if (propertyName.equals("compoundEditInProgress")) {
            Boolean inProgress = (Boolean)event.getNewValue();
            LOG.trace("compoundEditInProgress changed to {0}", (Object)inProgress);
            if (inProgress.booleanValue()) {
                this.compoundBeginEdit();
            } else {
                this.compoundEndEdit();
            }
        } else if (propertyName.equals("language-support")) {
            this.revalidateRowMap();
        } else if (propertyName.equals("tab-size")) {
            this._tabSize = this.calculateTabSize();
            this.rebuildRowMap();
        } else if (propertyName.equals("editor-antialiasing")) {
            this._useAA = this._editor.getBooleanProperty("editor-antialiasing");
            this.updateRenderingHints();
            this._editor.repaint();
        } else if (propertyName.equals("trailing-blank-rows")) {
            this.preferenceChanged(null, false, true);
            this._editor.repaint();
        } else if (propertyName.equals("trailing-blank-columns")) {
            this.preferenceChanged(null, true, false);
            this._editor.repaint();
        } else if (propertyName.equals("right-margin-column") || propertyName.equals("right-margin-color") || propertyName.equals("right-margin-visible")) {
            this._editor.repaint();
        } else if (propertyName.equals("editor-font")) {
            this._fontHelper = null;
            this.updateMetrics();
            this.rebuildRowMap();
        } else if (propertyName.equals("style-registry")) {
            this.detachFromStyleRegistry();
            this._editor.updateColors();
            this.updateMetrics();
            this.revalidateRowMap();
        } else if (propertyName.equals("style-changed")) {
            this._editor.updateColors();
            this.updateMetrics();
            this.revalidateRowMap();
            BaseStyle unusedStyle = this._styleRegistry.lookupStyle("audit-unused");
            if (unusedStyle != null) {
                this._whitespaceColor = unusedStyle.getForegroundColor();
            }
        } else if (propertyName.equals("highlight-registry")) {
            this.detachFromHighlightRegistry();
            this.revalidateRowMap();
        } else if (propertyName.equals("highlight-changed")) {
            this.revalidateRowMap();
        } else if (propertyName.equals("code-folding-model") || propertyName.equals("code-folding-margin-visible")) {
            this.updateFolding();
            this.rebuildFoldedBlocks();
        } else if (propertyName.equals("show-whitespace-chars")) {
            this._showWhitespace = this._editor.getBooleanProperty("show-whitespace-chars");
            this._editor.repaint();
        }
    }

    private HighlightFragmentsList renderTextHighlights(int startOffset, int endOffset) {
        HighlightFragmentsList highlightFragmentsList = BasicView.allocHighlightFragmentsList();
        highlightFragmentsList.setHighlightRegistry(this._highlightRegistry);
        highlightFragmentsList.setAttributeTextOnly();
        Iterator<HighlightLayer> iterator = this._editor.getHighlightLayers();
        if (iterator != null) {
            while (iterator.hasNext()) {
                HighlightLayer layer = iterator.next();
                layer.renderHighlights(highlightFragmentsList, startOffset, endOffset);
            }
        }
        highlightFragmentsList.clearAttributeFilter();
        return highlightFragmentsList;
    }

    HighlightFragmentsList renderFontHighlights(int startOffset, int endOffset) {
        if (this._highlightRegistry == null) {
            this.attachToRegistries();
        }
        HighlightFragmentsList highlightFragmentsList = BasicView.allocHighlightFragmentsList();
        highlightFragmentsList.setHighlightRegistry(this._highlightRegistry);
        highlightFragmentsList.setAttributeFontOnly();
        Iterator<HighlightLayer> iterator = this._editor.getHighlightLayers();
        if (iterator != null) {
            while (iterator.hasNext()) {
                HighlightLayer layer = iterator.next();
                layer.renderHighlights(highlightFragmentsList, startOffset, endOffset);
            }
        }
        highlightFragmentsList.clearAttributeFilter();
        return highlightFragmentsList;
    }

    private HighlightFragmentsList renderUnderlineHighlights(int underlineType, boolean lineType, int startOffset, int endOffset) {
        int typeFilter;
        if (this._highlightRegistry == null) {
            this.attachToRegistries();
        }
        HighlightFragmentsList highlightFragmentsList = BasicView.allocHighlightFragmentsList();
        highlightFragmentsList.setHighlightRegistry(this._highlightRegistry);
        highlightFragmentsList.setAttributeUnderlineOnly();
        switch (underlineType) {
            case 0: {
                typeFilter = 1;
                break;
            }
            case 1: {
                typeFilter = 2;
                break;
            }
            case 2: {
                typeFilter = 4;
                break;
            }
            default: {
                throw new IllegalArgumentException("invalid underline type: " + underlineType);
            }
        }
        highlightFragmentsList.setUnderlineTypeFilter(typeFilter);
        Iterator<HighlightLayer> iterator = this._editor.getHighlightLayers();
        if (iterator != null) {
            while (iterator.hasNext()) {
                int fetchType = lineType ? 2 : 1;
                HighlightLayer layer = iterator.next();
                layer.renderHighlights(highlightFragmentsList, fetchType, startOffset, endOffset);
            }
        }
        highlightFragmentsList.clearAllFilters();
        return highlightFragmentsList;
    }

    private static synchronized HighlightFragmentsList allocHighlightFragmentsList() {
        for (int i = 0; i < 5; ++i) {
            HighlightFragmentsList spareList = sharedHighlightArray[i];
            if (spareList == null) continue;
            BasicView.sharedHighlightArray[i] = null;
            return spareList;
        }
        return new HighlightFragmentsList();
    }

    static synchronized void freeHighlightFragmentsList(HighlightFragmentsList list) {
        if (list != null) {
            list.clearAttributeFilter();
            list.clear();
            list.setHighlightRegistry(null);
            for (int i = 0; i < 5; ++i) {
                if (sharedHighlightArray[i] != null) continue;
                BasicView.sharedHighlightArray[i] = list;
                return;
            }
        }
    }

    static class RenderFragment {
        public BaseStyle syntaxStyle;
        public HighlightStyle backgroundHighlight;
        public HighlightStyle foregroundHighlight;
        public String textToUse;
        public HighlightStyle fontHighlight;
        public int startOffset;
        public int endOffset;

        RenderFragment() {
        }

        public Color getForegroundColor() {
            if (this.foregroundHighlight != null && this.foregroundHighlight.getUseForegroundColor()) {
                return this.foregroundHighlight.getForegroundColor();
            }
            return this.syntaxStyle.getForegroundColor();
        }

        public Color getBackgroundColor() {
            if (this.backgroundHighlight != null && this.backgroundHighlight.getUseBackgroundColor()) {
                return this.backgroundHighlight.getBackgroundColor();
            }
            return this.syntaxStyle.getBackgroundColor();
        }

        public int getFontStyle() {
            if (this.fontHighlight != null && this.fontHighlight.getUseFontStyle()) {
                return this.fontHighlight.getFontStyle();
            }
            return this.syntaxStyle.getFontStyle();
        }
    }

    static interface RenderFragmentGenerator {
        public RenderFragment current();

        public RenderFragment next();
    }

    private class Damage {
        private int editCount;
        private int oldRowCount;
        private int oldMaxWidth;
        private int offset;
        private int endOffset;
        private Rectangle bounds;
        private Shape shape;
        private DocumentEvent event;

        private Damage() {
        }
    }

    private class FoldingListener
    implements CodeFoldingModelListener,
    CompoundCodeExpansionListener {
        private FoldingListener() {
        }

        @Override
        public void structureChanged(CodeFoldingModelEvent event) {
            BasicView.this.rebuildFoldedBlocks();
        }

        @Override
        public void codeExpanded(CodeExpansionEvent event) {
            BasicView.this.rebuildFoldedBlocks();
        }

        @Override
        public void codeCollapsed(CodeExpansionEvent event) {
            BasicView.this.rebuildFoldedBlocks();
        }

        @Override
        public void compoundCodeFolds(List<CodeExpansionEvent> events) {
            BasicView.this.rebuildFoldedBlocks();
        }
    }

    private static enum PaintResult {
        SUCCESS,
        FAIL_NO_STYLE,
        FAIL_NO_PAINTER,
        FAIL_NO_RANGE,
        FAIL_FOLDED;

    }
}

