/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.dialogs.progress;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.SwingUtilities;

public class ProgressPanel {
    private static final int MINIMUM_DEFAULT_SIZE = 400;
    private Component _component;
    private String _message;
    private Component _messageComponent;
    private JProgressBar _progressBar;
    private String _note;
    private JLabel _noteLabel;
    private Component _southContent;

    public ProgressPanel(Object message, String note) {
        if (message instanceof Component) {
            this._messageComponent = (Component)message;
        } else {
            this.setMessage((String)message);
        }
        this.setNote(note);
    }

    public Component getGUI() {
        if (this._component == null) {
            this._component = this.createComponent();
        }
        return this._component;
    }

    public void setNote(String note) {
        String string = this._note = note != null && note.equals("") ? " " : note;
        if (this._noteLabel != null) {
            if (SwingUtilities.isEventDispatchThread()) {
                this._noteLabel.setText(this._note);
            } else {
                Runnable runnable = new Runnable(){

                    @Override
                    public void run() {
                        ProgressPanel.this._noteLabel.setText(ProgressPanel.this._note);
                    }
                };
                SwingUtilities.invokeLater(runnable);
            }
        }
    }

    public String getNote() {
        return this._note;
    }

    public void setMessage(String message) {
        String string = this._message = message == null || message.equals("") ? " " : message;
        if (this._messageComponent instanceof JLabel) {
            if (SwingUtilities.isEventDispatchThread()) {
                ((JLabel)this._messageComponent).setText(this._message);
            } else {
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        ((JLabel)ProgressPanel.this._messageComponent).setText(ProgressPanel.this._message);
                    }
                });
            }
        }
    }

    public void setSouthContent(Component content) {
        this._southContent = content;
    }

    public Component getSouthContent() {
        return this._southContent;
    }

    public void setProgressBar(JProgressBar progressBar) {
        this._progressBar = progressBar;
    }

    public JProgressBar getProgressBar() {
        return this._progressBar;
    }

    private Component createComponent() {
        Dimension d;
        if (this._progressBar != null) {
            Dimension d2 = new Dimension(350, this._progressBar.getPreferredSize().height);
            this._progressBar.setPreferredSize(d2);
        }
        this._noteLabel = new JLabel(this._note == null ? "" : this._note);
        JPanel content = new JPanel(new GridBagLayout());
        GridBagConstraints constraints = new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 17, 2, new Insets(5, 5, 5, 5), 0, 0);
        if (this._messageComponent == null) {
            this._messageComponent = new JLabel(this._message == null ? "" : this._message);
        }
        int width = 400;
        if (this._messageComponent != null) {
            content.add(this._messageComponent, constraints);
            width = Math.max(width, this._messageComponent.getPreferredSize().width);
        }
        if (this._progressBar != null) {
            ++constraints.gridy;
            content.add((Component)this._progressBar, constraints);
            width = Math.max(width, this._progressBar.getPreferredSize().width);
        }
        if (this._noteLabel != null) {
            ++constraints.gridy;
            content.add((Component)this._noteLabel, constraints);
            width = Math.max(width, this._noteLabel.getPreferredSize().width);
        }
        if (this._southContent != null) {
            ++constraints.gridy;
            content.add(this._southContent, constraints);
            width = Math.max(width, this._southContent.getPreferredSize().width);
        }
        if (this._progressBar != null) {
            d = new Dimension(width, this._progressBar.getPreferredSize().height);
            this._progressBar.setPreferredSize(d);
            this._progressBar.setMaximumSize(d);
        }
        if (this._noteLabel != null) {
            d = new Dimension(width, this._noteLabel.getPreferredSize().height);
            this._noteLabel.setPreferredSize(d);
            this._noteLabel.setMaximumSize(d);
        }
        return content;
    }
}

