/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.dialogs;

import java.awt.Component;
import java.util.ResourceBundle;
import javax.swing.JCheckBox;
import oracle.bali.share.nls.StringUtils;
import oracle.javatools.dialogs.BaseMessageDialog;
import oracle.javatools.dialogs.MessageDialogPersistence;
import oracle.javatools.dialogs.MessageUtil;
import oracle.javatools.util.SwingUtils;
import oracle.javatools.util.TranslationControl;

public final class MessageDialog {
    public static final int CONFIRM_CANCEL = -1;
    public static final int CONFIRM_NO = 0;
    public static final int CONFIRM_YES = 1;
    private static MessageDialogPersistence _persistence;

    private MessageDialog() {
    }

    public static void setPersistence(MessageDialogPersistence persistence) {
        _persistence = persistence;
    }

    public static void resetSkippedMessages() {
        MessageDialog.getPersistence().clearSettings();
    }

    public static MessageDialogPersistence getPersistence() {
        if (_persistence == null) {
            _persistence = new MessageDialogPersistence();
        }
        return _persistence;
    }

    private static String getDefaultTitle(int type) {
        ResourceBundle bundle = ResourceBundle.getBundle("oracle.javatools.resource.DialogsBundle", (ResourceBundle.Control)TranslationControl.getClassFormatTranslationControl());
        switch (type) {
            case 3: {
                return bundle.getString("MD_DEFAULT_ERROR");
            }
            case 2: {
                return bundle.getString("MD_DEFAULT_INFORMATION");
            }
            case 1: {
                return bundle.getString("MD_DEFAULT_CRITICAL");
            }
            case 4: {
                return bundle.getString("MD_DEFAULT_CONFIRM");
            }
        }
        return "";
    }

    private static boolean runDialog(Component parent, Object message, String title, String helptopic, int type, int defButton, String okText, String cancelText) {
        int mnemonic;
        BaseMessageDialog bmd = BaseMessageDialog.createMessageDialogImpl(parent == null ? SwingUtils.getMainWindow() : parent, title == null ? MessageDialog.getDefaultTitle(type) : title, type);
        bmd.setMessage(message);
        if (helptopic != null) {
            bmd.setHelpTopic(helptopic);
            bmd.setButtonMask(bmd.getButtonMask() + 4);
        }
        bmd.setDefaultButton(defButton);
        if (okText != null) {
            mnemonic = StringUtils.getMnemonicKeyCode((String)okText);
            if (mnemonic == 0) {
                bmd.setOKButtonText(okText);
            } else {
                bmd.setOKButtonText(StringUtils.stripMnemonic((String)okText));
                bmd.setOKButtonMnemonic(mnemonic);
            }
        }
        if (cancelText != null) {
            mnemonic = StringUtils.getMnemonicKeyCode((String)cancelText);
            if (mnemonic == 0) {
                bmd.setCancelButtonText(cancelText);
            } else {
                bmd.setCancelButtonText(StringUtils.stripMnemonic((String)cancelText));
                bmd.setCancelButtonMnemonic(mnemonic);
            }
        }
        return bmd.runDialog();
    }

    private static boolean runDialog(Component parent, Object message, String title, String helptopic, int type, int defButton) {
        return MessageDialog.runDialog(parent, message, title, helptopic, type, defButton, null, null);
    }

    public static void error(Component parent, Object message, String title, String helpTopic) {
        MessageDialog.runDialog(parent, message, title, helpTopic, 3, 1);
    }

    public static boolean optionalConfirm(String id, Component parent, Object message, String title, String helptopic) {
        Boolean confirmed = MessageDialog.getPersistence().getConfirmed(id);
        if (confirmed != null) {
            return confirmed;
        }
        JCheckBox optionalCheckBox = new JCheckBox();
        Component component = MessageUtil.createOptionalMessage(message, optionalCheckBox);
        boolean response = MessageDialog.confirm(parent, component, title, helptopic, false);
        if (optionalCheckBox.isSelected()) {
            MessageDialog.getPersistence().setConfirmed(id, response);
        }
        return response;
    }

    public static int optionalConfirmOrCancel(String id, Component parent, Object message, String title, String helptopic) {
        Boolean confirmed = MessageDialog.getPersistence().getConfirmed(id);
        if (confirmed != null) {
            return confirmed != false ? 1 : 0;
        }
        JCheckBox optionalCheckBox = new JCheckBox();
        Component component = MessageUtil.createOptionalMessage(message, optionalCheckBox);
        int response = MessageDialog.confirmOrCancel(parent, component, title, helptopic, false);
        if (response != -1 && optionalCheckBox.isSelected()) {
            MessageDialog.getPersistence().setConfirmed(id, response == 1);
        }
        return response;
    }

    public static boolean confirm(Component parent, Object message, String title, String helptopic) {
        return MessageDialog.confirm(parent, message, title, helptopic, false);
    }

    public static boolean confirm(Component parent, Object message, String title, String helptopic, boolean isDestructive) {
        return MessageDialog.confirm(parent, message, title, helptopic, isDestructive, null, null);
    }

    public static boolean confirm(Component parent, Object message, String title, String helptopic, boolean isDestructive, String yesText, String noText) {
        return MessageDialog.runDialog(parent, message, title, helptopic, 4, isDestructive ? 2 : 1, yesText, noText);
    }

    public static int confirmOrCancel(Component parent, Object message, String title) {
        return MessageDialog.confirmOrCancel(parent, message, title, null);
    }

    public static int confirmOrCancel(Component parent, Object message, String title, String helptopic) {
        return MessageDialog.confirmOrCancel(parent, message, title, helptopic, false);
    }

    public static int confirmOrCancel(Component parent, Object message, String title, String helptopic, boolean isDestructive) {
        BaseMessageDialog bmd = BaseMessageDialog.createMessageDialogImpl(parent == null ? SwingUtils.getMainWindow() : parent, title == null ? MessageDialog.getDefaultTitle(4) : title, 5);
        bmd.setMessage(message);
        if (helptopic != null) {
            bmd.setHelpTopic(helptopic);
            bmd.setButtonMask(bmd.getButtonMask() + 4);
        }
        bmd.setDefaultButton(isDestructive ? bmd.getNoButton() : bmd.getYesButton());
        boolean ok = bmd.runDialog();
        if (ok) {
            return bmd.isYesClicked() ? 1 : 0;
        }
        return -1;
    }

    public static void optionalInformation(String id, Component parent, Object message, String title, String helptopic) {
        if (!MessageDialog.getPersistence().isHidden(id)) {
            JCheckBox optionalCheckBox = new JCheckBox();
            Component component = MessageUtil.createOptionalMessage(message, optionalCheckBox);
            MessageDialog.runDialog(parent, component, title, helptopic, 2, 1);
            if (optionalCheckBox.isSelected()) {
                MessageDialog.getPersistence().setHidden(id, true);
            }
        }
    }

    public static void information(Component parent, Object message, String title, String helptopic) {
        MessageDialog.runDialog(parent, message, title, helptopic, 2, 1);
    }

    public static void critical(Component parent, Object message, String title, String helptopic) {
        MessageDialog.runDialog(parent, message, title, helptopic, 1, 1);
    }
}

