/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.datatransfer;

import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.io.IOException;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.javatools.datatransfer.AugmentableTransferable;
import oracle.javatools.datatransfer.DataTransferPluginFactory;
import oracle.javatools.datatransfer.ExtendedTransferable;
import oracle.javatools.datatransfer.FetchMode;
import oracle.javatools.datatransfer.ReflectiveDataTransferPluginFactory;
import oracle.javatools.datatransfer.SimpleAugmentableTransferable;
import oracle.javatools.datatransfer.SimpleTransferDataInfo;
import oracle.javatools.datatransfer.TransferDataInfo;

public final class TransferUtils {
    private static final Logger _LOGGER = Logger.getLogger(TransferUtils.class.getName());
    public static final DataFlavor FLAVOR_SAFE_TO_FETCH_CONTENTS_EARLY_MARKER = TransferUtils.createLocalJvmFlavor(SafeToFetchContentsEarlyMarker.class, TransferUtils.class.getClassLoader());

    public static Object getDataIfAvailable(Transferable trans, DataFlavor flavor) {
        if (trans != null && trans.isDataFlavorSupported(flavor)) {
            try {
                return trans.getTransferData(flavor);
            }
            catch (IOException iOException) {
            }
            catch (UnsupportedFlavorException unsupportedFlavorException) {
                // empty catch block
            }
        }
        return null;
    }

    public static Object getDataIfAvailable(Transferable trans, DataFlavor flavor, Class requiredClass) {
        return TransferUtils.getDataIfAvailable(trans, flavor, requiredClass, FetchMode.STANDARD);
    }

    public static Object getDataIfAvailable(Transferable trans, DataFlavor flavor, Class requiredClass, FetchMode mode) {
        Object ret = null;
        if (trans instanceof ExtendedTransferable) {
            ExtendedTransferable et = (ExtendedTransferable)trans;
            TransferDataInfo tdi = et.getHighestRankedData(flavor);
            if (tdi != null) {
                try {
                    ret = tdi.getData(mode, false);
                }
                catch (IOException e) {
                    ret = null;
                }
            }
        } else {
            ret = TransferUtils.getDataIfAvailable(trans, flavor);
        }
        if (requiredClass.isInstance(ret)) {
            return ret;
        }
        return null;
    }

    public static DataFlavor createLocalJvmFlavor(Class c) {
        try {
            return new DataFlavor("application/x-java-jvm-local-objectref;class=" + c.getName());
        }
        catch (ClassNotFoundException cnfe) {
            _LOGGER.log(Level.SEVERE, "Exception creating flavor for " + c, cnfe);
            throw new RuntimeException(cnfe);
        }
    }

    public static DataFlavor createLocalJvmFlavor(Class c, ClassLoader loader) {
        try {
            return new DataFlavor("application/x-java-jvm-local-objectref;class=" + c.getName(), null, loader);
        }
        catch (ClassNotFoundException cnfe) {
            _LOGGER.log(Level.SEVERE, "Exception creating flavor for " + c, cnfe);
            throw new RuntimeException(cnfe);
        }
    }

    public static TransferDataInfo createDataInfo(DataFlavor flavor, Object data, float rank, Map metadata) {
        return new SimpleTransferDataInfo(flavor, data, rank, metadata);
    }

    public static String inventDescription(DataFlavor flavor) {
        Class<?> rc;
        String desc = flavor.getHumanPresentableName();
        if (desc == null) {
            desc = flavor.getMimeType();
        }
        if (desc == null && (rc = flavor.getRepresentationClass()) != null) {
            desc = rc.getName();
        }
        return desc;
    }

    public static AugmentableTransferable createTransferable(Transferable base) {
        if (base instanceof AugmentableTransferable) {
            return ((AugmentableTransferable)base).getCopy();
        }
        return new SimpleAugmentableTransferable(base);
    }

    public static AugmentableTransferable createTransferable() {
        return new SimpleAugmentableTransferable();
    }

    public static AugmentableTransferable asAugmentableTransferable(Transferable original) {
        if (original instanceof AugmentableTransferable) {
            return (AugmentableTransferable)original;
        }
        return TransferUtils.createTransferable(original);
    }

    public static AugmentableTransferable prefetchTransferableContents(Transferable original) {
        if (original == null) {
            throw new IllegalArgumentException("null input");
        }
        return SimpleAugmentableTransferable.createPrefetchedCopy(original);
    }

    public static DataTransferPluginFactory createReflectivePluginFactory(Class pluginClass) {
        return new ReflectiveDataTransferPluginFactory(pluginClass);
    }

    public static float lowerRank(float f) {
        return f * 0.99f;
    }

    public static float higherRank(float f) {
        return f / 0.99f;
    }

    private TransferUtils() {
    }

    public static class SafeToFetchContentsEarlyMarker {
        private SafeToFetchContentsEarlyMarker() {
        }
    }
}

