/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.compare.view;

import java.awt.Color;
import java.awt.EventQueue;
import java.awt.Graphics;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseWheelEvent;
import java.awt.event.MouseWheelListener;
import javax.accessibility.AccessibleContext;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.UIManager;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import oracle.javatools.compare.algorithm.BaseCompareDifference;
import oracle.javatools.compare.view.BaseCompareView;

public abstract class BaseOverview
extends JComponent {
    private final JLabel _accessibleLabel = new JLabel("");
    private final BaseCompareView _view;
    private boolean _isMasked = false;

    protected BaseOverview(BaseCompareView view) {
        this._view = view;
        this.setFocusable(true);
        this.addFocusListener(new FocusAdapter(){

            @Override
            public void focusGained(FocusEvent e) {
                BaseOverview.this.repaint();
                EventQueue.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        BaseOverview.this.updateAccessibleText();
                    }
                });
            }

            @Override
            public void focusLost(FocusEvent e) {
                BaseOverview.this.repaint();
            }
        });
        this.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent me) {
                BaseOverview.this.requestFocusInWindow();
            }
        });
        view.addPositionListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent ce) {
                BaseOverview.this.updateAccessibleText();
                BaseOverview.this.repaint();
            }
        });
        this.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent ke) {
                if ((ke.getKeyCode() == 38 || ke.getKeyCode() == 33) && BaseOverview.this._view.hasPreviousDifference()) {
                    BaseOverview.this._view.goToPreviousDifference();
                }
                if ((ke.getKeyCode() == 40 || ke.getKeyCode() == 34) && BaseOverview.this._view.hasNextDifference()) {
                    BaseOverview.this._view.goToNextDifference();
                }
                if (ke.getKeyCode() == 36 && BaseOverview.this._view.hasNavigableDifferences()) {
                    BaseOverview.this._view.goToFirstDifference();
                }
                if (ke.getKeyCode() == 35 && BaseOverview.this._view.hasNavigableDifferences()) {
                    BaseOverview.this._view.goToLastDifference();
                }
            }
        });
        this.addMouseWheelListener(new MouseWheelListener(){

            @Override
            public void mouseWheelMoved(MouseWheelEvent mwe) {
                if (mwe.getWheelRotation() == 0) {
                    return;
                }
                if (mwe.getWheelRotation() > 0) {
                    BaseOverview.this._view.goToNextDifference();
                }
                if (mwe.getWheelRotation() < 0) {
                    BaseOverview.this._view.goToPreviousDifference();
                }
            }
        });
    }

    void updateAccessibleText() {
        BaseCompareDifference diff = (BaseCompareDifference)this._view.getCurrentDifference();
        if (!this.isFocusOwner() || diff == null) {
            this._accessibleLabel.setText(this._view.getBundle().getString("ACC_OVERVIEW_NO_DIFF_SELECTED"));
            return;
        }
        String accessibleDifferenceText = this.getAccessibleDifferenceText(diff);
        this._accessibleLabel.setText(accessibleDifferenceText != null ? accessibleDifferenceText : "");
    }

    protected abstract String getAccessibleDifferenceText(BaseCompareDifference var1);

    @Override
    public AccessibleContext getAccessibleContext() {
        if (this.accessibleContext == null) {
            this.accessibleContext = this._accessibleLabel.getAccessibleContext();
        }
        return this.accessibleContext;
    }

    public void setMasked(boolean masked) {
        this.repaint();
    }

    public boolean isMasked() {
        return this._isMasked;
    }

    protected void paintFocus(Graphics g) {
        if (this.isFocusOwner()) {
            Color focus = UIManager.getColor("Button.focus");
            g.setColor(focus != null ? focus : UIManager.getColor("controlShadow"));
            g.drawRect(0, 0, this.getWidth() - 1, this.getHeight() - 1);
        }
    }
}

