/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.clipboard;

import java.awt.GraphicsEnvironment;
import java.awt.Toolkit;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.io.IOException;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.StringTokenizer;
import oracle.javatools.clipboard.ClipboardStackDialog;
import oracle.javatools.ui.internal.Exceptions;

public class ClipboardStack {
    private static final int DEFAULT_MAX_ITEMS = 30;
    private static LinkedList<Entry> entries = new LinkedList();
    private static int _maxItems = 30;
    private static Clipboard clipboard = GraphicsEnvironment.isHeadless() ? null : Toolkit.getDefaultToolkit().getSystemClipboard();

    private ClipboardStack() {
    }

    public static boolean adjustCurrentClipboard() {
        ClipboardStackDialog dialog = new ClipboardStackDialog();
        Entry entry = dialog.runDialog();
        return ClipboardStack.adjustCurrentClipboard(entry);
    }

    public static boolean adjustCurrentClipboard(Entry entry) {
        if (entry != null) {
            if (entries.remove(entry)) {
                ClipboardStack.pushCurrentClipboard();
            }
            clipboard.setContents(entry.getTransferable(), null);
            return true;
        }
        return false;
    }

    public static void pushCurrentClipboard() {
        Transferable t = ClipboardStack.getCurrentTransferable();
        if (t != null) {
            Entry entry = ClipboardStack.createEntry(t);
            if (entry == null) {
                return;
            }
            try {
                LinkedList<Entry> toRemove = new LinkedList<Entry>();
                Object entryString = t.getTransferData(DataFlavor.stringFlavor);
                for (Entry stackEntry : entries) {
                    Object stackString = stackEntry.getTransferable().getTransferData(DataFlavor.stringFlavor);
                    if (!entryString.equals(stackString)) continue;
                    toRemove.add(stackEntry);
                }
                for (Entry stackEntry : toRemove) {
                    entries.remove(stackEntry);
                }
            }
            catch (UnsupportedFlavorException e) {
                Exceptions.swallow((Throwable)e);
            }
            catch (IOException e) {
                Exceptions.swallow((Throwable)e);
            }
            entries.addFirst(entry);
            while (entries.size() > _maxItems) {
                entries.removeLast();
            }
        }
    }

    private static Transferable getCurrentTransferable() {
        Transferable transferable = clipboard.getContents(null);
        if (transferable != null) {
            try {
                if (transferable.isDataFlavorSupported(DataFlavor.stringFlavor)) {
                    return transferable;
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return null;
    }

    private static Entry createEntry(Transferable tt) {
        if (tt == null) {
            return null;
        }
        try {
            String name = "";
            String value = (String)tt.getTransferData(DataFlavor.stringFlavor);
            StringTokenizer tokenizer = new StringTokenizer(value, "\n");
            while (tokenizer.hasMoreTokens()) {
                String line = tokenizer.nextToken();
                String trimmedLine = line.trim();
                if (trimmedLine.length() <= 0) continue;
                name = trimmedLine;
                break;
            }
            if (tt != null) {
                return new Entry(name, tt);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return null;
    }

    public static List<Entry> getContent() {
        ClipboardStack.pushCurrentClipboard();
        return Collections.unmodifiableList(entries);
    }

    public static void setClipboard(Clipboard clip) {
        clipboard = clip;
    }

    public static class Entry {
        private String name;
        private Transferable transferable;

        private Entry(String name, Transferable transferable) {
            this.name = name;
            this.transferable = transferable;
        }

        public String getName() {
            return this.name;
        }

        public Transferable getTransferable() {
            return this.transferable;
        }
    }
}

