/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.border;

import java.awt.Color;
import java.awt.Graphics;
import java.awt.Insets;
import oracle.javatools.border.MultiSideBorder;

class TopBottomBorder
extends MultiSideBorder {
    public TopBottomBorder(Color topColor, int topThickness, Color bottomColor, int bottomThickness) {
        super(topColor, topThickness, null, 0, bottomColor, bottomThickness, null, 0);
    }

    @Override
    protected void drawTopBorder(Graphics g, int width, int height) {
        for (int i = 0; i < this.topThickness; ++i) {
            g.drawLine(0, i, width - 1, i);
        }
    }

    @Override
    protected void drawBottomBorder(Graphics g, int width, int height) {
        for (int i = 0; i < this.bottomThickness; ++i) {
            g.drawLine(0, height - i - 1, width - 1, height - i - 1);
        }
    }

    @Override
    protected void setInsets(Insets insets) {
        insets.top = this.topThickness;
        insets.bottom = this.bottomThickness;
        insets.right = 0;
        insets.left = 0;
    }
}

