/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.help;

import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import oracle.ide.help.HelpUtils;
import oracle.ide.net.URLFactory;
import oracle.jdevimpl.help.AbstractRSSQueryHandler;
import oracle.jdevimpl.help.HelpSearchResult;
import oracle.jdevimpl.help.TahitiSearchResult;
import oracle.jdevimpl.help.UserQuery;

public class TahitiQueryHandler
extends AbstractRSSQueryHandler {
    public static final String TAHITI_QUERY_HOST = "${TAHITI_QUERY_HOST}";
    public static final String TAHITI_INCLUDE_BOOK_LIST = "${TAHITI_INCLUDE_LIST}";
    public static final String DB_PROC_NAME = "${DB_PROC_NAME}";
    public static final String URL_BEGINNING = "/pls/";
    private static final String DEFAULT_INCLUDES = "b31974,b31973,e10139,e10148,e10224,e10138";
    protected List<String> _searchList;
    protected boolean _localInSearch;

    public void setSearchList(List<String> searchList) {
        this._searchList = searchList;
    }

    public void setLocalInSearch(boolean localInSearch) {
        this._localInSearch = localInSearch;
    }

    private String createQueryString(String searchText, String section) {
        String queryString = "word=" + searchText + "&format=rss&high=200";
        if (!section.equals(UserQuery.getDBLibraryName())) {
            queryString = queryString + this.buildIncludeSection();
        }
        return this.htmlEncodeString(queryString);
    }

    private String buildIncludeSection() {
        String includes = HelpUtils.substituteMacros((String)TAHITI_INCLUDE_BOOK_LIST);
        if (includes.equals(TAHITI_INCLUDE_BOOK_LIST)) {
            includes = DEFAULT_INCLUDES;
        }
        String[] incs = includes.split(",");
        StringBuffer sb = new StringBuffer(100);
        for (String include : incs) {
            sb.append("&incl=");
            sb.append(include);
        }
        return sb.toString();
    }

    @Override
    protected List<URL> createSearchURLs(String searchText) {
        ArrayList<URL> urlList = new ArrayList<URL>(2);
        for (String section : this._searchList) {
            String dbProc;
            String urlHost = HelpUtils.substituteMacros((String)TAHITI_QUERY_HOST);
            if (urlHost.equals(TAHITI_QUERY_HOST)) {
                urlHost = "http://tahiti-stage.us.oracle.com";
            }
            if ((dbProc = HelpUtils.substituteMacros((String)DB_PROC_NAME)).equals(DB_PROC_NAME)) {
                dbProc = "search";
            }
            String urlString = urlHost + URL_BEGINNING + section + "/" + dbProc + "?";
            try {
                URL url = new URL(urlString);
                url = URLFactory.replaceQueryPart((URL)url, (String)this.createQueryString(searchText, section));
                urlList.add(url);
            }
            catch (MalformedURLException muex) {
                muex.printStackTrace();
            }
        }
        return urlList;
    }

    @Override
    protected HelpSearchResult createSearchResult(String title, String link, String description) {
        return new TahitiSearchResult(title, link, description);
    }
}

