/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.help;

import java.awt.AWTEvent;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.Toolkit;
import java.awt.event.AWTEventListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.ButtonGroup;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JLayeredPane;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JRootPane;
import javax.swing.LayoutFocusTraversalPolicy;
import javax.swing.SwingUtilities;
import oracle.bali.share.nls.StringUtils;
import oracle.ide.controls.ButtonKeyController;
import oracle.ide.controls.Toolbar;
import oracle.ide.controls.customtab.CustomTab;
import oracle.ide.help.HelpSystem;
import oracle.ide.util.ResourceUtils;
import oracle.jdevimpl.help.HelpArb;
import oracle.jdevimpl.help.HelpOptions;
import oracle.jdevimpl.help.HelpUtils;
import org.jdesktop.animation.timing.TimingController;
import org.jdesktop.animation.timing.TimingTarget;
import org.jdesktop.animation.timing.interpolation.ObjectModifier;
import org.jdesktop.animation.timing.interpolation.PropertyRange;

class SearchOptionsPanel
extends JPanel {
    private JCheckBox _matchCase;
    private JRadioButton _allWords;
    private JRadioButton _anyWords;
    private JRadioButton _booleanExpression;
    private JLayeredPane _layeredPane;
    private JCheckBox _includeLocal;
    private JCheckBox _includeOTN;
    private JLabel _tahitiLabel;
    private JCheckBox _includeFusionMiddleware;
    private JCheckBox _includeDatabase;
    private AWTEventListener _awtEventListener;
    private FocusLossListener _focusLossListener;

    private SearchOptionsPanel() {
        this.setLayout(new BoxLayout(this, 1));
        this.setBackground(Color.WHITE);
        this._includeLocal = new JCheckBox();
        this.labelButton(this._includeLocal, HelpArb.getString(75));
        this._matchCase = new JCheckBox();
        this.labelButton(this._matchCase, HelpArb.getString(71));
        this._matchCase.setBorder(BorderFactory.createEmptyBorder(5, 10, 0, 5));
        this._allWords = new JRadioButton();
        this.labelButton(this._allWords, HelpArb.getString(72));
        this._allWords.setBorder(BorderFactory.createEmptyBorder(7, 10, 2, 5));
        this._anyWords = new JRadioButton();
        this.labelButton(this._anyWords, HelpArb.getString(73));
        this._anyWords.setBorder(BorderFactory.createEmptyBorder(5, 10, 2, 5));
        this._booleanExpression = new JRadioButton();
        this.labelButton(this._booleanExpression, HelpArb.getString(74));
        this._booleanExpression.setBorder(BorderFactory.createEmptyBorder(5, 10, 7, 5));
        ButtonGroup rbg = new ButtonGroup();
        rbg.add(this._allWords);
        rbg.add(this._anyWords);
        rbg.add(this._booleanExpression);
        boolean OTNAvailable = HelpUtils.isOTNSearchAvailable();
        this._includeOTN = new JCheckBox();
        this._includeOTN.setSelected(false);
        if (OTNAvailable) {
            this.labelButton(this._includeOTN, HelpArb.getString(76));
            this._includeOTN.setBorder(BorderFactory.createEmptyBorder(10, 0, 10, 5));
        }
        this._tahitiLabel = new JLabel(StringUtils.stripMnemonic((String)HelpArb.getString(77)));
        this._includeFusionMiddleware = new JCheckBox();
        this.labelButton(this._includeFusionMiddleware, HelpArb.getString(78));
        this._includeFusionMiddleware.setBorder(BorderFactory.createEmptyBorder(4, 10, 0, 0));
        this._includeDatabase = new JCheckBox();
        this.labelButton(this._includeDatabase, HelpArb.getString(79));
        this._includeDatabase.setBorder(BorderFactory.createEmptyBorder(4, 10, 0, 0));
        this.add(this._includeLocal);
        this.add(this._matchCase);
        this.add(this._allWords);
        this.add(this._anyWords);
        this.add(this._booleanExpression);
        if (OTNAvailable) {
            this.add(this._includeOTN);
        }
        this.add(this._tahitiLabel);
        this.add(this._includeFusionMiddleware);
        this.add(this._includeDatabase);
        this.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createLineBorder(Color.BLACK), BorderFactory.createEmptyBorder(4, 4, 4, 4)));
        ButtonKeyController.attach((AbstractButton[])new AbstractButton[]{this._matchCase, this._allWords, this._anyWords, this._booleanExpression, this._includeOTN, this._includeFusionMiddleware, this._includeDatabase});
        this.loadOptions();
        super.setFocusTraversalPolicy(new LayoutFocusTraversalPolicy());
        this.setFocusTraversalPolicyProvider(true);
        HelpSystem.getHelpSystem().registerTopic((JComponent)this, "f1_searchoptions_html");
    }

    public static SearchOptionsPanel getSearchOptionsPanel() {
        return new SearchOptionsPanel();
    }

    void show(Component reference, int x, int y) {
        JRootPane rootPane = SwingUtilities.getRootPane(reference);
        if (rootPane != null) {
            this._layeredPane = rootPane.getLayeredPane();
            this._layeredPane.add((Component)this, JLayeredPane.PALETTE_LAYER);
            this.setVisible(true);
            Dimension preferredSize = this.getPreferredSize();
            Point point = SwingUtilities.convertPoint(reference, x, y, this._layeredPane);
            if (point.x + preferredSize.width > this._layeredPane.getWidth()) {
                point.x = Math.max(0, this._layeredPane.getWidth() - preferredSize.width);
            }
            this.setLocation(point);
            Dimension from = new Dimension(preferredSize.width, 0);
            Dimension to = new Dimension(preferredSize.width, preferredSize.height);
            PropertyRange range = PropertyRange.createPropertyRangeDimension((String)"size", (Dimension[])new Dimension[]{from, to});
            ObjectModifier modifier = new ObjectModifier((Object)this, range);
            TimingController controller = new TimingController(100, (TimingTarget)modifier){

                public void timingEvent(long l, long l1, float v) {
                    super.timingEvent(l, l1, v);
                    SearchOptionsPanel.this.revalidate();
                    SearchOptionsPanel.this.repaint();
                }

                public void end() {
                    SearchOptionsPanel.this._includeLocal.requestFocus();
                }
            };
            controller.start();
            this.addOrRemoveFocusListener(true);
        }
        if (this._awtEventListener == null) {
            this._awtEventListener = new SearchOptionsAWTEventListener(this);
            Toolkit.getDefaultToolkit().addAWTEventListener(this._awtEventListener, 16L);
        }
    }

    void dismiss(boolean saveOptions) {
        if (saveOptions) {
            this.saveOptions();
        }
        if (this._layeredPane != null) {
            this.setVisible(false);
            this._layeredPane.remove(this);
        }
        this._layeredPane = null;
        if (this._awtEventListener != null) {
            Toolkit.getDefaultToolkit().removeAWTEventListener(this._awtEventListener);
            this._awtEventListener = null;
        }
    }

    private void addOrRemoveFocusListener(boolean add) {
        if (add) {
            this._focusLossListener = new FocusLossListener();
            this._includeLocal.addFocusListener(this._focusLossListener);
            this._matchCase.addFocusListener(this._focusLossListener);
            this._allWords.addFocusListener(this._focusLossListener);
            this._anyWords.addFocusListener(this._focusLossListener);
            this._booleanExpression.addFocusListener(this._focusLossListener);
            this._includeOTN.addFocusListener(this._focusLossListener);
            this._tahitiLabel.addFocusListener(this._focusLossListener);
            this._includeFusionMiddleware.addFocusListener(this._focusLossListener);
            this._includeDatabase.addFocusListener(this._focusLossListener);
        } else if (this._focusLossListener != null) {
            this._includeLocal.removeFocusListener(this._focusLossListener);
            this._matchCase.removeFocusListener(this._focusLossListener);
            this._allWords.removeFocusListener(this._focusLossListener);
            this._anyWords.removeFocusListener(this._focusLossListener);
            this._booleanExpression.removeFocusListener(this._focusLossListener);
            this._includeOTN.removeFocusListener(this._focusLossListener);
            this._tahitiLabel.removeFocusListener(this._focusLossListener);
            this._includeFusionMiddleware.removeFocusListener(this._focusLossListener);
            this._includeDatabase.removeFocusListener(this._focusLossListener);
        }
    }

    private void labelButton(AbstractButton button, String label) {
        ResourceUtils.resButton((AbstractButton)button, (String)label);
        button.setOpaque(false);
    }

    private void loadOptions() {
        HelpOptions helpOptions = HelpOptions.getInstance();
        this._includeLocal.setSelected(helpOptions.includeLocal());
        this._matchCase.setSelected(helpOptions.getLocalCaseSensitiveSearch());
        switch (helpOptions.getLocalSearchType()) {
            case 0: {
                this._allWords.setSelected(true);
                break;
            }
            case 1: {
                this._anyWords.setSelected(true);
                break;
            }
            case 2: {
                this._booleanExpression.setSelected(true);
            }
        }
        this._includeOTN.setSelected(helpOptions.includeOTN());
        this._includeFusionMiddleware.setSelected(helpOptions.includeFusionMiddleware());
        this._includeDatabase.setSelected(helpOptions.includeDatabase());
    }

    void saveOptions() {
        HelpOptions helpOptions = HelpOptions.getInstance();
        helpOptions.setIncludeLocal(this._includeLocal.isSelected());
        helpOptions.setLocalCaseSensitiveSearch(this._matchCase.isSelected());
        int searchType = 0;
        searchType = this._allWords.isSelected() ? 0 : (this._anyWords.isSelected() ? 1 : 2);
        helpOptions.setLocalSearchType(searchType);
        helpOptions.setIncludeOTN(this._includeOTN.isSelected());
        helpOptions.setIncludeFusionMiddleware(this._includeFusionMiddleware.isSelected());
        helpOptions.setIncludeDatabase(this._includeDatabase.isSelected());
    }

    private static class SearchOptionsAWTEventListener
    implements AWTEventListener {
        private SearchOptionsPanel _panel;

        public SearchOptionsAWTEventListener(SearchOptionsPanel panel) {
            this._panel = panel;
        }

        @Override
        public void eventDispatched(AWTEvent event) {
            if (event.getID() == 500 && event.getSource() instanceof Component && (event.getSource() instanceof Toolbar || event.getSource() instanceof CustomTab)) {
                this._panel.dismiss(true);
            }
        }
    }

    private class FocusLossListener
    extends FocusAdapter {
        private FocusLossListener() {
        }

        @Override
        public void focusLost(FocusEvent e) {
            Component newFocus = e.getOppositeComponent();
            Component oldFocus = e.getComponent();
            if (!this.isChildOfSearchPanel(newFocus) && this.isChildOfSearchPanel(oldFocus)) {
                SearchOptionsPanel.this.dismiss(true);
            }
        }

        private boolean isChildOfSearchPanel(Component c) {
            return c != null && c.getParent() != null && c.getParent() instanceof SearchOptionsPanel;
        }
    }
}

