/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.help;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.Reader;
import java.net.URL;
import oracle.help.common.IndirectTarget;
import oracle.help.common.Target;
import oracle.help.common.Topic;
import oracle.help.common.TopicTree;
import oracle.help.common.TopicTreeNode;
import oracle.help.common.View;
import oracle.help.common.xml.Parser;
import oracle.help.common.xml.ParserFactory;
import oracle.help.common.xml.XMLNode;
import oracle.help.common.xml.XMLParseException;
import oracle.help.engine.DataEngine;
import oracle.help.library.Book;
import oracle.jdevimpl.help.MultipleTypeTopic;

public class JDevXMLTOCEngine
extends DataEngine {
    private Book _book;
    private static final String TAG_TOC = "toc";
    private static final String TAG_TOCITEM = "tocitem";
    private static final String PROP_ID = "target";
    private static final String PROP_TEXT = "text";
    private static final String PROP_IMAGE = "image";
    private static final String PROP_EXPANDED_NODE_IMAGE = "expandedNodeImage";
    private static final String PROP_COLLAPSED_NODE_IMAGE = "collapsedNodeImage";
    private static final String PROP_ID_TYPE = "topicType";

    public Object createDataObject(View view, String basePath, URL url, String encoding) throws IOException {
        if (url == null) {
            throw new IllegalArgumentException("Null parameter passed to DataEngine constructor");
        }
        BufferedReader r = this._getBufferedReader(url, encoding);
        return this.createDataObject(view, basePath, r);
    }

    public Object createDataObject(View view, String basePath, BufferedReader reader) throws IOException {
        this._book = null;
        if (view != null) {
            this._book = view.getBook();
        }
        TopicTree tocTree = new TopicTree(this._book, basePath);
        TopicTreeNode parent = tocTree.getRoot();
        Parser parser = ParserFactory.createParser((Reader)reader);
        XMLNode xmlRoot = parser.getRoot();
        this._handleToc(xmlRoot.getFirstChild(), parent, view);
        return tocTree;
    }

    private void _handleToc(XMLNode xmlNode, TopicTreeNode node, View view) throws XMLParseException {
        if (xmlNode == null) {
            throw new XMLParseException("No toplevel tag");
        }
        if (!xmlNode.getTokenValue().equalsIgnoreCase(TAG_TOC)) {
            throw new XMLParseException("Toplevel tag is not TOC: " + xmlNode.getTokenValue());
        }
        for (xmlNode = xmlNode.getFirstChild(); xmlNode != null; xmlNode = xmlNode.getNextSibling()) {
            this._handleTocItem(xmlNode, node, view);
        }
    }

    private void _handleTocItem(XMLNode xmlNode, TopicTreeNode parent, View view) throws XMLParseException {
        String closedImageId;
        String openImageId;
        if (!xmlNode.getTokenValue().equalsIgnoreCase(TAG_TOCITEM)) {
            throw new XMLParseException("Tag is not tocitem: " + xmlNode.getTokenValue());
        }
        String tokenId = xmlNode.getTokenProperty(PROP_ID);
        String label = xmlNode.getTokenProperty(PROP_TEXT);
        String topicTypeString = xmlNode.getTokenProperty(PROP_ID_TYPE);
        MultipleTypeTopic topic = null;
        if (topicTypeString != null) {
            topic = new MultipleTypeTopic(label, tokenId, topicTypeString);
        } else {
            topic = new MultipleTypeTopic(label);
            if (tokenId != null) {
                IndirectTarget target = new IndirectTarget(this._book, tokenId);
                topic.setTarget((Target)target);
            }
        }
        String imageId = xmlNode.getTokenProperty(PROP_IMAGE);
        if (imageId != null) {
            IndirectTarget imageTarget = new IndirectTarget(this._book, imageId);
            topic.setDefaultIcon((Target)imageTarget);
        }
        if ((openImageId = xmlNode.getTokenProperty(PROP_EXPANDED_NODE_IMAGE)) != null) {
            IndirectTarget imageTarget = new IndirectTarget(this._book, openImageId);
            topic.setActiveIcon((Target)imageTarget);
        }
        if ((closedImageId = xmlNode.getTokenProperty(PROP_COLLAPSED_NODE_IMAGE)) != null) {
            IndirectTarget imageTarget = new IndirectTarget(this._book, closedImageId);
            topic.setDefaultIcon((Target)imageTarget);
        }
        TopicTreeNode newNode = new TopicTreeNode(view, (Topic)topic);
        parent.addChild(newNode);
        for (xmlNode = xmlNode.getFirstChild(); xmlNode != null; xmlNode = xmlNode.getNextSibling()) {
            this._handleTocItem(xmlNode, newNode, view);
        }
    }
}

