/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.help;

import java.awt.print.PageFormat;
import java.awt.print.Paper;
import java.awt.print.Printable;
import java.awt.print.PrinterJob;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import oracle.help.common.Topic;
import oracle.help.htmlBrowser.HTMLBrowser;
import oracle.help.topicDisplay.TopicDisplay;
import oracle.help.topicDisplay.print.TopicPrintJob;
import oracle.ide.Context;
import oracle.ide.print.DocumentPrintFactory;
import oracle.ide.print.PrintManager;
import oracle.ide.util.Assert;
import oracle.jdevimpl.help.HelpCenterWindow;
import oracle.jdevimpl.help.HelpContentPanel;
import oracle.jdevimpl.help.HelpContext;
import oracle.jdevimpl.help.HelpTopicEditor;
import oracle.jdevimpl.help.HelpWindow;

public class HelpTopicDocumentPrintFactory
extends DocumentPrintFactory {
    private Context _context;
    private Printable _printable;
    private static double PAGE_MARGIN = 54.0;

    public void create(Context context) {
        this._context = context;
        if (this._context != null) {
            if (this._context.getView() instanceof HelpTopicEditor) {
                HelpTopicEditor helpTopicEditor = (HelpTopicEditor)this._context.getView();
                HTMLBrowser browser = helpTopicEditor.getBrowser();
                URL[] urls = new URL[]{helpTopicEditor.getTopicDisplay().getCurrentURL()};
                this._printable = browser.getPrintable(urls);
                PageFormat pf = this.configurePageFormat();
                PrintManager.getPrintManager().setPrintable(this._printable, pf);
            } else if (this._context.getView() instanceof HelpContentPanel) {
                HelpContentPanel helpContentPanel = (HelpContentPanel)this._context.getView();
                HTMLBrowser browser = helpContentPanel.getBrowser();
                URL[] urls = new URL[]{helpContentPanel.getTopicPanel().getCurrentURL()};
                this._printable = browser.getPrintable(urls);
                PageFormat pf = this.configurePageFormat();
                PrintManager.getPrintManager().setPrintable(this._printable, pf);
            } else if (this._context.getView() instanceof HelpCenterWindow.HelpCenterView) {
                Object browserClass = null;
                HelpWindow helpWindow = HelpCenterWindow.getInstance().getHelpWindow();
                Topic[] topics = HelpContext.getTopics(this._context);
                if (topics == null) {
                    topics = new Topic[]{helpWindow.getTOCNavigator().getCurrentSelection()};
                }
                if (topics != null && topics.length > 0) {
                    HTMLBrowser browser = null;
                    browser = HelpContentPanel.createHTMLBrowser();
                    if (browser == null) {
                        return;
                    }
                    ArrayList<URL> urlList = new ArrayList<URL>(topics.length);
                    for (int i = 0; i < topics.length; ++i) {
                        try {
                            if (!topics[i].hasTarget()) continue;
                            URL url = topics[i].getTarget().getURL();
                            urlList.add(url);
                            continue;
                        }
                        catch (MalformedURLException url) {
                            // empty catch block
                        }
                    }
                    URL[] urls = urlList.toArray(new URL[urlList.size()]);
                    this._printable = browser.getPrintable(urls);
                    PageFormat pf = this.configurePageFormat();
                    PrintManager.getPrintManager().setPrintable(this._printable, pf);
                }
            }
        }
    }

    public boolean isPrintingEnabled(Context context) {
        if (context != null) {
            if (context.getView() instanceof HelpWindow) {
                return ((HelpWindow)context.getView()).isPrintingEnabled();
            }
            if (context.getView() instanceof HelpTopicEditor) {
                return true;
            }
            if (context.getView() instanceof HelpContentPanel) {
                return true;
            }
        }
        return false;
    }

    private void printIt(TopicDisplay topicDisplay, Topic[] topics) {
        TopicPrintJob printJob = topicDisplay.getTopicPrintJob();
        if (printJob != null) {
            if (topics.length == 1) {
                printJob.printTopic(topics[0]);
            } else {
                printJob.printTopics(topics);
            }
        } else {
            Assert.println((String)"Error in printing printJob == null");
        }
    }

    private PageFormat configurePageFormat() {
        PageFormat pf = PrintManager.getPrintManager().getPageFormat();
        PrinterJob printerJob = PrinterJob.getPrinterJob();
        if (pf == null) {
            pf = printerJob.defaultPage();
        }
        Paper paper = pf.getPaper();
        double paperWidth = paper.getWidth();
        double paperHeight = paper.getHeight();
        paper.setImageableArea(PAGE_MARGIN, PAGE_MARGIN, paperWidth - 2.0 * PAGE_MARGIN, paperHeight - 2.0 * PAGE_MARGIN);
        pf.setPaper(paper);
        pf = printerJob.validatePage(pf);
        return pf;
    }
}

