/*
 * Decompiled with CFR 0.152.
 */
package oracle.ideimpl.palette.wizard;

import java.awt.Component;
import java.awt.Frame;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyVetoException;
import java.beans.VetoableChangeListener;
import java.util.Iterator;
import java.util.Vector;
import javax.swing.JDialog;
import oracle.bali.ewt.dialog.JEWTDialog;
import oracle.ide.Context;
import oracle.ide.Ide;
import oracle.ide.dialogs.MessageDialog;
import oracle.ide.dialogs.WizardLauncher;
import oracle.ide.palette.PalettePage;
import oracle.ideimpl.palette.PaletteArb;
import oracle.ideimpl.palette.PaletteImpl;
import oracle.ideimpl.palette.PalettePageImpl;
import oracle.ideimpl.palette.PalettePagePanel;
import oracle.ideimpl.palette.model.Page;
import oracle.ideimpl.palette.wizard.PagePanel;

public class NewPageWizard
implements VetoableChangeListener {
    private PalettePagePanel _pagePanel;
    private final PaletteImpl _palette = PaletteImpl.getInstance();
    private JEWTDialog _dlg;
    private PalettePage _palettePage;

    @Deprecated
    public boolean invoke(String type, Context context, Vector list) throws Exception {
        return this.invoke(type, context, list.toArray(new String[list.size()]));
    }

    public boolean invoke(String type, Context context, String ... pageTypes) {
        if (this._pagePanel == null) {
            this._pagePanel = new PalettePagePanel();
        }
        this._dlg = new JEWTDialog((Frame)Ide.getMainWindow(), PaletteArb.getString(80), 7);
        this._pagePanel.populatePageTypesModel(pageTypes);
        this._pagePanel.setCurrentType(type);
        this._pagePanel.getAccessibleContext().setAccessibleName("New Palette Page Dialog");
        this._pagePanel.getAccessibleContext().setAccessibleDescription("Create A New Palette Page");
        this._dlg.setContent((Component)this._pagePanel);
        this._dlg.setResizable(true);
        this._dlg.addVetoableChangeListener((VetoableChangeListener)this);
        this._pagePanel.getPageNameFld().requestFocus();
        boolean ok = WizardLauncher.runDialog((JDialog)this._dlg);
        return ok;
    }

    @Override
    public void vetoableChange(PropertyChangeEvent evt) throws PropertyVetoException {
        if (JEWTDialog.isDialogClosingEvent((PropertyChangeEvent)evt)) {
            String newPageName = this._pagePanel.getPageName();
            String pageType = this._pagePanel.getPageType();
            Page page = new Page();
            page.setName(newPageName);
            page.setType(pageType);
            page.setView("list");
            if (pageType.equalsIgnoreCase(PagePanel.TYPE_SNIPPET)) {
                page.setPaletteContext("oracle.jdevimpl.palette.CodeSnippetContext");
                page.setType(PagePanel.TYPE_SNIPPET);
            }
            this._palettePage = new PalettePageImpl(page);
            boolean addedPage = this.checkIfValidPage(this._palettePage);
            if (!addedPage) {
                this._pagePanel.getPageNameFld().setText("");
                this._pagePanel.getPageNameFld().requestFocus();
                this._palettePage = null;
                throw new PropertyVetoException("no", evt);
            }
        }
    }

    public boolean checkIfValidPage(PalettePage palettePage) {
        Iterator iter = this._palette.getChildren();
        while (iter.hasNext()) {
            PalettePage pg = (PalettePage)iter.next();
            if (!pg.getShortLabel().equals(palettePage.getShortLabel())) continue;
            MessageDialog.error((Component)this._dlg, (Object)PaletteArb.format(79, palettePage.getShortLabel()), (String)PaletteArb.getString(78), null);
            return false;
        }
        String name = palettePage.getShortLabel();
        String newName = name.trim();
        if (newName.length() == 0) {
            MessageDialog.error((Component)this._dlg, (Object)PaletteArb.getString(82), (String)PaletteArb.getString(81), null);
            return false;
        }
        return true;
    }

    public PalettePage getPalettePage() {
        return this._palettePage;
    }
}

