/*
 * Decompiled with CFR 0.152.
 */
package oracle.ideimpl.palette;

import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.ArrayList;
import java.util.Iterator;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JPanel;
import oracle.ide.help.HelpSystem;
import oracle.ide.palette.PalettePage;
import oracle.ideimpl.palette.PaletteController;
import oracle.ideimpl.palette.PaletteItemImpl;
import oracle.ideimpl.palette.PaletteItemUI;
import oracle.ideimpl.palette.model.Item;

public abstract class IconPanel
extends JPanel
implements MouseListener {
    protected final PaletteController _controller = PaletteController.getInstance();
    protected boolean _listView = false;
    protected ArrayList _iconList = new ArrayList();
    protected PalettePage _palettePage;

    public IconPanel(PalettePage palettePage) {
        this.addMouseListener(this);
        this.setPalettePage(palettePage);
        HelpSystem helpSystem = HelpSystem.getHelpSystem();
        if (helpSystem != null) {
            helpSystem.registerTopic((JComponent)this, "f1_idecomponentpalette_html");
        }
    }

    abstract void removeChildren();

    public abstract void addIconLabels(boolean var1);

    public abstract void useListView(boolean var1);

    protected void setIconList(ArrayList iconList) {
        this._iconList = iconList;
    }

    public ArrayList getIconList() {
        return this._iconList;
    }

    @Override
    public void mouseClicked(MouseEvent e) {
    }

    @Override
    public void mousePressed(MouseEvent e) {
        this._controller.getPalette().setActivePage(this.getPalettePage());
        this._controller.tryPopup(e);
    }

    @Override
    public void mouseReleased(MouseEvent e) {
        this._controller.getPalette().setActivePage(this.getPalettePage());
        this._controller.tryPopup(e);
    }

    @Override
    public void mouseEntered(MouseEvent e) {
        if (e.getSource() instanceof JButton) {
            ((JButton)e.getSource()).setBorderPainted(true);
        }
    }

    @Override
    public void mouseExited(MouseEvent e) {
        if (e.getSource() instanceof JButton) {
            ((JButton)e.getSource()).setBorderPainted(false);
        }
    }

    private void setPalettePage(PalettePage palettePage) {
        this._palettePage = palettePage;
    }

    public PalettePage getPalettePage() {
        return this._palettePage;
    }

    public void setListView(boolean listView) {
        this._listView = listView;
    }

    public boolean getListView() {
        return this._listView;
    }

    protected void refreshList() {
        this._iconList = new ArrayList();
        if (this._palettePage == null) {
            return;
        }
        Iterator iconIter = this._palettePage.getPaletteItems().iterator();
        this._iconList.add(new PaletteItemUI(new PaletteItemImpl(true)));
        while (iconIter.hasNext()) {
            PaletteItemImpl pi = (PaletteItemImpl)iconIter.next();
            if (pi == null) continue;
            this._iconList.add(new PaletteItemUI(pi));
        }
        this.setIconList(this._iconList);
        this.removeChildren();
        this.addIconLabels(this.getListView());
    }

    protected void populateIconList() {
        if (this._iconList.size() == 0) {
            Iterator iconIter = this._palettePage.getPaletteItems().iterator();
            this._iconList.add(new PaletteItemUI(new PaletteItemImpl(true)));
            while (iconIter.hasNext()) {
                PaletteItemImpl pi = (PaletteItemImpl)iconIter.next();
                if (pi == null) continue;
                this._iconList.add(new PaletteItemUI(pi));
            }
            this.setIconList(this._iconList);
        }
    }

    public abstract void addItem(Item var1);

    public abstract void removeActiveItem();

    public abstract void removeItem(Item var1);

    public void renameItem(String oldName, PaletteItemImpl item) {
        for (PaletteItemUI ui : this._iconList) {
            if (ui.getItem().getShortLabel().equals(oldName)) {
                ui.setItem(item);
                ui.showLabel(this.getListView());
            }
            ui.validate();
        }
    }

    public abstract void setup(JComboBox var1);

    public void refreshListView() {
        this.useListView(this.getListView());
    }

    public abstract void validateScroll();
}

