/*
 * Decompiled with CFR 0.152.
 */
package oracle.ideimpl.markers.adapters;

import java.net.URL;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.ide.adapters.AdapterFactory;
import oracle.ide.markers.TextMarker;
import oracle.ide.model.Node;
import oracle.ide.model.NodeFactory;
import oracle.ide.model.TextNode;
import oracle.ide.navigation.NavigationContext;
import oracle.javatools.buffer.LineMap;
import oracle.javatools.buffer.TextBuffer;

public class TextMarkerToNavigationContextAdapterFactory
implements AdapterFactory<TextMarker, NavigationContext> {
    private static final Logger LOGGER = Logger.getLogger(TextMarkerToNavigationContextAdapterFactory.class.getName());

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public NavigationContext adapt(TextMarker marker) {
        NavigationContext navContext;
        block8: {
            if (null == marker) {
                return null;
            }
            navContext = new NavigationContext();
            navContext.set(NavigationContext.ContextKey.Context, (Object)marker.context());
            try {
                URL url = marker.markable().getUrl();
                navContext.set(NavigationContext.ContextKey.Url, (Object)url);
                Node node = NodeFactory.findOrCreate((URL)url);
                if (null != node) {
                    navContext.set(NavigationContext.ContextKey.Node, (Object)node);
                }
                if (!(node instanceof TextNode)) break block8;
                TextNode textNode = (TextNode)node;
                try {
                    TextBuffer buffer = textNode.acquireTextBuffer();
                    if (null != buffer) {
                        LineMap lineMap = buffer.getLineMap();
                        int line = lineMap.getLineFromOffset(marker.offset());
                        navContext.set(NavigationContext.ContextKey.Line, (Object)(++line));
                    }
                }
                finally {
                    textNode.releaseTextBuffer();
                }
            }
            catch (Exception e) {
                if (!LOGGER.isLoggable(Level.INFO)) break block8;
                LOGGER.log(Level.INFO, e.getMessage(), e);
            }
        }
        return navContext;
    }
}

