/*
 * Decompiled with CFR 0.152.
 */
package oracle.ide.markers;

import java.text.MessageFormat;
import javax.swing.Icon;
import oracle.ide.markers.res.MarkersBundle;
import oracle.ide.model.Displayable;
import oracle.javatools.icons.OracleIcons;

public enum MarkerScope implements Displayable
{
    FILE_SCOPE("file.png"),
    PROJECT_SCOPE("project.png"),
    WORKING_SET_SCOPE("workingsets.png"),
    WORKSPACE_SCOPE("application.png");

    public static final String ACTION_NAME_FMT = "oracle.ide.markers.scope.{0}";
    private final transient Icon icon;

    private MarkerScope(String iconKey) {
        this.icon = OracleIcons.getIcon((String)iconKey);
    }

    public String getShortLabel() {
        return MarkersBundle.get(this.toString());
    }

    public String getLongLabel() {
        return MarkersBundle.get(MessageFormat.format("{0}_DESC", this.toString()));
    }

    public Icon getIcon() {
        return this.icon;
    }

    public String getToolTipText() {
        return this.getLongLabel();
    }

    public String getActionCommandName() {
        return MessageFormat.format(ACTION_NAME_FMT, this.toString());
    }
}

