/*
 * Decompiled with CFR 0.152.
 */
package oracle.ide.markers;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import oracle.ide.markers.MarkerJob;
import oracle.ide.markers.MarkerJobProvider;
import oracle.ide.markers.MarkerJobProviderDescriptor;
import oracle.ide.markers.MarkerScope;
import oracle.javatools.util.Pair;
import org.openide.util.RequestProcessor;
import org.openide.util.Task;
import org.openide.util.TaskListener;

public class MarkerProvider
implements TaskListener {
    private final MarkerJobProviderDescriptor descriptor;
    private final RequestProcessor processor;
    private MarkerJobProvider jobProvider;
    private final Map<MarkerScope, Pair<RequestProcessor.Task, MarkerJob>> tasksByScope = new HashMap<MarkerScope, Pair<RequestProcessor.Task, MarkerJob>>();

    private MarkerProvider(MarkerJobProviderDescriptor descriptor) {
        this.descriptor = descriptor;
        this.processor = new RequestProcessor(this.getClass().getName(), 1, true);
    }

    public final void startProcessingFor(MarkerScope scope) {
        Pair<RequestProcessor.Task, MarkerJob> pair = this.tasksByScope.get((Object)scope);
        if (null == pair) {
            pair = this.newTaskFor(scope);
            if (null == pair) {
                return;
            }
            this.tasksByScope.put(scope, pair);
            ((RequestProcessor.Task)pair.first).schedule(0);
        }
        if (((RequestProcessor.Task)pair.first).isFinished()) {
            ((RequestProcessor.Task)pair.first).schedule(0);
        }
    }

    public final void stopProcessingFor(MarkerScope scope) {
        Pair<RequestProcessor.Task, MarkerJob> pair = this.tasksByScope.get((Object)scope);
        if (null != pair) {
            ((RequestProcessor.Task)pair.first).cancel();
        }
    }

    public final boolean isProcessingFor(MarkerScope scope) {
        Pair<RequestProcessor.Task, MarkerJob> pair = this.tasksByScope.get((Object)scope);
        return null != pair;
    }

    private Pair<RequestProcessor.Task, MarkerJob> newTaskFor(MarkerScope scope) {
        MarkerJob job = this.getJobProvider().getJobFor(scope);
        if (null == job) {
            return null;
        }
        RequestProcessor.Task task = this.processor.create((Runnable)job);
        task.setPriority(1);
        task.addTaskListener((TaskListener)this);
        return new Pair((Object)task, (Object)job);
    }

    private MarkerJobProvider getJobProvider() {
        if (null == this.jobProvider) {
            this.jobProvider = this.initJobProvider();
        }
        return this.jobProvider;
    }

    public void taskFinished(Task task) {
        MarkerJobProvider jobProvider = this.getJobProvider();
        Collection<Pair<RequestProcessor.Task, MarkerJob>> pairs = this.tasksByScope.values();
        Iterator<Pair<RequestProcessor.Task, MarkerJob>> iterator = pairs.iterator();
        while (iterator.hasNext()) {
            Pair<RequestProcessor.Task, MarkerJob> pair = iterator.next();
            if (task != pair.first) continue;
            if (null == jobProvider || jobProvider.shouldRemoveJob((MarkerJob)pair.second)) {
                iterator.remove();
            }
            return;
        }
    }

    private MarkerJobProvider initJobProvider() {
        return this.descriptor.getJobProvider();
    }

    public static class Factory {
        private static final Map<MarkerJobProviderDescriptor, MarkerProvider> PROVIDERS_BY_JOB_PROVIDER_DESCRIPTOR = new HashMap<MarkerJobProviderDescriptor, MarkerProvider>();

        public static MarkerProvider getMarkerProviderFor(MarkerJobProviderDescriptor descriptor) {
            if (null == descriptor) {
                return null;
            }
            MarkerProvider provider = PROVIDERS_BY_JOB_PROVIDER_DESCRIPTOR.get(descriptor);
            if (null != provider) {
                return provider;
            }
            provider = new MarkerProvider(descriptor);
            PROVIDERS_BY_JOB_PROVIDER_DESCRIPTOR.put(descriptor, provider);
            return provider;
        }

        public static List<MarkerProvider> getMarkerProviders() {
            ArrayList<MarkerProvider> providers = new ArrayList<MarkerProvider>(PROVIDERS_BY_JOB_PROVIDER_DESCRIPTOR.values());
            return Collections.unmodifiableList(providers);
        }
    }
}

