/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pdfbox;

import java.io.File;
import java.io.IOException;
import java.util.Iterator;
import org.apache.pdfbox.cos.COSBase;
import org.apache.pdfbox.cos.COSObject;
import org.apache.pdfbox.cos.COSStream;
import org.apache.pdfbox.exceptions.COSVisitorException;
import org.apache.pdfbox.exceptions.CryptographyException;
import org.apache.pdfbox.exceptions.InvalidPasswordException;
import org.apache.pdfbox.pdmodel.PDDocument;

public class WriteDecodedDoc {
    private static final String PASSWORD = "-password";
    private static final String NONSEQ = "-nonSeq";

    public void doIt(String in, String out) throws IOException, COSVisitorException {
        this.doIt(in, out, "", false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void doIt(String in, String out, String password, boolean useNonSeqParser) throws IOException, COSVisitorException {
        PDDocument doc = null;
        try {
            if (useNonSeqParser) {
                doc = PDDocument.loadNonSeq(new File(in), null, password);
                doc.setAllSecurityToBeRemoved(true);
            } else {
                doc = PDDocument.load(in);
                if (doc.isEncrypted()) {
                    try {
                        doc.decrypt(password);
                        doc.setAllSecurityToBeRemoved(true);
                    }
                    catch (InvalidPasswordException e) {
                        if (password.trim().length() == 0) {
                            System.err.println("Password needed!!");
                        } else {
                            System.err.println("Wrong password!!");
                        }
                        Object var10_9 = null;
                        if (doc == null) return;
                        doc.close();
                        return;
                    }
                    catch (CryptographyException e) {
                        e.printStackTrace();
                        Object var10_10 = null;
                        if (doc == null) return;
                        doc.close();
                        return;
                    }
                }
            }
            Iterator<COSObject> i = doc.getDocument().getObjects().iterator();
            while (i.hasNext()) {
                COSBase base = i.next().getObject();
                if (!(base instanceof COSStream)) continue;
                COSStream cosStream = (COSStream)base;
                cosStream.getUnfilteredStream();
                cosStream.setFilters(null);
            }
            doc.save(out);
            Object var10_11 = null;
            if (doc == null) return;
        }
        catch (Throwable throwable) {
            Object var10_12 = null;
            if (doc == null) throw throwable;
            doc.close();
            throw throwable;
        }
        doc.close();
    }

    public static void main(String[] args) {
        WriteDecodedDoc app = new WriteDecodedDoc();
        String password = "";
        boolean useNonSeqParser = false;
        String pdfFile = null;
        String outputFile = null;
        for (int i = 0; i < args.length; ++i) {
            if (args[i].equals(PASSWORD)) {
                if (++i >= args.length) {
                    WriteDecodedDoc.usage();
                }
                password = args[i];
                continue;
            }
            if (args[i].equals(NONSEQ)) {
                useNonSeqParser = true;
                continue;
            }
            if (pdfFile == null) {
                pdfFile = args[i];
                continue;
            }
            outputFile = args[i];
        }
        if (pdfFile == null) {
            WriteDecodedDoc.usage();
        } else {
            try {
                if (outputFile == null) {
                    outputFile = WriteDecodedDoc.calculateOutputFilename(pdfFile);
                }
                app.doIt(pdfFile, outputFile, password, useNonSeqParser);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    private static String calculateOutputFilename(String filename) {
        String outputFilename = filename.toLowerCase().endsWith(".pdf") ? filename.substring(0, filename.length() - 4) : filename;
        outputFilename = outputFilename + "_unc.pdf";
        return outputFilename;
    }

    private static void usage() {
        System.err.println("usage: java -jar pdfbox-app-x.y.z.jar WriteDecodedDoc [OPTIONS] <input-file> [output-file]\n  -password <password>      Password to decrypt the document\n  -nonSeq                   Enables the new non-sequential parser\n  <input-file>              The PDF document to be decompressed\n  [output-file]             The filename for the decompressed pdf\n");
    }
}

