/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.migration.workbench.core.ui;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.LayoutManager;
import java.awt.Toolkit;
import java.awt.datatransfer.StringSelection;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.io.OutputStream;
import java.io.PrintStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.logging.Formatter;
import java.util.logging.Handler;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import java.util.logging.Logger;
import javax.swing.BorderFactory;
import javax.swing.DefaultListCellRenderer;
import javax.swing.Icon;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JList;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JScrollPane;
import javax.swing.JTree;
import javax.swing.SwingUtilities;
import javax.swing.ToolTipManager;
import javax.swing.tree.DefaultTreeCellRenderer;
import javax.swing.tree.TreeCellRenderer;
import javax.swing.tree.TreePath;
import oracle.bali.share.nls.StringUtils;
import oracle.dbtools.metadata.persistence.DBObjectId;
import oracle.dbtools.metadata.persistence.PersistenceManager;
import oracle.dbtools.migration.workbench.core.MigrationAddin;
import oracle.dbtools.migration.workbench.core.MigrationAddinArb;
import oracle.dbtools.migration.workbench.core.logging.ClickableLogInfo;
import oracle.dbtools.migration.workbench.core.logging.LogInfo;
import oracle.dbtools.migration.workbench.core.logging.MigrationLogHandler;
import oracle.dbtools.migration.workbench.core.logging.MigrationLogUtil;
import oracle.dbtools.migration.workbench.core.navigator.CapturedConnectionNode;
import oracle.dbtools.migration.workbench.core.navigator.CapturedDatabases;
import oracle.dbtools.migration.workbench.core.navigator.ConvertedConnectionNode;
import oracle.dbtools.migration.workbench.core.navigator.ConvertedDatabases;
import oracle.dbtools.migration.workbench.core.navigator.MigrationConnectionNode;
import oracle.dbtools.migration.workbench.core.ui.Messages;
import oracle.dbtools.migration.workbench.core.ui.TreeTableFilterImpl;
import oracle.dbtools.migration.workbench.core.ui.treeTable.FilteredMigrationLogModel;
import oracle.dbtools.migration.workbench.core.ui.treeTable.MigrationLogModel;
import oracle.dbtools.migration.workbench.core.ui.treeTable.MigrationTreeNode;
import oracle.dbtools.raptor.ui.URLFileChooser;
import oracle.ide.Context;
import oracle.ide.Ide;
import oracle.ide.IdeMainWindow;
import oracle.ide.controller.ContextMenu;
import oracle.ide.controller.ContextMenuListener;
import oracle.ide.controller.Controller;
import oracle.ide.controller.IdeAction;
import oracle.ide.controller.MenuConstants;
import oracle.ide.controls.JTreeTable;
import oracle.ide.controls.ToggleAction;
import oracle.ide.controls.Toolbar;
import oracle.ide.controls.TreeTableModel;
import oracle.ide.controls.WaitCursor;
import oracle.ide.help.HelpInfo;
import oracle.ide.layout.ViewId;
import oracle.ide.log.AbstractLogPage;
import oracle.ide.log.LogManager;
import oracle.ide.model.Observer;
import oracle.ide.model.UpdateMessage;
import oracle.ide.net.URLFileSystem;
import oracle.ide.resource.IdeArb;
import oracle.ide.resource.LogArb;
import oracle.ide.util.IdeUtil;
import oracle.ide.view.View;
import oracle.ide.view.ViewEvent;
import oracle.ide.view.ViewListener;
import oracle.javatools.dialogs.ExceptionDialog;
import oracle.javatools.icons.OracleIcons;

public class MigrationTreeTableLogPage
extends AbstractLogPage {
    private static final String VIEW_LOG_DETAILS_CMD_ID_NAME = "ViewMigrationLogDetails";
    private static final int MAX_ASYNC_MESSAGES = 10;
    private static final int ASYNC_THREAD_SLEEP = 1000;
    private List<LogRecord> _asyncMessages = new ArrayList<LogRecord>(10);
    private Thread _updateThread = null;
    private JMenuItem _copyMenu;
    private JMenuItem _saveAsMenu;
    private JMenuItem _viewDetailsMenu;
    private boolean _popupMenuItemsInitialized;
    private JScrollPane _scrollPane;
    private MigrationLogPageController _controller;
    private JTreeTable _treeTable;
    private FilteredMigrationLogModel _filteredMigrationLogModel;
    private static URL s_lastSaveToFileURL = null;
    private Toolbar _toolbar;
    private JComboBox _migrationConnComboBox;
    private int _swingLogEventCount = 0;

    public MigrationTreeTableLogPage() {
        super(new ViewId("MigrationTreeTablePageId", MigrationAddinArb.getString("MIGRATION_LOG_TITLE")), null, false);
        this.initGUI();
        this.initPopupMenuItems();
        this.refreshConnectionNodes();
    }

    private void initGUI() {
        MigrationLogModel migrationLogModel = new MigrationLogModel();
        this._filteredMigrationLogModel = new FilteredMigrationLogModel(migrationLogModel, new TreeTableFilterImpl());
        this._treeTable = new JTreeTable((TreeTableModel)this._filteredMigrationLogModel);
        final JTreeTable.TreeTableCellRenderer treeTableCellRenderer = (JTreeTable.TreeTableCellRenderer)this._treeTable.getDefaultRenderer(TreeTableModel.class);
        treeTableCellRenderer.setRootVisible(false);
        treeTableCellRenderer.setCellRenderer((TreeCellRenderer)new DefaultTreeCellRenderer(){

            @Override
            public Component getTreeCellRendererComponent(JTree jTree, Object object, boolean bl, boolean bl2, boolean bl3, int n, boolean bl4) {
                this.setOpenIcon(OracleIcons.getIcon((String)"collapseall.png"));
                this.setClosedIcon(OracleIcons.getIcon((String)"expandall.png"));
                if (object instanceof MigrationTreeNode) {
                    LogRecord logRecord = ((MigrationTreeNode)object).getUserObject();
                    if (logRecord.getLevel() == Level.WARNING) {
                        this.setLeafIcon(OracleIcons.getIcon((String)"warning.png"));
                    } else if (logRecord.getLevel() == Level.SEVERE) {
                        this.setLeafIcon(OracleIcons.getIcon((String)"error.png"));
                    } else {
                        this.setLeafIcon(OracleIcons.getIcon((String)"info.png"));
                    }
                }
                return super.getTreeCellRendererComponent(jTree, object, bl, bl2, bl3, n, bl4);
            }
        });
        ToolTipManager.sharedInstance().registerComponent((JComponent)this._treeTable);
        this._scrollPane = new JScrollPane((Component)this._treeTable);
        this._scrollPane.setBorder(BorderFactory.createEmptyBorder());
        MouseAdapter mouseAdapter = new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent mouseEvent) {
                if (mouseEvent == null || mouseEvent.getClickCount() != 2) {
                    return;
                }
                TreePath treePath = treeTableCellRenderer.getSelectionPath();
                if (treePath != null && treePath.getLastPathComponent() != null) {
                    MigrationTreeTableLogPage.this.activateObject(treePath.getLastPathComponent());
                }
            }
        };
        KeyAdapter keyAdapter = new KeyAdapter(){

            @Override
            public void keyTyped(KeyEvent keyEvent) {
                if (keyEvent == null || keyEvent.isConsumed() || keyEvent.getKeyChar() != '\n') {
                    return;
                }
                Object object = MigrationTreeTableLogPage.this._filteredMigrationLogModel.getValueAt(MigrationTreeTableLogPage.this._treeTable.getSelectedRow(), 0);
                if (object != null) {
                    MigrationTreeTableLogPage.this.activateObject(object);
                }
            }
        };
        this._treeTable.addMouseListener((MouseListener)mouseAdapter);
        this._treeTable.addKeyListener((KeyListener)keyAdapter);
        this._treeTable.setShowVerticalLines(true);
        this._treeTable.setShowHorizontalLines(true);
        this._treeTable.setAutoResizeMode(0);
        this._scrollPane.addComponentListener(new ComponentAdapter(){

            @Override
            public void componentResized(ComponentEvent componentEvent) {
                MigrationTreeTableLogPage.this.initColumnSizes();
            }
        });
        this._treeTable.getColumn((Object)MigrationLogModel.SOURCE).setWidth(120);
        this._treeTable.getColumn((Object)MigrationLogModel.SOURCE).setPreferredWidth(120);
        this._treeTable.getColumn((Object)MigrationLogModel.DATE).setWidth(120);
        this._treeTable.getColumn((Object)MigrationLogModel.DATE).setPreferredWidth(120);
        this.addToolBar();
    }

    private void addToolBar() {
        this._toolbar = new Toolbar();
        this._toolbar.setLayout((LayoutManager)new BorderLayout());
        this._migrationConnComboBox = new JComboBox();
        this._toolbar.add((Component)this._migrationConnComboBox, (Object)"East");
        this._migrationConnComboBox.setSize(160, 20);
        this._migrationConnComboBox.setPreferredSize(this._migrationConnComboBox.getSize());
        this._migrationConnComboBox.setMaximumSize(this._migrationConnComboBox.getSize());
        this.setToolbarVisible(true);
        this._migrationConnComboBox.setRenderer(new DefaultListCellRenderer(){

            @Override
            public Component getListCellRendererComponent(JList jList, Object object, int n, boolean bl, boolean bl2) {
                Object object2 = object;
                if (object instanceof MigrationConnectionNode) {
                    object2 = ((MigrationConnectionNode)object).getShortLabel();
                }
                return super.getListCellRendererComponent((JList<?>)jList, object2, n, bl, bl2);
            }
        });
        this._migrationConnComboBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                if (MigrationTreeTableLogPage.this._migrationConnComboBox.getSelectedItem() != null) {
                    MigrationConnectionNode migrationConnectionNode = (MigrationConnectionNode)MigrationTreeTableLogPage.this._migrationConnComboBox.getSelectedItem();
                    MigrationTreeTableLogPage.this._migrationConnComboBox.setToolTipText(migrationConnectionNode.getMdConnection().getName());
                    MigrationTreeTableLogPage.this.setFilterBy(migrationConnectionNode.getMdConnection().getKey());
                }
            }
        });
        this.addViewListener(new ViewListener(){

            public void viewActivated(ViewEvent viewEvent) {
                View.updateToolbarActions((Toolbar)MigrationTreeTableLogPage.this._toolbar);
            }

            public void viewClosed(ViewEvent viewEvent) {
            }

            public void viewDeactivated(ViewEvent viewEvent) {
            }
        });
        Observer observer = new Observer(){

            public void update(Object object, UpdateMessage updateMessage) {
                ArrayList arrayList = new ArrayList(updateMessage.getAddObjects());
                if (updateMessage.getMessageID() == UpdateMessage.STRUCTURE_CHANGED || updateMessage.getMessageID() == UpdateMessage.OBJECT_RENAMED || updateMessage.getMessageID() == UpdateMessage.OBJECT_CLOSING || arrayList.size() > 0 && arrayList.get(0) instanceof MigrationConnectionNode) {
                    MigrationTreeTableLogPage.this.refreshConnectionNodes();
                }
            }
        };
        CapturedDatabases.getInstance().attach(observer);
        ConvertedDatabases.getInstance().attach(observer);
    }

    private synchronized void refreshConnectionNodes() {
        MigrationConnectionNode[] migrationConnectionNodeArray;
        this._migrationConnComboBox.removeAllItems();
        for (MigrationConnectionNode migrationConnectionNode : migrationConnectionNodeArray = this.getMigrationConnections()) {
            this._migrationConnComboBox.addItem(migrationConnectionNode);
        }
        if (migrationConnectionNodeArray.length > 0) {
            this._migrationConnComboBox.setToolTipText(migrationConnectionNodeArray[0].getMdConnection().getName());
        }
    }

    private MigrationConnectionNode[] getMigrationConnections() {
        ArrayList<MigrationConnectionNode> arrayList = new ArrayList<MigrationConnectionNode>();
        PersistenceManager persistenceManager = MigrationAddin.getPersistenceManager();
        if (persistenceManager == null) {
            return new MigrationConnectionNode[0];
        }
        try {
            Iterator iterator = CapturedDatabases.getInstance().getChildren();
            if (iterator != null) {
                while (iterator.hasNext()) {
                    arrayList.add((CapturedConnectionNode)iterator.next());
                }
            }
            if ((iterator = ConvertedDatabases.getInstance().getChildren()) != null) {
                while (iterator.hasNext()) {
                    arrayList.add((ConvertedConnectionNode)iterator.next());
                }
            }
        }
        catch (Exception exception) {
            Logger.getLogger(((Object)((Object)this)).getClass().getName()).log(Level.WARNING, exception.getStackTrace()[0].toString(), exception);
        }
        return arrayList.toArray(new MigrationConnectionNode[0]);
    }

    public Toolbar getToolbar() {
        return this._toolbar;
    }

    private void initColumnSizes() {
        int n = this._scrollPane.getWidth() - this._scrollPane.getInsets().right - this._scrollPane.getInsets().left;
        int n2 = this._treeTable.getColumnModel().getColumnIndex(MigrationLogModel.MESSAGE);
        for (int i = 0; i < this._treeTable.getColumnCount(); ++i) {
            if (i == n2) continue;
            n -= this._treeTable.getColumnModel().getColumn(i).getWidth();
        }
        this._treeTable.getColumnModel().getColumn(n2).setPreferredWidth(n);
    }

    private void initPopupMenuItems() {
        if (!this._popupMenuItemsInitialized) {
            this._popupMenuItemsInitialized = true;
            ContextMenu contextMenu = LogManager.getLogManager().getContextMenu();
            IdeAction ideAction = null;
            ideAction = IdeAction.find((int)18);
            this._copyMenu = contextMenu.createMenuItem((ToggleAction)ideAction, MenuConstants.WEIGHT_EDIT_COPY);
            ideAction = IdeAction.find((int)12);
            ideAction.addController(new Controller(){

                public boolean update(IdeAction ideAction, Context context) {
                    if (MigrationTreeTableLogPage.this._controller != null) {
                        MigrationTreeTableLogPage.this._controller.update(ideAction, context);
                    }
                    return true;
                }

                public boolean handleEvent(IdeAction ideAction, Context context) {
                    return false;
                }
            });
            this._saveAsMenu = contextMenu.createMenuItem((ToggleAction)ideAction, MenuConstants.WEIGHT_LOG_WINDOW_SAVE_AS);
            int n = Ide.findOrCreateCmdID((String)VIEW_LOG_DETAILS_CMD_ID_NAME);
            IdeAction ideAction2 = IdeAction.get((int)n, null, (String)MigrationAddinArb.getString("MENU_LOG_DETAILS"), (String)IdeMainWindow.ACTION_CATEGORY_VIEW, (Integer)StringUtils.getMnemonicKeyCode((String)MigrationAddinArb.getString("MENU_LOG_DETAILS")), null, null, (boolean)true);
            this._viewDetailsMenu = contextMenu.createMenuItem((ToggleAction)ideAction2);
            ideAction2.addController(new Controller(){

                public boolean handleEvent(IdeAction ideAction, Context context) {
                    JTreeTable.TreeTableCellRenderer treeTableCellRenderer;
                    TreePath[] treePathArray;
                    if (Ide.findCmdName((int)ideAction.getCommandId()).equals(MigrationTreeTableLogPage.VIEW_LOG_DETAILS_CMD_ID_NAME) && (treePathArray = (treeTableCellRenderer = (JTreeTable.TreeTableCellRenderer)MigrationTreeTableLogPage.this._treeTable.getDefaultRenderer(TreeTableModel.class)).getSelectionPaths()) != null && treePathArray.length == 1) {
                        LogRecord logRecord = ((MigrationTreeNode)treePathArray[0].getLastPathComponent()).getUserObject();
                        String string = treePathArray[0].getLastPathComponent().toString();
                        Throwable throwable = logRecord.getThrown();
                        if (throwable != null) {
                            ExceptionDialog.showExceptionDialog((Component)IdeUtil.getMainWindow(), (Throwable)throwable, (String)MigrationAddinArb.getString("MENU_LOG_DETAILS"), (String)string, null);
                        } else {
                            int n = 1;
                            Icon icon = OracleIcons.getIcon((String)"info.png");
                            if (logRecord.getLevel() == Level.WARNING) {
                                n = 2;
                                icon = OracleIcons.getIcon((String)"warning.png");
                            } else if (logRecord.getLevel() == Level.SEVERE) {
                                n = 0;
                                icon = OracleIcons.getIcon((String)"error.png");
                            }
                            JOptionPane.showMessageDialog(IdeUtil.getMainWindow(), string, logRecord.getLevel().getLocalizedName(), n, icon);
                        }
                    }
                    return true;
                }

                public boolean update(IdeAction ideAction, Context context) {
                    int n = MigrationTreeTableLogPage.this._treeTable.getSelectedRowCount();
                    ideAction.setEnabled(n == 1);
                    return true;
                }
            });
            contextMenu.addContextMenuListener((ContextMenuListener)new PrivateContextMenuListener());
        }
    }

    public ContextMenu getContextMenu() {
        ContextMenu contextMenu = LogManager.getLogManager().getContextMenu();
        return contextMenu;
    }

    public void addMouseListener(MouseListener mouseListener) {
        if (mouseListener != null) {
            this._treeTable.addMouseListener(mouseListener);
        }
    }

    public void removeMouseListener(MouseListener mouseListener) {
        if (mouseListener != null) {
            this._treeTable.removeMouseListener(mouseListener);
        }
    }

    public void addKeyListener(KeyListener keyListener) {
        if (keyListener != null) {
            this._treeTable.addKeyListener(keyListener);
        }
    }

    public void removeKeyListener(KeyListener keyListener) {
        if (keyListener != null) {
            this._treeTable.removeKeyListener(keyListener);
        }
    }

    private void copy(TreePath[] treePathArray) {
        StringBuffer stringBuffer = new StringBuffer();
        for (TreePath treePath : treePathArray) {
            Object object = treePath.getLastPathComponent();
            if (!(object instanceof MigrationTreeNode)) continue;
            stringBuffer.append(object.toString());
            stringBuffer.append("\n");
        }
        StringSelection stringSelection = new StringSelection(stringBuffer.toString());
        Toolkit.getDefaultToolkit().getSystemClipboard().setContents(stringSelection, null);
    }

    protected void saveToFile(Context context) {
        URL uRL;
        if (this._treeTable == null || this._treeTable.getRowCount() <= 0) {
            return;
        }
        String string = LogArb.getString((int)13);
        URLFileChooser uRLFileChooser = new URLFileChooser(context);
        uRLFileChooser.setHelpID("f1_idedsaveasrename_html");
        if (s_lastSaveToFileURL != null) {
            uRLFileChooser.setSelectedURL(s_lastSaveToFileURL);
        }
        if (uRLFileChooser.showSaveDialog((Component)Ide.getMainWindow(), string) == 0 && (uRL = uRLFileChooser.getSelectedURL()) != null) {
            s_lastSaveToFileURL = uRL;
            WaitCursor waitCursor = Ide.getWaitCursor();
            waitCursor.show();
            try {
                String string2 = Ide.getEnvironOptions().getEncoding();
                OutputStream outputStream = URLFileSystem.openOutputStream((URL)uRL);
                PrintStream printStream = string2 == null ? new PrintStream(outputStream) : new PrintStream(outputStream, false, string2);
                for (int i = 0; i < this._treeTable.getRowCount(); ++i) {
                    printStream.println(this._treeTable.getValueAt(i, 0).toString());
                }
                printStream.flush();
                printStream.close();
            }
            catch (Exception exception) {
                String string3 = URLFileSystem.getPlatformPathName((URL)uRL);
                String string4 = LogArb.format((int)29, (Object)string3);
                JOptionPane.showMessageDialog((Component)Ide.getMainWindow(), string4, IdeArb.getString((int)240), 0);
            }
            waitCursor.hide();
        }
    }

    public Controller getController() {
        if (this._controller == null) {
            this._controller = new MigrationLogPageController();
        }
        return this._controller;
    }

    public void log(Object object) {
        if (!(object instanceof LogRecord)) {
            this.requestShow();
            this.activate();
        }
        this.logMsg(object);
    }

    public Component getGUI() {
        return this._scrollPane;
    }

    protected String fixMessages(LogRecord logRecord, Formatter formatter) {
        String string = logRecord.getMessage();
        if (string == null) {
            string = "";
        }
        if (formatter != null) {
            string = formatter.format(logRecord);
        }
        string = string.replace('\r', ' ').replace('\n', ' ').replace('\t', ' ');
        return string;
    }

    protected void activateObject(Object object) {
        MigrationTreeNode migrationTreeNode;
        LogRecord logRecord;
        if (object instanceof MigrationTreeNode && MigrationLogUtil.searchParameterByType((logRecord = (migrationTreeNode = (MigrationTreeNode)object).getUserObject()).getParameters(), ClickableLogInfo.class).size() > 0) {
            MigrationLogHandler.getInstance().notifyListeners(logRecord);
        }
    }

    public HelpInfo getHelpInfo() {
        return new HelpInfo("f1_com_logwindow_html");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void logMsg(Object object) {
        if (object instanceof LogRecord) {
            List<LogRecord> list = this._asyncMessages;
            synchronized (list) {
                this._asyncMessages.add((LogRecord)object);
                if (this._asyncMessages.size() == 10) {
                    this.processAsyncMsgQueue(10);
                }
            }
        } else {
            super.logMsg(object);
        }
    }

    public boolean isLogQueueEmpty() {
        return this._swingLogEventCount <= 0 && this._asyncMessages.size() == 0;
    }

    public void startAsynchronousLogging() {
        this._updateThread = new Thread("Log Page Updater"){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                while (MigrationTreeTableLogPage.this._updateThread == this) {
                    try {
                        Thread.sleep(1000L);
                        List list = MigrationTreeTableLogPage.this._asyncMessages;
                        synchronized (list) {
                            if (MigrationTreeTableLogPage.this._asyncMessages.size() > 0) {
                                MigrationTreeTableLogPage.this.processAsyncMsgQueue(10);
                            }
                        }
                    }
                    catch (InterruptedException interruptedException) {
                    }
                }
            }
        };
        this._updateThread.setPriority(this._updateThread.getPriority() - 1);
        this._updateThread.start();
    }

    public void finishAsynchronousLogging() {
        this._updateThread = null;
        this.processAsyncMsgQueue(-1);
        if (this._treeTable.getRowCount() > 0) {
            this.requestShow();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void processAsyncMsgQueue(int n) {
        LogRecord[] logRecordArray;
        Object object = this._asyncMessages;
        synchronized (object) {
            int n2 = this._asyncMessages.size();
            int n3 = n > 0 && n2 > n ? n : n2;
            logRecordArray = new LogRecord[n3];
            ++this._swingLogEventCount;
            for (int i = 0; i < n3; ++i) {
                logRecordArray[i] = this._asyncMessages.remove(0);
            }
        }
        object = new Runnable(){

            @Override
            public void run() {
                MigrationTreeTableLogPage.this._swingLogEventCount--;
                if (logRecordArray.length > 0) {
                    for (LogRecord logRecord : logRecordArray) {
                        MigrationTreeTableLogPage.this.addMsg(logRecord);
                    }
                    MigrationTreeTableLogPage.this._treeTable.updateUI();
                }
            }
        };
        if (SwingUtilities.isEventDispatchThread()) {
            object.run();
        } else {
            SwingUtilities.invokeLater((Runnable)object);
        }
    }

    private void removeMessages(LogRecord logRecord) {
        int n = this.searchTableRow(logRecord);
        if (n < 0) {
            return;
        }
        this._filteredMigrationLogModel.getDelegateModel().getRoot().removeChildAt(n);
    }

    private int searchTableRow(LogRecord logRecord) {
        MigrationTreeNode migrationTreeNode = this._filteredMigrationLogModel.getRoot();
        for (int i = 0; i < migrationTreeNode.getChildCount(); ++i) {
            if (migrationTreeNode.getChildAt(i).getUserObject() != logRecord) continue;
            return i;
        }
        return -1;
    }

    private void addMsg(LogRecord logRecord) {
        int n;
        Handler[] handlerArray;
        if (this._scrollPane.getViewport().getView() != this._treeTable) {
            this._scrollPane.setViewportView((Component)this._treeTable);
        }
        if (this.handleSpecialLog(logRecord)) {
            return;
        }
        if (this._treeTable.getRowCount() == 0) {
            if (!LogManager.getLogManager().isLogVisible()) {
                LogManager.getLogManager().showLog();
            }
            if (!this.isVisible()) {
                this.requestShow();
            }
        }
        if (Ide.getMainWindow().getLastActiveView() == LogManager.getLogManager().getLogWindow()) {
            IdeUtil.tryToRestoreFocus((Component)this._treeTable);
        } else {
            this.requestShow();
        }
        Formatter formatter = null;
        if (logRecord.getLoggerName() != null && (handlerArray = Logger.getLogger(logRecord.getLoggerName()).getHandlers()) != null && handlerArray.length > 0) {
            formatter = handlerArray[0].getFormatter();
        }
        if ((n = this.insertLogRecursively(this._filteredMigrationLogModel.getRoot(), logRecord, formatter)) >= 0) {
            this._treeTable.scrollRectToVisible(this._treeTable.getCellRect(n, 0, true));
        }
    }

    private int insertLogRecursively(MigrationTreeNode migrationTreeNode, LogRecord logRecord, Formatter formatter) {
        String string = this.fixMessages(logRecord, formatter);
        int n = 0;
        MigrationTreeNode migrationTreeNode2 = null;
        n = 0;
        migrationTreeNode2 = migrationTreeNode.insertChildAt(n, string, logRecord);
        List<LogInfo> list = MigrationLogUtil.searchParameterByType(logRecord.getParameters(), LogInfo.class);
        if (list.size() == 1) {
            for (LogRecord logRecord2 : list.get(0).getChildRecords()) {
                this.insertLogRecursively(migrationTreeNode2, logRecord2, formatter);
            }
        }
        return n;
    }

    private boolean handleSpecialLog(LogRecord logRecord) {
        List<ENUM_LogKind> list = MigrationLogUtil.searchParameterByType(logRecord.getParameters(), ENUM_LogKind.class);
        if (list.size() == 1) {
            ENUM_LogKind eNUM_LogKind = list.get(0);
            if (eNUM_LogKind == ENUM_LogKind.START) {
                this.clearAll();
                return true;
            }
            if (eNUM_LogKind == ENUM_LogKind.REMOVE) {
                this.removeMessages(logRecord);
                return true;
            }
        }
        return false;
    }

    public void clearAll() {
        this._filteredMigrationLogModel.getRoot().removeAllChildren();
        this._treeTable.updateUI();
        super.clearAll();
    }

    public String getToolTip() {
        return Messages.getString("MigrationTreeTableLogPage.7");
    }

    public void setFilterBy(Object object) {
        this._filteredMigrationLogModel.setFiltered(object);
        this._treeTable.updateUI();
        if (this._migrationConnComboBox.getSelectedItem() == null) {
            return;
        }
        MigrationConnectionNode migrationConnectionNode = (MigrationConnectionNode)this._migrationConnComboBox.getSelectedItem();
        DBObjectId dBObjectId = migrationConnectionNode.getMdConnection().getKey();
        if (!dBObjectId.equals(object)) {
            for (int i = 0; i < this._migrationConnComboBox.getItemCount(); ++i) {
                MigrationConnectionNode migrationConnectionNode2 = (MigrationConnectionNode)this._migrationConnComboBox.getItemAt(i);
                if (!migrationConnectionNode2.getMdConnection().getKey().equals(object)) continue;
                this._migrationConnComboBox.setSelectedIndex(i);
                return;
            }
        }
    }

    private class PrivateContextMenuListener
    implements ContextMenuListener {
        private PrivateContextMenuListener() {
        }

        public void menuWillShow(ContextMenu contextMenu) {
            if (contextMenu == null) {
                return;
            }
            Context context = contextMenu.getContext();
            if (context == null || context.getView() != MigrationTreeTableLogPage.this) {
                return;
            }
            if (MigrationTreeTableLogPage.this._copyMenu != null) {
                contextMenu.add((Component)MigrationTreeTableLogPage.this._copyMenu, MenuConstants.SECTION_EDIT_CTXT_MENU);
            }
            if (MigrationTreeTableLogPage.this._saveAsMenu != null) {
                contextMenu.add((Component)MigrationTreeTableLogPage.this._saveAsMenu);
            }
            if (MigrationTreeTableLogPage.this._viewDetailsMenu != null) {
                contextMenu.add((Component)MigrationTreeTableLogPage.this._viewDetailsMenu, MenuConstants.SECTION_LOG_WINDOW_CTXT_MENU);
            }
        }

        public void menuWillHide(ContextMenu contextMenu) {
        }

        public boolean handleDefaultAction(Context context) {
            return false;
        }
    }

    private class MigrationLogPageController
    implements Controller {
        private MigrationLogPageController() {
        }

        public boolean handleEvent(IdeAction ideAction, Context context) {
            if (ideAction != null) {
                int n = ideAction.getCommandId();
                if (n == 18) {
                    JTreeTable.TreeTableCellRenderer treeTableCellRenderer = (JTreeTable.TreeTableCellRenderer)MigrationTreeTableLogPage.this._treeTable.getDefaultRenderer(TreeTableModel.class);
                    TreePath[] treePathArray = treeTableCellRenderer.getSelectionPaths();
                    if (treePathArray != null) {
                        MigrationTreeTableLogPage.this.copy(treePathArray);
                    }
                    return true;
                }
                if (n == 12) {
                    MigrationTreeTableLogPage.this.saveToFile(context);
                    return true;
                }
            }
            return false;
        }

        public boolean update(IdeAction ideAction, Context context) {
            if (ideAction == null) {
                return true;
            }
            int n = ideAction.getCommandId();
            if (n == 12) {
                ideAction.setEnabled(MigrationTreeTableLogPage.this._treeTable != null && MigrationTreeTableLogPage.this._treeTable.getRowCount() > 0);
                return true;
            }
            if (n == 18) {
                int n2 = MigrationTreeTableLogPage.this._treeTable.getSelectedRowCount();
                ideAction.setEnabled(n2 > 0);
                return true;
            }
            return false;
        }
    }

    public static enum ENUM_LogKind {
        START,
        END,
        REMOVE,
        CLEAR;

    }
}

