/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.migration.workbench.core.navigator.nodes;

import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.Icon;
import oracle.dbtools.metadata.persistence.CloseableIterator;
import oracle.dbtools.metadata.persistence.DBObjectId;
import oracle.dbtools.metadata.persistence.MdApplication;
import oracle.dbtools.metadata.persistence.PersistenceException;
import oracle.dbtools.metadata.persistence.PersistenceUtility;
import oracle.dbtools.migration.workbench.core.MigrationAddin;
import oracle.dbtools.migration.workbench.core.MigrationAddinArb;
import oracle.dbtools.migration.workbench.core.navigator.nodes.AbstractLoadChildrenTask;
import oracle.dbtools.migration.workbench.core.navigator.nodes.ApplicationNode;
import oracle.dbtools.migration.workbench.core.navigator.nodes.DefaultContainerCustomNode;
import oracle.dbtools.raptor.backgroundTask.RaptorTask;
import oracle.dbtools.raptor.backgroundTask.RaptorTaskManager;
import oracle.ide.explorer.IconOverlayCache;
import oracle.ide.model.Element;
import oracle.ide.model.Subject;
import oracle.ide.model.UpdateMessage;
import oracle.ide.net.URLFactory;
import oracle.javatools.icons.OracleIcons;

public class ApplicationsFolderNode
extends DefaultContainerCustomNode {
    protected static final Logger LOGGER = Logger.getLogger(ApplicationsFolderNode.class.getName());
    private DBObjectId _parentId;

    protected static void log(Throwable throwable) {
        String string = throwable.getMessage() + " - " + throwable.getStackTrace()[0].toString();
        LOGGER.log(Level.WARNING, string, throwable);
    }

    public ApplicationsFolderNode(DBObjectId dBObjectId) {
        this._parentId = dBObjectId;
        String string = this._parentId.toString();
        this.setURL(URLFactory.newURL((String)"sqldev.migration", (String)(MigrationAddin.getRepositoryConnectionName() + "/" + string + "/" + ApplicationsFolderNode.class.getSimpleName())));
    }

    public String getShortLabel() {
        return MigrationAddinArb.getString("APPLICATIONS_ROOT_LABEL");
    }

    public Icon getIcon() {
        return OracleIcons.getIcon((String)"applications.png");
    }

    protected ApplicationNode createMdApplicationNode(MdApplication mdApplication) {
        return new ApplicationNode(mdApplication);
    }

    protected ApplicationNode addChild(MdApplication mdApplication) {
        for (Object e : this._children) {
            ApplicationNode applicationNode;
            if (!(e instanceof ApplicationNode) || (applicationNode = (ApplicationNode)e).getMdApplication().getKey().getId() != mdApplication.getKey().getId()) continue;
            this.reload();
            return null;
        }
        ApplicationNode applicationNode = this.createMdApplicationNode(mdApplication);
        applicationNode.setParentElement((Element)this);
        this._children.add(applicationNode);
        return applicationNode;
    }

    private void reload() {
        IconOverlayCache iconOverlayCache = IconOverlayCache.getInstance();
        iconOverlayCache.clearOverlays("MigrationNodeInfoType");
        iconOverlayCache.fireOverlaysChanged();
        UpdateMessage.fireObjectReloaded((Subject)this);
        try {
            this.close();
            this.open();
        }
        catch (IOException iOException) {
            ApplicationsFolderNode.log(iOException);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean hasChildren() {
        boolean bl = false;
        CloseableIterator<?> closeableIterator = null;
        try {
            closeableIterator = this.getMdApplicationsIterator();
            if (closeableIterator.hasNext()) {
                bl = true;
            }
        }
        catch (PersistenceException persistenceException) {
            Logger.getLogger(this.getClass().getName()).log(Level.WARNING, persistenceException.getStackTrace()[0].toString(), persistenceException);
        }
        finally {
            if (closeableIterator != null) {
                closeableIterator.close();
            }
        }
        return bl;
    }

    private PersistenceUtility getPersistenceUtility() {
        return PersistenceUtility.getInstance(MigrationAddin.getPersitenceManager());
    }

    private CloseableIterator<?> getMdApplicationsIterator() throws PersistenceException {
        return this.getPersistenceUtility().getApplicationsForProject(this._parentId);
    }

    @Override
    protected void queueBackgroundLoadChildrenTask() {
        AbstractLoadChildrenTask abstractLoadChildrenTask = new AbstractLoadChildrenTask((Element)this){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            protected List<Element> doWork() {
                ArrayList<Element> arrayList = new ArrayList<Element>();
                CloseableIterator closeableIterator = null;
                try {
                    closeableIterator = ApplicationsFolderNode.this.getMdApplicationsIterator();
                    while (closeableIterator.hasNext()) {
                        MdApplication mdApplication = (MdApplication)closeableIterator.next();
                        ApplicationNode applicationNode = ApplicationsFolderNode.this.addChild(mdApplication);
                        if (applicationNode == null) continue;
                        arrayList.add((Element)applicationNode);
                    }
                }
                catch (PersistenceException persistenceException) {
                    this.log(persistenceException);
                }
                finally {
                    if (closeableIterator != null) {
                        closeableIterator.close();
                    }
                }
                return arrayList;
            }
        };
        RaptorTaskManager.getInstance().addTask((RaptorTask)abstractLoadChildrenTask);
    }

    @Override
    public String getObjectName() {
        return "MD_APPLICATIONS";
    }

    @Override
    public String getObjectType() {
        return "APPLICATIONS_FOLDER";
    }

    @Override
    public HashMap<String, Object> getDict() {
        if (null == this._dict) {
            this._dict = new HashMap();
            this._dict.put("IDPROJECT", this._parentId.toString());
        }
        return this._dict;
    }
}

