/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.migration.workbench.core.navigator.nodes;

import java.net.URL;
import java.sql.Connection;
import java.util.HashMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.Icon;
import oracle.dbtools.metadata.persistence.MdApplicationFile;
import oracle.dbtools.metadata.persistence.PersistableObject;
import oracle.dbtools.metadata.persistence.PersistenceManager;
import oracle.dbtools.migration.workbench.core.MigrationAddin;
import oracle.dbtools.migration.workbench.core.navigator.nodes.ApplicationNode;
import oracle.dbtools.migration.workbench.core.navigator.nodes.IPersistableObjectNode;
import oracle.dbtools.raptor.navigator.CustomNode;
import oracle.dbtools.raptor.navigator.impl.ViewableElement;
import oracle.dbtools.raptor.utils.Connections;
import oracle.ide.model.Element;
import oracle.ide.model.ElementAttributes;
import oracle.ide.model.Folder;
import oracle.ide.model.TextNode;
import oracle.ide.net.URLFactory;
import oracle.javatools.db.DBException;
import oracle.javatools.icons.OracleIcons;

public class ApplicationFileNode
extends TextNode
implements Folder,
CustomNode,
IPersistableObjectNode,
ViewableElement {
    protected static final Logger LOGGER = Logger.getLogger(ApplicationFileNode.class.getName());
    private static String SCANNED = "APP_FILE_SCANNED";
    private static String MODIFIED = "APP_FILE_MODIFIED";
    private static String BINARY = "APP_FILE_BINARY";
    URL _fileURL;
    private ApplicationNode _applicationNode;
    private MdApplicationFile _applicationFile;
    static final Icon FILE_ICON = OracleIcons.getIcon((String)"file.png");
    private HashMap<String, Object> _dict;
    private Element _parentElement;

    protected static void log(Throwable throwable) {
        String string = throwable.getMessage() + " - " + throwable.getStackTrace()[0].toString();
        LOGGER.log(Level.WARNING, string, throwable);
    }

    protected static void ignore(Throwable throwable) {
        assert (throwable != null || null == throwable);
    }

    public URL getFileURL() {
        String string = this._applicationNode.getFQPath(this._applicationFile.getUri());
        this._fileURL = URLFactory.newFileURL((String)string);
        return this._fileURL;
    }

    public URL getOriginalFileURL() {
        String string = this._applicationNode.getOriginalFQPath(this._applicationFile.getUri());
        URL uRL = URLFactory.newFileURL((String)string);
        return uRL;
    }

    public ApplicationFileNode(ApplicationNode applicationNode, MdApplicationFile mdApplicationFile) {
        assert (applicationNode != null);
        assert (mdApplicationFile != null);
        this._applicationNode = applicationNode;
        this._applicationFile = mdApplicationFile;
        this.setURL(this.getFileURL());
        this.getAttributes().set(ElementAttributes.DELETEABLE | ElementAttributes.RENAMEABLE);
    }

    public MdApplicationFile getMdApplicationFile() {
        return this._applicationFile;
    }

    public String getShortLabel() {
        return this.getMdApplicationFile().getName();
    }

    private String getFileBaseName() {
        String string = this.getMdApplicationFile().getName();
        int n = string.lastIndexOf(46);
        if (n > 1) {
            string = string.substring(0, n);
        }
        return string;
    }

    private String getFileExtension() {
        String string = this.getMdApplicationFile().getName();
        String string2 = null;
        int n = string.lastIndexOf(46);
        if (n > 1) {
            string2 = string.substring(n);
        }
        return string2;
    }

    public Icon getIcon() {
        return ApplicationNode.getIcon(this.getFileURL(), FILE_ICON, this.getFileBaseName(), this.getFileExtension());
    }

    public boolean mayHaveChildren() {
        return false;
    }

    public boolean canAdd(Element element) {
        return false;
    }

    public boolean add(Element element) {
        return false;
    }

    public boolean canRemove(Element element) {
        return false;
    }

    public boolean remove(Element element) {
        return false;
    }

    public boolean containsChild(Element element) {
        return false;
    }

    public int size() {
        return 0;
    }

    public void removeAll() {
    }

    public String getObjectName() {
        return "MD_APPLICATIONFILES";
    }

    public String getSchemaName() {
        String string = "";
        try {
            string = Connections.getInstance().getDatabase(this.getConn()).getUserName();
        }
        catch (DBException dBException) {
            ApplicationFileNode.log(dBException);
        }
        return string;
    }

    public String getObjectId() {
        return this.getMdApplicationFile().getKey().toString();
    }

    public String getObjectType() {
        if (this._applicationFile.getState().toLowerCase().equals("scanned")) {
            return SCANNED;
        }
        if (this._applicationFile.getState().toLowerCase().equals("modified")) {
            return MODIFIED;
        }
        if (this._applicationFile.getState().toLowerCase().equals("ignored")) {
            return BINARY;
        }
        return "APPLICATION_FILE";
    }

    public String getChildName() {
        return null;
    }

    public Object getObject() {
        return this.getMdApplicationFile();
    }

    public Connection getConn() {
        return MigrationAddin.getPersistenceManager().getConn();
    }

    public String getConnectionName() {
        return MigrationAddin.getRepositoryConnectionName();
    }

    public HashMap<String, Object> getDict() {
        if (null == this._dict) {
            this._dict = new HashMap();
            this._dict.put("IDAPPLICATIONFILE", this.getObjectId());
        }
        return this._dict;
    }

    public String getConnType() {
        return "MIGPROJ";
    }

    public String getCatalog() {
        return null;
    }

    @Override
    public PersistableObject getPersistableObject() {
        return this.getMdApplicationFile();
    }

    @Override
    public PersistenceManager getPersistenceManager() {
        return MigrationAddin.getPersistenceManager();
    }

    @Override
    public void setParentElement(Element element) {
        this._parentElement = element;
    }

    @Override
    public Element getParentElement() {
        return this._parentElement;
    }
}

